/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.integration;

import io.awspring.cloud.sqs.config.SqsMessageListenerContainerFactory;
import io.awspring.cloud.sqs.listener.MessageListener;
import io.awspring.cloud.sqs.listener.SqsContainerOptions;
import io.awspring.cloud.sqs.listener.SqsMessageListenerContainer;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

@ManagedResource
@IntegrationManagedResource
public class SqsMessageDrivenChannelAdapter
extends MessageProducerSupport {
    private final SqsMessageListenerContainerFactory.Builder<Object> sqsMessageListenerContainerFactory = SqsMessageListenerContainerFactory.builder();
    private final String[] queues;
    private SqsContainerOptions sqsContainerOptions;
    private SqsMessageListenerContainer<?> listenerContainer;

    public SqsMessageDrivenChannelAdapter(SqsAsyncClient amazonSqs, String ... queues) {
        Assert.noNullElements((Object[])queues, (String)"'queues' must not be empty");
        this.sqsMessageListenerContainerFactory.sqsAsyncClient(amazonSqs);
        this.queues = Arrays.copyOf(queues, queues.length);
    }

    public void setSqsContainerOptions(SqsContainerOptions sqsContainerOptions) {
        this.sqsContainerOptions = sqsContainerOptions;
    }

    protected void onInit() {
        super.onInit();
        if (this.sqsContainerOptions != null) {
            this.sqsMessageListenerContainerFactory.configure(sqsContainerOptionsBuilder -> sqsContainerOptionsBuilder.fromBuilder(this.sqsContainerOptions.toBuilder()));
        }
        this.sqsMessageListenerContainerFactory.messageListener(new IntegrationMessageListener());
        this.listenerContainer = (SqsMessageListenerContainer)this.sqsMessageListenerContainerFactory.build().createContainer(this.queues);
    }

    public String getComponentType() {
        return "aws:sqs-message-driven-channel-adapter";
    }

    protected void doStart() {
        this.listenerContainer.start();
    }

    protected void doStop() {
        this.listenerContainer.stop();
    }

    @ManagedAttribute
    public String[] getQueues() {
        return Arrays.copyOf(this.queues, this.queues.length);
    }

    private class IntegrationMessageListener
    implements MessageListener<Object> {
        IntegrationMessageListener() {
        }

        @Override
        public void onMessage(Message<Object> message) {
            SqsMessageDrivenChannelAdapter.this.sendMessage(message);
        }

        @Override
        public void onMessage(Collection<Message<Object>> messages) {
            this.onMessage((Message<Object>)new GenericMessage(messages));
        }
    }
}

