/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.acknowledgement.handler;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementCallback;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementHandler;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class OnSuccessAcknowledgementHandler<T>
implements AcknowledgementHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(OnSuccessAcknowledgementHandler.class);

    @Override
    public CompletableFuture<Void> onSuccess(Message<T> message, AcknowledgementCallback<T> callback) {
        logger.trace("Acknowledging message {}", (Object)MessageHeaderUtils.getId(message));
        return callback.onAcknowledge(message);
    }

    @Override
    public CompletableFuture<Void> onSuccess(Collection<Message<T>> messages, AcknowledgementCallback<T> callback) {
        logger.trace("Acknowledging messages {}", (Object)MessageHeaderUtils.getId(messages));
        return callback.onAcknowledge(messages);
    }

    @Override
    public CompletableFuture<Void> onError(Message<T> message, Throwable t, AcknowledgementCallback<T> callback) {
        logger.trace("Skipping ack for message {}", (Object)MessageHeaderUtils.getId(message));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onError(Collection<Message<T>> messages, Throwable t, AcknowledgementCallback<T> callback) {
        logger.trace("Skipping acks for messages {}", (Object)MessageHeaderUtils.getId(messages));
        return CompletableFuture.completedFuture(null);
    }
}

