/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.backpressure;

import io.awspring.cloud.sqs.listener.BackPressureMode;
import io.awspring.cloud.sqs.listener.ContainerOptions;
import io.awspring.cloud.sqs.listener.backpressure.BackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.BackPressureHandlerFactory;
import io.awspring.cloud.sqs.listener.backpressure.CompositeBackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.ConcurrencyLimiterBlockingBackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.FullBatchBackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.SemaphoreBackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.ThroughputBackPressureHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BackPressureHandlerFactories {
    private BackPressureHandlerFactories() {
    }

    public static BackPressureHandlerFactory adaptiveThroughputBackPressureHandler() {
        return BackPressureHandlerFactories::createAdaptiveThroughputBackPressureHandler;
    }

    private static BackPressureHandler createAdaptiveThroughputBackPressureHandler(ContainerOptions<?, ?> options) {
        BackPressureMode backPressureMode = options.getBackPressureMode();
        BackPressureHandlerFactory concurrencyLimiterBlockingBackPressureHandler = BackPressureHandlerFactories.concurrencyLimiterBackPressureHandler();
        if (backPressureMode == BackPressureMode.FIXED_HIGH_THROUGHPUT) {
            return concurrencyLimiterBlockingBackPressureHandler.createBackPressureHandler(options);
        }
        ArrayList<BackPressureHandlerFactory> backPressureHandlers = new ArrayList<BackPressureHandlerFactory>();
        backPressureHandlers.add(concurrencyLimiterBlockingBackPressureHandler);
        if (backPressureMode == BackPressureMode.AUTO || backPressureMode == BackPressureMode.ALWAYS_POLL_MAX_MESSAGES) {
            backPressureHandlers.add(BackPressureHandlerFactories.throughputBackPressureHandler());
        }
        if (backPressureMode == BackPressureMode.ALWAYS_POLL_MAX_MESSAGES) {
            backPressureHandlers.add(BackPressureHandlerFactories.fullBatchBackPressureHandler());
        }
        return BackPressureHandlerFactories.compositeBackPressureHandler(backPressureHandlers).createBackPressureHandler(options);
    }

    public static BackPressureHandlerFactory compositeBackPressureHandler(BackPressureHandlerFactory ... backPressureHandlerFactories) {
        return BackPressureHandlerFactories.compositeBackPressureHandler(Arrays.asList(backPressureHandlerFactories));
    }

    public static BackPressureHandlerFactory compositeBackPressureHandler(List<BackPressureHandlerFactory> factories) {
        return options -> CompositeBackPressureHandler.builder().batchSize(options.getMaxMessagesPerPoll()).noPermitsReturnedWaitTimeout(options.getMaxDelayBetweenPolls()).backPressureHandlers(factories.stream().map(factory -> factory.createBackPressureHandler(options)).toList()).build();
    }

    public static BackPressureHandlerFactory concurrencyLimiterBackPressureHandler() {
        return options -> ConcurrencyLimiterBlockingBackPressureHandler.builder().batchSize(options.getMaxMessagesPerPoll()).totalPermits(options.getMaxConcurrentMessages()).acquireTimeout(options.getMaxDelayBetweenPolls()).build();
    }

    public static BackPressureHandlerFactory throughputBackPressureHandler() {
        return options -> ThroughputBackPressureHandler.builder().batchSize(options.getMaxMessagesPerPoll()).build();
    }

    public static BackPressureHandlerFactory fullBatchBackPressureHandler() {
        return options -> FullBatchBackPressureHandler.builder().batchSize(options.getMaxMessagesPerPoll()).build();
    }

    @Deprecated
    public static BackPressureHandlerFactory semaphoreBackPressureHandler() {
        return options -> SemaphoreBackPressureHandler.builder().batchSize(options.getMaxMessagesPerPoll()).totalPermits(options.getMaxConcurrentMessages()).acquireTimeout(options.getMaxDelayBetweenPolls()).throughputConfiguration(options.getBackPressureMode()).build();
    }
}

