/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.backpressure;

import io.awspring.cloud.sqs.listener.IdentifiableContainerComponent;
import io.awspring.cloud.sqs.listener.backpressure.BackPressureHandler;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThroughputBackPressureHandler
implements BackPressureHandler,
IdentifiableContainerComponent {
    private static final Logger logger = LoggerFactory.getLogger(ThroughputBackPressureHandler.class);
    private final AtomicReference<CurrentThroughputMode> currentThroughputMode = new AtomicReference<CurrentThroughputMode>(CurrentThroughputMode.LOW);
    private final AtomicBoolean occupied = new AtomicBoolean(false);
    private final AtomicBoolean drained = new AtomicBoolean(false);
    private final int batchSize;
    private String id = this.getClass().getSimpleName();

    private ThroughputBackPressureHandler(Builder builder) {
        this.batchSize = builder.batchSize;
        logger.debug("ThroughputBackPressureHandler created with batch size: {}", (Object)this.batchSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int request(int amount) throws InterruptedException {
        if (this.drained.get()) {
            return 0;
        }
        CurrentThroughputMode throughputMode = this.currentThroughputMode.get();
        if (throughputMode == CurrentThroughputMode.LOW) {
            if (this.occupied.get()) {
                logger.debug("[{}] No permits acquired because a batch already being processed in low throughput mode", (Object)this.id);
                return 0;
            }
            this.occupied.set(true);
        }
        logger.debug("[{}] Acquired {} permits ({} mode)", new Object[]{this.id, amount, throughputMode});
        return Math.min(amount, this.batchSize);
    }

    @Override
    public void release(int amount, BackPressureHandler.ReleaseReason reason) {
        if (this.drained.get()) {
            return;
        }
        logger.debug("[{}] Releasing {} permits ({})", new Object[]{this.id, amount, reason});
        switch (reason) {
            case NONE_FETCHED: {
                this.occupied.compareAndSet(true, false);
                this.updateThroughputMode(CurrentThroughputMode.HIGH, CurrentThroughputMode.LOW);
                break;
            }
            case PARTIAL_FETCH: {
                this.occupied.compareAndSet(true, false);
                this.updateThroughputMode(CurrentThroughputMode.LOW, CurrentThroughputMode.HIGH);
                break;
            }
        }
    }

    private void updateThroughputMode(CurrentThroughputMode currentTarget, CurrentThroughputMode newTarget) {
        if (this.currentThroughputMode.compareAndSet(currentTarget, newTarget)) {
            logger.debug("[{}] throughput mode updated to {}", (Object)this.id, (Object)newTarget);
        }
    }

    @Override
    public boolean drain(Duration timeout) {
        logger.debug("[{}] Draining", (Object)this.id);
        this.drained.set(true);
        return true;
    }

    private static enum CurrentThroughputMode {
        HIGH,
        LOW;

    }

    public static class Builder {
        private int batchSize;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public ThroughputBackPressureHandler build() {
            Assert.isTrue((this.batchSize > 0 ? 1 : 0) != 0, (String)"The batch size must be greater than 0");
            return new ThroughputBackPressureHandler(this);
        }
    }
}

