/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.batchmanager.SqsAsyncBatchManager;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class BatchingSqsClientAdapter
implements SqsAsyncClient {
    private final SqsAsyncBatchManager batchManager;

    public BatchingSqsClientAdapter(SqsAsyncBatchManager batchManager) {
        Assert.notNull((Object)batchManager, (String)"batchManager cannot be null");
        this.batchManager = batchManager;
    }

    public String serviceName() {
        return "sqs";
    }

    public void close() {
        this.batchManager.close();
    }

    public CompletableFuture<SendMessageResponse> sendMessage(SendMessageRequest sendMessageRequest) {
        return this.batchManager.sendMessage(sendMessageRequest);
    }

    public CompletableFuture<SendMessageResponse> sendMessage(Consumer<SendMessageRequest.Builder> sendMessageRequest) {
        return this.batchManager.sendMessage(sendMessageRequest);
    }

    public CompletableFuture<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        return this.batchManager.receiveMessage(receiveMessageRequest);
    }

    public CompletableFuture<ReceiveMessageResponse> receiveMessage(Consumer<ReceiveMessageRequest.Builder> receiveMessageRequest) {
        return this.batchManager.receiveMessage(receiveMessageRequest);
    }

    public CompletableFuture<DeleteMessageResponse> deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        return this.batchManager.deleteMessage(deleteMessageRequest);
    }

    public CompletableFuture<DeleteMessageResponse> deleteMessage(Consumer<DeleteMessageRequest.Builder> deleteMessageRequest) {
        return this.batchManager.deleteMessage(deleteMessageRequest);
    }

    public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        return this.batchManager.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(Consumer<ChangeMessageVisibilityRequest.Builder> changeMessageVisibilityRequest) {
        return this.batchManager.changeMessageVisibility(changeMessageVisibilityRequest);
    }
}

