/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import org.springframework.lang.Nullable;

public class SnsNotification<T> {
    private final String type;
    private final String messageId;
    private final String topicArn;
    private final T message;
    private final String timestamp;
    private final Map<String, MessageAttribute> messageAttributes;
    @Nullable
    private final String sequenceNumber;
    @Nullable
    private final String subject;
    @Nullable
    private final String unsubscribeUrl;
    @Nullable
    private final String signature;
    @Nullable
    private final String signatureVersion;
    @Nullable
    private final String signingCertURL;

    @JsonCreator
    public SnsNotification(@JsonProperty(value="Type") String type, @JsonProperty(value="MessageId") String messageId, @JsonProperty(value="TopicArn") String topicArn, @JsonProperty(value="Message") T message, @JsonProperty(value="Timestamp") String timestamp, @JsonProperty(value="MessageAttributes") @Nullable Map<String, MessageAttribute> messageAttributes, @JsonProperty(value="SequenceNumber") @Nullable String sequenceNumber, @JsonProperty(value="Subject") @Nullable String subject, @JsonProperty(value="UnsubscribeURL") @Nullable String unsubscribeURL, @JsonProperty(value="Signature") @Nullable String signature, @JsonProperty(value="SignatureVersion") @Nullable String signatureVersion, @JsonProperty(value="SigningCertURL") @Nullable String signingCertURL) {
        this.type = type;
        this.messageId = messageId;
        this.topicArn = topicArn;
        this.sequenceNumber = sequenceNumber;
        this.unsubscribeUrl = unsubscribeURL;
        this.subject = subject;
        this.message = message;
        this.timestamp = timestamp;
        this.messageAttributes = Optional.ofNullable(messageAttributes).orElse(Map.of());
        this.signature = signature;
        this.signatureVersion = signatureVersion;
        this.signingCertURL = signingCertURL;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public T getMessage() {
        return this.message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Map<String, MessageAttribute> getMessageAttributes() {
        return this.messageAttributes;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public Optional<String> getSequenceNumber() {
        return Optional.ofNullable(this.sequenceNumber);
    }

    public Optional<String> getUnsubscribeUrl() {
        return Optional.ofNullable(this.unsubscribeUrl);
    }

    public Optional<String> getSignatureVersion() {
        return Optional.ofNullable(this.signatureVersion);
    }

    public Optional<String> getSignature() {
        return Optional.ofNullable(this.signature);
    }

    public Optional<String> getSigningCertURL() {
        return Optional.ofNullable(this.signingCertURL);
    }

    public static class MessageAttribute {
        private final String type;
        private final String value;

        @JsonCreator
        public MessageAttribute(@JsonProperty(value="Type") String type, @JsonProperty(value="Value") String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

