/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.secretsmanager;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.util.StringUtils;
import io.awspring.cloud.core.SpringCloudClientConfiguration;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerProperties;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySourceLocator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AwsSecretsManagerProperties.class})
@ConditionalOnClass(value={AWSSecretsManager.class, AwsSecretsManagerPropertySourceLocator.class})
@ConditionalOnProperty(prefix="aws.secretsmanager", name={"enabled"}, matchIfMissing=true)
public class AwsSecretsManagerBootstrapConfiguration {
    private final Environment environment;

    public AwsSecretsManagerBootstrapConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    AwsSecretsManagerPropertySourceLocator awsSecretsManagerPropertySourceLocator(AWSSecretsManager smClient, AwsSecretsManagerProperties properties) {
        if (StringUtils.isNullOrEmpty((String)properties.getName())) {
            properties.setName(this.environment.getProperty("spring.application.name"));
        }
        return new AwsSecretsManagerPropertySourceLocator(smClient, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    AWSSecretsManager smClient(AwsSecretsManagerProperties properties) {
        return AwsSecretsManagerBootstrapConfiguration.createSecretsManagerClient(properties);
    }

    public static AWSSecretsManager createSecretsManagerClient(AwsSecretsManagerProperties properties) {
        AWSSecretsManagerClientBuilder builder = (AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withClientConfiguration(SpringCloudClientConfiguration.getClientConfiguration());
        if (!StringUtils.isNullOrEmpty((String)properties.getRegion())) {
            builder.withRegion(properties.getRegion());
        }
        if (properties.getEndpoint() != null) {
            AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(properties.getEndpoint().toString(), null);
            builder.withEndpointConfiguration(endpointConfiguration);
        }
        return (AWSSecretsManager)builder.build();
    }
}

