/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import io.awspring.cloud.autoconfigure.secretsmanager.AwsSecretsManagerConfigDataResource;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySource;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySources;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.util.ReflectionUtils;

public class AwsSecretsManagerConfigDataLoader
implements ConfigDataLoader<AwsSecretsManagerConfigDataResource> {
    private final DeferredLogFactory logFactory;

    public AwsSecretsManagerConfigDataLoader(DeferredLogFactory logFactory) {
        this.logFactory = logFactory;
        this.reconfigureLoggers(logFactory);
    }

    public ConfigData load(ConfigDataLoaderContext context, AwsSecretsManagerConfigDataResource resource) {
        try {
            AWSSecretsManager sm = (AWSSecretsManager)context.getBootstrapContext().get(AWSSecretsManager.class);
            AwsSecretsManagerPropertySource propertySource = resource.getPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), sm);
            if (propertySource != null) {
                return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }

    private void reconfigureLoggers(DeferredLogFactory logFactory) {
        List<Class> loggers = Arrays.asList(AwsSecretsManagerPropertySource.class, AwsSecretsManagerPropertySources.class);
        loggers.forEach(it -> AwsSecretsManagerConfigDataLoader.reconfigureLogger(it, logFactory));
    }

    static void reconfigureLogger(Class<?> type, DeferredLogFactory logFactory) {
        ReflectionUtils.doWithFields(type, field -> {
            field.setAccessible(true);
            field.set(null, logFactory.getLog(type));
        }, AwsSecretsManagerConfigDataLoader::isUpdateableLogField);
    }

    private static boolean isUpdateableLogField(Field field) {
        return !Modifier.isFinal(field.getModifiers()) && field.getType().isAssignableFrom(Log.class);
    }
}

