/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.plugin.data.protection.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.plugin.data.protection.config.DataProtectionConfigList;
import io.axoniq.plugin.data.protection.generator.MetamodelGenerator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE)
public class AxonDataProtectionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor descriptor;
    @Parameter(property="packages", required=true)
    private List<String> packages;
    @Parameter(defaultValue="${project.build.directory}/axon-data-protection-config.json")
    private File outputConfig;
    @Parameter(property="ignores")
    private List<String> ignores;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Starting metamodel generation for %s", this.packages));
        this.getLog().info((CharSequence)String.format("Ignoring the following packages and classes: %s", this.ignores));
        this.addProjectClassesToPluginClasspath();
        MetamodelGenerator generator = new MetamodelGenerator(this.getLog(), this.ignores);
        try {
            DataProtectionConfigList config = generator.generateMetamodel(this.packages);
            this.writeOutput(config);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Metamodel generation failed with: ", (Throwable)e);
            throw e;
        }
    }

    private void writeOutput(DataProtectionConfigList config) throws MojoExecutionException {
        try {
            if (!this.outputConfig.getParentFile().exists()) {
                this.outputConfig.getParentFile().mkdirs();
            }
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(this.outputConfig, (Object)config);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write result schema.", (Exception)e);
        }
    }

    private void addProjectClassesToPluginClasspath() {
        try {
            ClassRealm realm = this.descriptor.getClassRealm();
            for (String dependency : this.project.getCompileClasspathElements()) {
                try {
                    File elementFile = new File(dependency);
                    realm.addURL(elementFile.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (DependencyResolutionRequiredException ex) {
            ex.printStackTrace();
        }
    }
}

