/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.plugin.data.protection.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.axoniq.plugin.data.protection.annotation.SensitiveData;
import io.axoniq.plugin.data.protection.annotation.SensitiveDataHolder;
import io.axoniq.plugin.data.protection.annotation.SubjectId;
import io.axoniq.plugin.data.protection.config.DataProtectionConfig;
import io.axoniq.plugin.data.protection.config.DataProtectionConfigList;
import io.axoniq.plugin.data.protection.config.SensitiveDataConfig;
import io.axoniq.plugin.data.protection.config.SubjectIdConfig;
import io.axoniq.plugin.data.protection.generator.errors.NoSensitiveDataHolderAnnotationException;
import io.axoniq.plugin.data.protection.generator.errors.NoSubjectIdException;
import io.axoniq.plugin.data.protection.generator.utils.AnnotationUtils;
import io.axoniq.plugin.data.protection.generator.utils.ReflectionUtils;
import io.axoniq.plugin.data.protection.generator.utils.TypeDetector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class MetamodelGenerator {
    private static final String PATH_PREFIX = "$";
    private static final String PATH_DIVIDER = ".";
    private static final String PATH_LIST_ELEMENTS = "[*]";
    private static final String PATH_MAP_ELEMENTS = "*";
    private final Log log;
    private final List<String> ignores;

    public MetamodelGenerator() {
        this.log = new SystemStreamLog();
        this.ignores = new ArrayList<String>();
    }

    public MetamodelGenerator(List<String> ignores) {
        this.log = new SystemStreamLog();
        this.ignores = ignores;
    }

    public MetamodelGenerator(Log log, List<String> ignores) {
        this.log = log;
        this.ignores = ignores;
    }

    public DataProtectionConfigList generateMetamodel(List<String> packages) {
        ArrayList dataProtectionConfigs = new ArrayList();
        packages.forEach(pkg -> dataProtectionConfigs.addAll(this.generateMetamodel((String)pkg).getConfig()));
        return new DataProtectionConfigList(dataProtectionConfigs);
    }

    public DataProtectionConfigList generateMetamodel(String pkg) {
        this.log.info((CharSequence)String.format("Scanning package [%s]", pkg));
        ArrayList dataProtectionConfigs = new ArrayList();
        Reflections reflections = new Reflections(pkg, new Scanner[0]);
        Set annotatedClasses = reflections.getTypesAnnotatedWith(SensitiveDataHolder.class);
        annotatedClasses.stream().map(this::generateMetamodel).forEach(dataProtectionConfigs::add);
        return new DataProtectionConfigList(dataProtectionConfigs);
    }

    public DataProtectionConfig generateMetamodel(Class<?> annotatedClass) {
        if (!annotatedClass.isAnnotationPresent(SensitiveDataHolder.class)) {
            throw new NoSensitiveDataHolderAnnotationException(annotatedClass);
        }
        this.log.debug((CharSequence)String.format("Scanning class [%s]", ReflectionUtils.extractName(annotatedClass)));
        ArrayList<SensitiveDataConfig> sensitiveDataList = new ArrayList<SensitiveDataConfig>();
        String type = ReflectionUtils.extractName(annotatedClass);
        String revision = ReflectionUtils.extractRevision(annotatedClass);
        List<Field> classFields = ReflectionUtils.getAllDeclaredFields(annotatedClass);
        SubjectIdConfig subjectId = this.extractSubjectId(classFields).orElseThrow(() -> new NoSubjectIdException(annotatedClass));
        this.extractSensitiveData(classFields, sensitiveDataList, PATH_PREFIX);
        return new DataProtectionConfig(type, revision, subjectId, sensitiveDataList);
    }

    private Optional<SubjectIdConfig> extractSubjectId(List<Field> classFields) {
        return classFields.stream().filter(field -> AnnotationUtils.isAnnotationPresent((AnnotatedElement)field, SubjectId.class)).findFirst().map(subjectIdField -> new SubjectIdConfig(this.buildPath(PATH_PREFIX, ReflectionUtils.extractName(subjectIdField))));
    }

    private void extractSensitiveData(List<Field> classFields, List<SensitiveDataConfig> sensitiveDataList, String path) {
        classFields.stream().filter(f -> AnnotationUtils.isAnnotationPresent((AnnotatedElement)f, SensitiveData.class)).filter(f -> !AnnotationUtils.isAnnotationPresent((AnnotatedElement)f, SubjectId.class)).forEach(f -> sensitiveDataList.add(new SensitiveDataConfig(this.buildPath(path, ReflectionUtils.extractName(f)), ReflectionUtils.extractReplacementValue(f))));
        classFields.stream().filter(f -> !AnnotationUtils.isAnnotationPresent((AnnotatedElement)f, SubjectId.class)).filter(f -> !TypeDetector.ignore(this.ignores, f.getType())).filter(ReflectionUtils::shouldGoDeeper).forEach(field -> this.checkType((Field)field, sensitiveDataList, this.buildPath(path, ReflectionUtils.extractName(field))));
    }

    private void checkType(Field field, List<SensitiveDataConfig> sensitiveDataList, String path) {
        TypeResolver resolver = new TypeResolver();
        ResolvedType type = resolver.resolve(field.getGenericType(), new Type[0]);
        if (TypeDetector.isMap(type)) {
            this.extractSensitiveData(ReflectionUtils.getAllDeclaredFields(((ResolvedType)type.getTypeParameters().get(1)).getErasedType()), sensitiveDataList, this.buildMapPath(path));
        } else if (TypeDetector.isArray(type)) {
            this.extractSensitiveData(ReflectionUtils.getAllDeclaredFields(type.getArrayElementType().getErasedType()), sensitiveDataList, this.buildCollectionPath(path));
        } else if (this.hasTypeParameters(type)) {
            type.getTypeParameters().stream().filter(tp -> ReflectionUtils.shouldGoDeeper(tp.getErasedType())).forEach(tp -> this.extractSensitiveData(ReflectionUtils.getAllDeclaredFields(tp.getErasedType()), sensitiveDataList, this.buildCollectionPath(path)));
        } else {
            this.extractSensitiveData(ReflectionUtils.getAllDeclaredFields(type.getErasedType()), sensitiveDataList, path);
        }
    }

    private boolean hasTypeParameters(ResolvedType type) {
        return !type.getTypeParameters().isEmpty();
    }

    private String buildPath(String previousPath, String path) {
        return previousPath + PATH_DIVIDER + path;
    }

    private String buildCollectionPath(String path) {
        return path + PATH_LIST_ELEMENTS;
    }

    private String buildMapPath(String path) {
        return path + ".*";
    }
}

