/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.plugin.data.protection.generator.utils;

import io.axoniq.plugin.data.protection.annotation.SensitiveData;
import io.axoniq.plugin.data.protection.generator.utils.AnnotationUtils;
import io.axoniq.plugin.data.protection.generator.utils.ClassUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.serialization.Revision;

public abstract class ReflectionUtils {
    private static final String EMPTY_STRING = "";

    public static boolean shouldGoDeeper(Class<?> clazz) {
        return !ReflectionUtils.isPrimitiveOrWrapper(clazz) && !ReflectionUtils.isCommonJavaType(clazz) && !ReflectionUtils.isDateTimeJavaType(clazz) && !ReflectionUtils.isEnumType(clazz);
    }

    public static boolean shouldGoDeeper(Field field) {
        return ReflectionUtils.shouldGoDeeper(field.getType());
    }

    private static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return ClassUtils.isPrimitiveOrWrapper(clazz) || ClassUtils.isPrimitiveArray(clazz) || ClassUtils.isPrimitiveWrapperArray(clazz);
    }

    private static boolean isCommonJavaType(Class<?> clazz) {
        return ClassUtils.isAssignable(String.class, clazz) || ClassUtils.isAssignable(BigDecimal.class, clazz) || ClassUtils.isAssignable(BigInteger.class, clazz);
    }

    private static boolean isDateTimeJavaType(Class<?> clazz) {
        return ClassUtils.isAssignable(Date.class, clazz) || ClassUtils.isAssignable(LocalDate.class, clazz) || ClassUtils.isAssignable(LocalTime.class, clazz) || ClassUtils.isAssignable(LocalDateTime.class, clazz) || ClassUtils.isAssignable(OffsetDateTime.class, clazz) || ClassUtils.isAssignable(ZonedDateTime.class, clazz) || ClassUtils.isAssignable(Instant.class, clazz) || ClassUtils.isAssignable(Period.class, clazz) || ClassUtils.isAssignable(Duration.class, clazz);
    }

    private static boolean isEnumType(Class<?> clazz) {
        return clazz.isEnum();
    }

    public static String extractRevision(Class<?> clazz) {
        if (AnnotationUtils.isAnnotationPresent(clazz, Revision.class)) {
            return clazz.getAnnotation(Revision.class).value();
        }
        return EMPTY_STRING;
    }

    public static String extractReplacementValue(Field field) {
        if (AnnotationUtils.isAnnotationPresent((AnnotatedElement)field, SensitiveData.class)) {
            return field.getAnnotation(SensitiveData.class).replacementValue();
        }
        return EMPTY_STRING;
    }

    public static String extractName(Class<?> clazz) {
        return clazz.getName();
    }

    public static String extractName(Field field) {
        return field.getName();
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        if (clazz == null) {
            return new ArrayList<Field>();
        }
        List<Class<?>> parents = ReflectionUtils.getAllParents(clazz);
        List<Field> fields = parents.stream().flatMap(c -> Arrays.stream(c.getDeclaredFields())).collect(Collectors.toList());
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields;
    }

    public static List<Class<?>> getAllParents(Class<?> clazz) {
        if (clazz == null) {
            return new ArrayList();
        }
        ArrayList classes = new ArrayList();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            classes.add(superclass);
            classes.addAll(ReflectionUtils.getAllParents(superclass));
        }
        List<Class<?>> interfaces = Arrays.asList(clazz.getInterfaces());
        classes.addAll(interfaces);
        interfaces.forEach(i -> classes.addAll(ReflectionUtils.getAllParents(i)));
        return classes;
    }
}

