/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.plugin.data.protection.generator.utils;

import com.fasterxml.classmate.ResolvedType;
import io.axoniq.plugin.data.protection.generator.utils.ReflectionUtils;
import java.util.List;
import java.util.Map;

public abstract class TypeDetector {
    public static boolean isMap(ResolvedType type) {
        return type.isInstanceOf(Map.class) && type.getTypeParameters().size() == 2 && ReflectionUtils.shouldGoDeeper(((ResolvedType)type.getTypeParameters().get(1)).getErasedType());
    }

    public static boolean isArray(ResolvedType type) {
        return type.isArray() && ReflectionUtils.shouldGoDeeper(type.getArrayElementType().getErasedType());
    }

    public static boolean ignore(List<String> ignores, Class<?> clazz) {
        return TypeDetector.ignoreClass(ignores, clazz) || TypeDetector.ignorePackage(ignores, clazz);
    }

    private static boolean ignoreClass(List<String> ignores, Class<?> clazz) {
        return ignores.contains(clazz.getName());
    }

    private static boolean ignorePackage(List<String> ignores, Class<?> clazz) {
        return ignores.stream().filter(ignore -> ignore.endsWith(".*")).anyMatch(ignore -> clazz.getName().matches((String)ignore));
    }
}

