/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client;

import io.axoniq.axondb.Event;
import io.axoniq.axondb.client.axon.AxonErrorMapping;
import io.axoniq.axondb.client.util.EventCipher;
import io.axoniq.axondb.grpc.Confirmation;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AppendEventTransaction {
    private final StreamObserver<Event> eventStreamObserver;
    private final CompletableFuture<Confirmation> observer;
    private final EventCipher eventCipher;

    public AppendEventTransaction(StreamObserver<Event> eventStreamObserver, CompletableFuture<Confirmation> observer, EventCipher eventCipher) {
        this.eventStreamObserver = eventStreamObserver;
        this.observer = observer;
        this.eventCipher = eventCipher;
    }

    public void append(Event event) {
        this.eventStreamObserver.onNext((Object)this.eventCipher.encrypt(event));
    }

    public void commit() {
        this.eventStreamObserver.onCompleted();
        try {
            this.observer.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw AxonErrorMapping.convert(e);
        }
        catch (ExecutionException e) {
            throw AxonErrorMapping.convert(e.getCause());
        }
        catch (TimeoutException e) {
            throw AxonErrorMapping.convert(e);
        }
    }

    public void rollback(Throwable reason) {
        this.eventStreamObserver.onError(reason);
    }
}

