/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client;

import io.axoniq.axondb.client.util.EventCipher;
import io.axoniq.platform.grpc.NodeInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;

public class AxonDBConfiguration {
    @Value(value="${axoniq.axondb.servers:#{null}}")
    private String servers;
    @Value(value="${axoniq.axondb.flowControl.initialNrOfPermits:100000}")
    private Integer initialNrOfPermits;
    @Value(value="${axoniq.axondb.flowControl.nrOfNewPermits:90000}")
    private Integer nrOfNewPermits;
    @Value(value="${axoniq.axondb.flowControl.newPermitsThreshold:10000}")
    private Integer newPermitsThreshold;
    @Value(value="${axoniq.axondb.token:#{null}}")
    private String token;
    @Value(value="${axoniq.axondb.ssl.certChainFile:#{null}}")
    private String certFile;
    @Value(value="${axoniq.axondb.ssl.enabled:false}")
    private boolean sslEnabled;
    @Value(value="${axoniq.axondb.connectionRetry:2500}")
    private long connectionRetry;
    @Value(value="${axoniq.axondb.connectionRetryCount:5}")
    private int connectionRetryCount;
    private EventCipher eventCipher = new EventCipher();
    @Value(value="${axoniq.axondb.context:#{null}}")
    private String context;

    public AxonDBConfiguration() {
    }

    public AxonDBConfiguration(EventCipher eventCipher) {
        this.eventCipher = eventCipher;
    }

    @Value(value="${axoniq.axondb.eventSecretKey:#{null}}")
    private void setEventSecretKey(String key) {
        if (key != null && key.length() > 0) {
            this.eventCipher = new EventCipher(key.getBytes(StandardCharsets.US_ASCII));
        }
    }

    public static Builder newBuilder(String servers) {
        return new Builder(servers);
    }

    public List<NodeInfo> getServerNodes() {
        ArrayList<NodeInfo> serverNodes = new ArrayList<NodeInfo>();
        if (this.servers != null) {
            String[] serverArr = this.servers.split(",");
            Arrays.stream(serverArr).forEach(serverString -> {
                String[] hostPort = serverString.trim().split(":", 2);
                NodeInfo nodeInfo = NodeInfo.newBuilder().setHostName(hostPort[0]).setGrpcPort(Integer.valueOf(hostPort[1])).build();
                serverNodes.add(nodeInfo);
            });
        }
        return serverNodes;
    }

    public long getConnectionRetry() {
        return this.connectionRetry;
    }

    public int getConnectionRetryCount() {
        return this.connectionRetryCount;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getInitialNrOfPermits() {
        return this.initialNrOfPermits;
    }

    public Integer getNrOfNewPermits() {
        return this.nrOfNewPermits;
    }

    public Integer getNewPermitsThreshold() {
        return this.newPermitsThreshold;
    }

    public String getCertFile() {
        return this.certFile;
    }

    public EventCipher getEventCipher() {
        return this.eventCipher;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getContext() {
        return this.context;
    }

    public static class Builder {
        private AxonDBConfiguration instance = new AxonDBConfiguration();

        public Builder(String servers) {
            this.instance.servers = servers;
            this.instance.initialNrOfPermits = 0;
            this.instance.nrOfNewPermits = 0;
            this.instance.newPermitsThreshold = 0;
            this.instance.connectionRetry = 2500L;
            this.instance.connectionRetryCount = 5;
        }

        public Builder ssl(String certificateFilePath) {
            this.instance.certFile = certificateFilePath;
            return this;
        }

        public Builder token(String token) {
            this.instance.token = token;
            return this;
        }

        public Builder context(String context) {
            this.instance.context = context;
            return this;
        }

        public Builder connectionRetry(long connectionRetryTime, int attempts) {
            this.instance.connectionRetry = connectionRetryTime;
            this.instance.connectionRetryCount = attempts;
            return this;
        }

        public Builder flowControl(Integer initialNrOfPermits, Integer nrOfNewPermits, Integer newPermitsThreshold) {
            this.instance.initialNrOfPermits = initialNrOfPermits;
            this.instance.nrOfNewPermits = nrOfNewPermits;
            this.instance.newPermitsThreshold = newPermitsThreshold;
            return this;
        }

        public Builder setEventSecretKey(String key) {
            this.instance.setEventSecretKey(key);
            return this;
        }

        public Builder eventCipher(EventCipher eventCipher) {
            this.instance.eventCipher = eventCipher;
            return this;
        }

        public AxonDBConfiguration build() {
            return this.instance;
        }
    }
}

