/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import javax.net.ssl.SSLException;

public class ManagedChannelUtil {
    public static ManagedChannel createManagedChannel(String host, int port, boolean sslEnabled, String certChainFile) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)host, (int)port);
        if (sslEnabled) {
            try {
                if (certChainFile == null) {
                    throw new RuntimeException("SSL enabled but no certificate file specified");
                }
                File certFile = new File(certChainFile);
                if (!certFile.exists()) {
                    throw new RuntimeException("Certificate file " + certChainFile + " does not exist");
                }
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(certChainFile)).build();
                builder.sslContext(sslContext);
            }
            catch (SSLException e) {
                throw new RuntimeException("Couldn't set up SSL context", e);
            }
        } else {
            builder.usePlaintext(true);
        }
        return builder.build();
    }
}

