/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client.axon;

import io.axoniq.axondb.client.axon.EventBuffer;
import io.axoniq.axondb.client.axon.QueryResult;
import io.axoniq.axondb.client.axon.QueryResultStream;
import io.axoniq.axondb.grpc.QueryEventsResponse;
import io.axoniq.axondb.grpc.RowResponse;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultBuffer
implements QueryResultStream {
    final Logger logger = LoggerFactory.getLogger(EventBuffer.class);
    private final BlockingQueue<RowResponse> queryResultQueue;
    private QueryResult peekEvent;
    private RuntimeException exception;
    private Consumer<QueryResultBuffer> closeCallback;
    private Consumer<Integer> consumeListener = i -> {};
    private List<String> columns;
    private volatile boolean closed;

    public QueryResultBuffer() {
        this.queryResultQueue = new LinkedBlockingQueue<RowResponse>();
    }

    @Override
    public boolean hasNext(int timeout, TimeUnit timeUnit) {
        this.checkException();
        long deadline = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        try {
            while (this.peekEvent == null && System.currentTimeMillis() < deadline) {
                this.waitForData(deadline);
            }
            return this.peekEvent != null;
        }
        catch (InterruptedException e) {
            this.logger.warn("Consumer thread was interrupted. Returning thread to event processor.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void checkException() {
        if (this.exception != null) {
            RuntimeException runtimeException = this.exception;
            this.exception = null;
            throw runtimeException;
        }
    }

    private void waitForData(long deadline) throws InterruptedException {
        do {
            RowResponse row;
            if ((row = this.queryResultQueue.poll(Math.min(deadline - System.currentTimeMillis(), 200L), TimeUnit.MILLISECONDS)) != null) {
                this.peekEvent = new QueryResult(row, this.columns);
            }
            this.checkException();
        } while (!this.closed && this.peekEvent == null && System.currentTimeMillis() < deadline);
    }

    @Override
    public QueryResult next() {
        this.checkException();
        try {
            this.consumeListener.accept(1);
            QueryResult queryResult = this.peekEvent;
            return queryResult;
        }
        finally {
            this.peekEvent = null;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.closeCallback != null) {
            this.closeCallback.accept(this);
        }
    }

    public void registerCloseListener(Consumer<QueryResultBuffer> closeCallback) {
        this.closeCallback = closeCallback;
    }

    public void registerConsumeListener(Consumer<Integer> consumeListener) {
        this.consumeListener = consumeListener;
    }

    public void push(QueryEventsResponse eventWithToken) {
        switch (eventWithToken.getDataCase()) {
            case COLUMNS: {
                this.columns = eventWithToken.getColumns().getColumnList();
                break;
            }
            case ROW: {
                try {
                    this.queryResultQueue.put(eventWithToken.getRow());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
            case FILES_COMPLETED: {
                break;
            }
        }
    }

    public void fail(EventStoreException exception) {
        this.exception = exception;
    }
}

