/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client.util;

import io.axoniq.axondb.client.util.GrpcExceptionParser;
import io.axoniq.platform.grpc.NodeInfo;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcaster<T> {
    private static final Logger logger = LoggerFactory.getLogger(Broadcaster.class);
    private final Collection<NodeInfo> destinations;
    private final Action<T> action;
    private final Consumer<T> onNextCallback;

    public Broadcaster(Collection<NodeInfo> destinations, Action<T> action, Consumer<T> onNextCallback) {
        this.destinations = destinations;
        this.action = action;
        this.onNextCallback = onNextCallback;
    }

    public void broadcast(int timeout, TimeUnit unit) throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(this.destinations.size());
        this.destinations.forEach(node -> this.action.perform((NodeInfo)node, new StreamObserver<T>((NodeInfo)node, countDownLatch){
            final /* synthetic */ NodeInfo val$node;
            final /* synthetic */ CountDownLatch val$countDownLatch;
            {
                this.val$node = nodeInfo;
                this.val$countDownLatch = countDownLatch;
            }

            public void onNext(T t) {
                Broadcaster.this.onNextCallback.accept(t);
            }

            public void onError(Throwable throwable) {
                logger.warn("Error from: {}:{} - {}", new Object[]{this.val$node.getHostName(), this.val$node.getGrpcPort(), GrpcExceptionParser.parse(throwable).toString()});
                this.val$countDownLatch.countDown();
            }

            public void onCompleted() {
                this.val$countDownLatch.countDown();
            }
        }));
        if (unit != null) {
            countDownLatch.await(timeout, unit);
        }
    }

    public static interface Action<T> {
        public void perform(NodeInfo var1, StreamObserver<T> var2);
    }
}

