package io.axoniq.axondb.grpc;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.1.2)",
    comments = "Source: eventstore_api.proto")
public class EventStoreGrpc {

  private EventStoreGrpc() {}

  public static final String SERVICE_NAME = "io.axoniq.axondb.grpc.EventStore";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.Event,
      io.axoniq.axondb.grpc.Confirmation> METHOD_APPEND_EVENT =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "AppendEvent"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.Event.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.Confirmation.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.Event,
      io.axoniq.axondb.grpc.Confirmation> METHOD_APPEND_SNAPSHOT =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "AppendSnapshot"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.Event.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.Confirmation.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.grpc.GetAggregateEventsRequest,
      io.axoniq.axondb.Event> METHOD_LIST_AGGREGATE_EVENTS =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "ListAggregateEvents"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.GetAggregateEventsRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.Event.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.grpc.GetEventsRequest,
      io.axoniq.axondb.grpc.EventWithToken> METHOD_LIST_EVENTS =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "ListEvents"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.GetEventsRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.EventWithToken.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest,
      io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse> METHOD_READ_HIGHEST_SEQUENCE_NR =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "ReadHighestSequenceNr"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.grpc.QueryEventsRequest,
      io.axoniq.axondb.grpc.QueryEventsResponse> METHOD_QUERY_EVENTS =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "QueryEvents"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.QueryEventsRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.QueryEventsResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.grpc.GetFirstTokenRequest,
      io.axoniq.axondb.grpc.TrackingToken> METHOD_GET_FIRST_TOKEN =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "GetFirstToken"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.GetFirstTokenRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.TrackingToken.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.grpc.GetLastTokenRequest,
      io.axoniq.axondb.grpc.TrackingToken> METHOD_GET_LAST_TOKEN =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "GetLastToken"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.GetLastTokenRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.TrackingToken.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.axoniq.axondb.grpc.GetTokenAtRequest,
      io.axoniq.axondb.grpc.TrackingToken> METHOD_GET_TOKEN_AT =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "io.axoniq.axondb.grpc.EventStore", "GetTokenAt"),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.GetTokenAtRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(io.axoniq.axondb.grpc.TrackingToken.getDefaultInstance()));

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static EventStoreStub newStub(io.grpc.Channel channel) {
    return new EventStoreStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static EventStoreBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new EventStoreBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary and streaming output calls on the service
   */
  public static EventStoreFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new EventStoreFutureStub(channel);
  }

  /**
   */
  public static abstract class EventStoreImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Accepts a stream of Events returning a Confirmation when completed.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axondb.Event> appendEvent(
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.Confirmation> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_APPEND_EVENT, responseObserver);
    }

    /**
     * <pre>
     * Accepts a Snapshot event returning a Confirmation when completed.
     * </pre>
     */
    public void appendSnapshot(io.axoniq.axondb.Event request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.Confirmation> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_APPEND_SNAPSHOT, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the Events for a given aggregate. Results are streamed rather than returned at once.
     * </pre>
     */
    public void listAggregateEvents(io.axoniq.axondb.grpc.GetAggregateEventsRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.Event> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_LIST_AGGREGATE_EVENTS, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the Events from a given tracking token. Results are streamed rather than returned at once.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.GetEventsRequest> listEvents(
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.EventWithToken> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_LIST_EVENTS, responseObserver);
    }

    /**
     * <pre>
     * Gets the highest sequence number for a specific aggregate.
     * </pre>
     */
    public void readHighestSequenceNr(io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_READ_HIGHEST_SEQUENCE_NR, responseObserver);
    }

    /**
     * <pre>
     * Performs a query on the event store, returns a stream of results. Input is a stream to allow flow control from the
     * client
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.QueryEventsRequest> queryEvents(
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.QueryEventsResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_QUERY_EVENTS, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the first token available in event store (typically 0). Returns 0 when no events in store.
     * </pre>
     */
    public void getFirstToken(io.axoniq.axondb.grpc.GetFirstTokenRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_FIRST_TOKEN, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the last committed token in event store. Returns -1 when no events in store.
     * </pre>
     */
    public void getLastToken(io.axoniq.axondb.grpc.GetLastTokenRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_LAST_TOKEN, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the token of the first token of an event from specified time in event store. Returns -1 when no events in store.
     * </pre>
     */
    public void getTokenAt(io.axoniq.axondb.grpc.GetTokenAtRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_TOKEN_AT, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_APPEND_EVENT,
            asyncClientStreamingCall(
              new MethodHandlers<
                io.axoniq.axondb.Event,
                io.axoniq.axondb.grpc.Confirmation>(
                  this, METHODID_APPEND_EVENT)))
          .addMethod(
            METHOD_APPEND_SNAPSHOT,
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axondb.Event,
                io.axoniq.axondb.grpc.Confirmation>(
                  this, METHODID_APPEND_SNAPSHOT)))
          .addMethod(
            METHOD_LIST_AGGREGATE_EVENTS,
            asyncServerStreamingCall(
              new MethodHandlers<
                io.axoniq.axondb.grpc.GetAggregateEventsRequest,
                io.axoniq.axondb.Event>(
                  this, METHODID_LIST_AGGREGATE_EVENTS)))
          .addMethod(
            METHOD_LIST_EVENTS,
            asyncBidiStreamingCall(
              new MethodHandlers<
                io.axoniq.axondb.grpc.GetEventsRequest,
                io.axoniq.axondb.grpc.EventWithToken>(
                  this, METHODID_LIST_EVENTS)))
          .addMethod(
            METHOD_READ_HIGHEST_SEQUENCE_NR,
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest,
                io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse>(
                  this, METHODID_READ_HIGHEST_SEQUENCE_NR)))
          .addMethod(
            METHOD_QUERY_EVENTS,
            asyncBidiStreamingCall(
              new MethodHandlers<
                io.axoniq.axondb.grpc.QueryEventsRequest,
                io.axoniq.axondb.grpc.QueryEventsResponse>(
                  this, METHODID_QUERY_EVENTS)))
          .addMethod(
            METHOD_GET_FIRST_TOKEN,
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axondb.grpc.GetFirstTokenRequest,
                io.axoniq.axondb.grpc.TrackingToken>(
                  this, METHODID_GET_FIRST_TOKEN)))
          .addMethod(
            METHOD_GET_LAST_TOKEN,
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axondb.grpc.GetLastTokenRequest,
                io.axoniq.axondb.grpc.TrackingToken>(
                  this, METHODID_GET_LAST_TOKEN)))
          .addMethod(
            METHOD_GET_TOKEN_AT,
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axondb.grpc.GetTokenAtRequest,
                io.axoniq.axondb.grpc.TrackingToken>(
                  this, METHODID_GET_TOKEN_AT)))
          .build();
    }
  }

  /**
   */
  public static final class EventStoreStub extends io.grpc.stub.AbstractStub<EventStoreStub> {
    private EventStoreStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventStoreStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventStoreStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventStoreStub(channel, callOptions);
    }

    /**
     * <pre>
     * Accepts a stream of Events returning a Confirmation when completed.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axondb.Event> appendEvent(
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.Confirmation> responseObserver) {
      return asyncClientStreamingCall(
          getChannel().newCall(METHOD_APPEND_EVENT, getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Accepts a Snapshot event returning a Confirmation when completed.
     * </pre>
     */
    public void appendSnapshot(io.axoniq.axondb.Event request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.Confirmation> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_APPEND_SNAPSHOT, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the Events for a given aggregate. Results are streamed rather than returned at once.
     * </pre>
     */
    public void listAggregateEvents(io.axoniq.axondb.grpc.GetAggregateEventsRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.Event> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(METHOD_LIST_AGGREGATE_EVENTS, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the Events from a given tracking token. Results are streamed rather than returned at once.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.GetEventsRequest> listEvents(
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.EventWithToken> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(METHOD_LIST_EVENTS, getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Gets the highest sequence number for a specific aggregate.
     * </pre>
     */
    public void readHighestSequenceNr(io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_READ_HIGHEST_SEQUENCE_NR, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Performs a query on the event store, returns a stream of results. Input is a stream to allow flow control from the
     * client
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.QueryEventsRequest> queryEvents(
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.QueryEventsResponse> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(METHOD_QUERY_EVENTS, getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Retrieves the first token available in event store (typically 0). Returns 0 when no events in store.
     * </pre>
     */
    public void getFirstToken(io.axoniq.axondb.grpc.GetFirstTokenRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_FIRST_TOKEN, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the last committed token in event store. Returns -1 when no events in store.
     * </pre>
     */
    public void getLastToken(io.axoniq.axondb.grpc.GetLastTokenRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_LAST_TOKEN, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieves the token of the first token of an event from specified time in event store. Returns -1 when no events in store.
     * </pre>
     */
    public void getTokenAt(io.axoniq.axondb.grpc.GetTokenAtRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_TOKEN_AT, getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class EventStoreBlockingStub extends io.grpc.stub.AbstractStub<EventStoreBlockingStub> {
    private EventStoreBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventStoreBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventStoreBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventStoreBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Accepts a Snapshot event returning a Confirmation when completed.
     * </pre>
     */
    public io.axoniq.axondb.grpc.Confirmation appendSnapshot(io.axoniq.axondb.Event request) {
      return blockingUnaryCall(
          getChannel(), METHOD_APPEND_SNAPSHOT, getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieves the Events for a given aggregate. Results are streamed rather than returned at once.
     * </pre>
     */
    public java.util.Iterator<io.axoniq.axondb.Event> listAggregateEvents(
        io.axoniq.axondb.grpc.GetAggregateEventsRequest request) {
      return blockingServerStreamingCall(
          getChannel(), METHOD_LIST_AGGREGATE_EVENTS, getCallOptions(), request);
    }

    /**
     * <pre>
     * Gets the highest sequence number for a specific aggregate.
     * </pre>
     */
    public io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse readHighestSequenceNr(io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_READ_HIGHEST_SEQUENCE_NR, getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieves the first token available in event store (typically 0). Returns 0 when no events in store.
     * </pre>
     */
    public io.axoniq.axondb.grpc.TrackingToken getFirstToken(io.axoniq.axondb.grpc.GetFirstTokenRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_FIRST_TOKEN, getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieves the last committed token in event store. Returns -1 when no events in store.
     * </pre>
     */
    public io.axoniq.axondb.grpc.TrackingToken getLastToken(io.axoniq.axondb.grpc.GetLastTokenRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_LAST_TOKEN, getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieves the token of the first token of an event from specified time in event store. Returns -1 when no events in store.
     * </pre>
     */
    public io.axoniq.axondb.grpc.TrackingToken getTokenAt(io.axoniq.axondb.grpc.GetTokenAtRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_TOKEN_AT, getCallOptions(), request);
    }
  }

  /**
   */
  public static final class EventStoreFutureStub extends io.grpc.stub.AbstractStub<EventStoreFutureStub> {
    private EventStoreFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventStoreFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventStoreFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventStoreFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Accepts a Snapshot event returning a Confirmation when completed.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axondb.grpc.Confirmation> appendSnapshot(
        io.axoniq.axondb.Event request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_APPEND_SNAPSHOT, getCallOptions()), request);
    }

    /**
     * <pre>
     * Gets the highest sequence number for a specific aggregate.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse> readHighestSequenceNr(
        io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_READ_HIGHEST_SEQUENCE_NR, getCallOptions()), request);
    }

    /**
     * <pre>
     * Retrieves the first token available in event store (typically 0). Returns 0 when no events in store.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axondb.grpc.TrackingToken> getFirstToken(
        io.axoniq.axondb.grpc.GetFirstTokenRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_FIRST_TOKEN, getCallOptions()), request);
    }

    /**
     * <pre>
     * Retrieves the last committed token in event store. Returns -1 when no events in store.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axondb.grpc.TrackingToken> getLastToken(
        io.axoniq.axondb.grpc.GetLastTokenRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_LAST_TOKEN, getCallOptions()), request);
    }

    /**
     * <pre>
     * Retrieves the token of the first token of an event from specified time in event store. Returns -1 when no events in store.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axondb.grpc.TrackingToken> getTokenAt(
        io.axoniq.axondb.grpc.GetTokenAtRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_TOKEN_AT, getCallOptions()), request);
    }
  }

  private static final int METHODID_APPEND_SNAPSHOT = 0;
  private static final int METHODID_LIST_AGGREGATE_EVENTS = 1;
  private static final int METHODID_READ_HIGHEST_SEQUENCE_NR = 2;
  private static final int METHODID_GET_FIRST_TOKEN = 3;
  private static final int METHODID_GET_LAST_TOKEN = 4;
  private static final int METHODID_GET_TOKEN_AT = 5;
  private static final int METHODID_APPEND_EVENT = 6;
  private static final int METHODID_LIST_EVENTS = 7;
  private static final int METHODID_QUERY_EVENTS = 8;

  private static class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final EventStoreImplBase serviceImpl;
    private final int methodId;

    public MethodHandlers(EventStoreImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_APPEND_SNAPSHOT:
          serviceImpl.appendSnapshot((io.axoniq.axondb.Event) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.Confirmation>) responseObserver);
          break;
        case METHODID_LIST_AGGREGATE_EVENTS:
          serviceImpl.listAggregateEvents((io.axoniq.axondb.grpc.GetAggregateEventsRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.Event>) responseObserver);
          break;
        case METHODID_READ_HIGHEST_SEQUENCE_NR:
          serviceImpl.readHighestSequenceNr((io.axoniq.axondb.grpc.ReadHighestSequenceNrRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.ReadHighestSequenceNrResponse>) responseObserver);
          break;
        case METHODID_GET_FIRST_TOKEN:
          serviceImpl.getFirstToken((io.axoniq.axondb.grpc.GetFirstTokenRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken>) responseObserver);
          break;
        case METHODID_GET_LAST_TOKEN:
          serviceImpl.getLastToken((io.axoniq.axondb.grpc.GetLastTokenRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken>) responseObserver);
          break;
        case METHODID_GET_TOKEN_AT:
          serviceImpl.getTokenAt((io.axoniq.axondb.grpc.GetTokenAtRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.TrackingToken>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_APPEND_EVENT:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.appendEvent(
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.Confirmation>) responseObserver);
        case METHODID_LIST_EVENTS:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.listEvents(
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.EventWithToken>) responseObserver);
        case METHODID_QUERY_EVENTS:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.queryEvents(
              (io.grpc.stub.StreamObserver<io.axoniq.axondb.grpc.QueryEventsResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static final class EventStoreDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier {
    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.axoniq.axondb.grpc.EventstoreApi.getDescriptor();
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (EventStoreGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new EventStoreDescriptorSupplier())
              .addMethod(METHOD_APPEND_EVENT)
              .addMethod(METHOD_APPEND_SNAPSHOT)
              .addMethod(METHOD_LIST_AGGREGATE_EVENTS)
              .addMethod(METHOD_LIST_EVENTS)
              .addMethod(METHOD_READ_HIGHEST_SEQUENCE_NR)
              .addMethod(METHOD_QUERY_EVENTS)
              .addMethod(METHOD_GET_FIRST_TOKEN)
              .addMethod(METHOD_GET_LAST_TOKEN)
              .addMethod(METHOD_GET_TOKEN_AT)
              .build();
        }
      }
    }
    return result;
  }
}
