/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client;

import io.axoniq.axondb.client.util.EventCipher;
import io.axoniq.platform.grpc.NodeInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="axoniq.axondb")
public class AxonDBConfiguration {
    private static final int DEFAULT_GRPC_PORT = 8123;
    private String servers;
    @NestedConfigurationProperty
    private FlowControl flowControl = new FlowControl();
    private String token;
    @NestedConfigurationProperty
    private AxonSSL ssl = new AxonSSL();
    private long connectionRetry = 2500L;
    private int connectionRetryCount = 5;
    private EventCipher eventCipher = new EventCipher();
    private String context;
    private long keepAliveTime = 0L;
    private long keepAliveTimeout = 5000L;
    private long commitTimeout = 10000L;
    private int heartbeatInterval = 60000;

    public AxonDBConfiguration() {
    }

    public AxonDBConfiguration(EventCipher eventCipher) {
        this.eventCipher = eventCipher;
    }

    @Value(value="${axoniq.axondb.eventSecretKey:#{null}}")
    private void setEventSecretKey(String key) {
        if (key != null && key.length() > 0) {
            this.eventCipher = new EventCipher(key.getBytes(StandardCharsets.US_ASCII));
        }
    }

    public static Builder newBuilder(String servers) {
        return new Builder(servers);
    }

    public List<NodeInfo> serverNodes() {
        ArrayList<NodeInfo> serverNodes = new ArrayList<NodeInfo>();
        if (this.servers != null) {
            String[] serverArr = this.servers.split(",");
            Arrays.stream(serverArr).forEach(serverString -> {
                String[] hostPort = serverString.trim().split(":", 2);
                if (hostPort.length == 1) {
                    serverNodes.add(NodeInfo.newBuilder().setHostName(hostPort[0]).setGrpcPort(8123).build());
                } else {
                    NodeInfo nodeInfo = NodeInfo.newBuilder().setHostName(hostPort[0]).setGrpcPort(Integer.valueOf(hostPort[1])).build();
                    serverNodes.add(nodeInfo);
                }
            });
        }
        return serverNodes;
    }

    public long getConnectionRetry() {
        return this.connectionRetry;
    }

    public int getConnectionRetryCount() {
        return this.connectionRetryCount;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getInitialNrOfPermits() {
        return this.flowControl.getInitialNrOfPermits();
    }

    public Integer getNrOfNewPermits() {
        return this.flowControl.getNrOfNewPermits();
    }

    public Integer getNewPermitsThreshold() {
        return this.flowControl.getNewPermitsThreshold();
    }

    public String getCertFile() {
        return this.ssl.getCertFile();
    }

    public EventCipher eventCipher() {
        return this.eventCipher;
    }

    public boolean isSslEnabled() {
        return this.ssl.isEnabled();
    }

    public String getContext() {
        return this.context;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public void setFlowControl(FlowControl flowControl) {
        this.flowControl = flowControl;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setSsl(AxonSSL ssl) {
        this.ssl = ssl;
    }

    public void setConnectionRetry(long connectionRetry) {
        this.connectionRetry = connectionRetry;
    }

    public void setConnectionRetryCount(int connectionRetryCount) {
        this.connectionRetryCount = connectionRetryCount;
    }

    public void setEventCipher(EventCipher eventCipher) {
        this.eventCipher = eventCipher;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getServers() {
        return this.servers;
    }

    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    public AxonSSL getSsl() {
        return this.ssl;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public long getCommitTimeout() {
        return this.commitTimeout;
    }

    public void setCommitTimeout(long commitTimeout) {
        this.commitTimeout = commitTimeout;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public static class FlowControl {
        private int initialNrOfPermits = 100000;
        private int nrOfNewPermits = 100000;
        private int newPermitsThreshold = 10000;

        public int getInitialNrOfPermits() {
            return this.initialNrOfPermits;
        }

        public void setInitialNrOfPermits(int initialNrOfPermits) {
            this.initialNrOfPermits = initialNrOfPermits;
        }

        public int getNrOfNewPermits() {
            return this.nrOfNewPermits;
        }

        public void setNrOfNewPermits(int nrOfNewPermits) {
            this.nrOfNewPermits = nrOfNewPermits;
        }

        public int getNewPermitsThreshold() {
            return this.newPermitsThreshold;
        }

        public void setNewPermitsThreshold(int newPermitsThreshold) {
            this.newPermitsThreshold = newPermitsThreshold;
        }
    }

    public static class AxonSSL {
        private String certFile;
        private boolean enabled;

        public String getCertFile() {
            return this.certFile;
        }

        public void setCertFile(String certFile) {
            this.certFile = certFile;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Builder {
        private AxonDBConfiguration instance = new AxonDBConfiguration();

        public Builder(String servers) {
            this.instance.servers = servers;
            this.instance.connectionRetry = 2500L;
            this.instance.connectionRetryCount = 5;
        }

        public Builder ssl(String certificateFilePath) {
            this.instance.ssl.certFile = certificateFilePath;
            this.instance.ssl.enabled = certificateFilePath != null;
            return this;
        }

        public Builder token(String token) {
            this.instance.token = token;
            return this;
        }

        public Builder context(String context) {
            this.instance.context = context;
            return this;
        }

        public Builder connectionRetry(long connectionRetryTime, int attempts) {
            this.instance.connectionRetry = connectionRetryTime;
            this.instance.connectionRetryCount = attempts;
            return this;
        }

        public Builder flowControl(Integer initialNrOfPermits, Integer nrOfNewPermits, Integer newPermitsThreshold) {
            this.instance.flowControl.setInitialNrOfPermits(initialNrOfPermits);
            this.instance.flowControl.setNrOfNewPermits(nrOfNewPermits);
            this.instance.flowControl.setNewPermitsThreshold(newPermitsThreshold);
            return this;
        }

        public Builder setEventSecretKey(String key) {
            this.instance.setEventSecretKey(key);
            return this;
        }

        public Builder eventCipher(EventCipher eventCipher) {
            this.instance.eventCipher = eventCipher;
            return this;
        }

        public Builder heartbeatInterval(int heartbeatInterval) {
            this.instance.setHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public AxonDBConfiguration build() {
            return this.instance;
        }
    }
}

