/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client;

import io.axoniq.axondb.client.ManagedChannelUtil;
import io.axoniq.platform.grpc.NodeInfo;
import io.axoniq.platform.grpc.PlatformInfo;
import io.grpc.ManagedChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private final Logger log = LoggerFactory.getLogger(ChannelManager.class);
    private final boolean sslEnabled;
    private final String certChainFile;
    private Map<NodeKey, ManagedChannel> clusterManagerChannels = new ConcurrentHashMap<NodeKey, ManagedChannel>();
    private final long keepAliveTimeout;
    private final long keepAliveTime;

    public ChannelManager(boolean sslEnabled, String certChainFile, long keepAliveTime, long keepAliveTimeout) {
        this.sslEnabled = sslEnabled;
        this.certChainFile = certChainFile;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public ManagedChannel getChannel(NodeInfo nodeInfo) {
        NodeKey nodeKey = new NodeKey(nodeInfo);
        ManagedChannel channel = this.clusterManagerChannels.computeIfAbsent(nodeKey, key -> ManagedChannelUtil.createManagedChannel(nodeInfo.getHostName(), nodeInfo.getGrpcPort(), this.sslEnabled, this.certChainFile, this.keepAliveTime, this.keepAliveTimeout));
        if (channel.isShutdown() || channel.isTerminated()) {
            this.log.debug("Connection to {} lost, reconnecting", (Object)nodeInfo.getGrpcPort());
            this.clusterManagerChannels.remove(nodeKey);
            return this.getChannel(nodeInfo);
        }
        this.log.debug("Got channel for connection to {}:{}, channel = {}", new Object[]{nodeInfo.getHostName(), nodeInfo.getGrpcPort(), channel});
        return channel;
    }

    public void cleanup() {
        this.clusterManagerChannels.values().forEach(ManagedChannel::shutdownNow);
    }

    public void shutdown(PlatformInfo nodeInfo) {
        NodeKey nodeKey = new NodeKey(nodeInfo.getPrimary());
        ManagedChannel channel = this.clusterManagerChannels.remove(nodeKey);
        if (channel != null) {
            channel.shutdown();
        }
    }

    static class NodeKey {
        private final String hostName;
        private final int grpcPort;

        NodeKey(NodeInfo nodeInfo) {
            this.hostName = nodeInfo.getHostName();
            this.grpcPort = nodeInfo.getGrpcPort();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeKey nodeKey = (NodeKey)o;
            return this.grpcPort == nodeKey.grpcPort && this.hostName.equals(nodeKey.hostName);
        }

        public int hashCode() {
            int result = this.hostName.hashCode();
            result = 31 * result + this.grpcPort;
            return result;
        }
    }
}

