/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client;

import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingStreamObserver<T>
implements StreamObserver<T> {
    private static final Logger logger = LoggerFactory.getLogger(SendingStreamObserver.class);
    private final StreamObserver<T> delegate;

    public SendingStreamObserver(StreamObserver<T> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T t) {
        StreamObserver<T> streamObserver = this.delegate;
        synchronized (streamObserver) {
            if (logger.isTraceEnabled()) {
                logger.trace("Send {}", t);
            }
            this.delegate.onNext(t);
        }
    }

    public void onError(Throwable throwable) {
        try {
            this.delegate.onError(throwable);
        }
        catch (Throwable t) {
            logger.debug("Failed send error on connection", t);
        }
    }

    public void onCompleted() {
        try {
            this.delegate.onCompleted();
        }
        catch (Throwable t) {
            logger.debug("Failed to complete connection", t);
        }
    }
}

