/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client.util;

import io.axoniq.axondb.client.AxonDBConfiguration;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControllingStreamObserver<T>
implements StreamObserver<T> {
    private final StreamObserver<T> wrappedStreamObserver;
    private static final Logger logger = LoggerFactory.getLogger(FlowControllingStreamObserver.class);
    private final AtomicLong remainingPermits;
    private final int newPermits;
    private final T newPermitsRequest;
    private final Predicate<T> isConfirmationMessage;

    public FlowControllingStreamObserver(StreamObserver<T> wrappedStreamObserver, AxonDBConfiguration configuration, Function<Integer, T> requestWrapper, Predicate<T> isConfirmationMessage) {
        this.wrappedStreamObserver = wrappedStreamObserver;
        this.remainingPermits = new AtomicLong(configuration.getInitialNrOfPermits() - configuration.getNewPermitsThreshold());
        this.newPermits = configuration.getNrOfNewPermits();
        this.newPermitsRequest = requestWrapper.apply(this.newPermits);
        this.isConfirmationMessage = isConfirmationMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T t) {
        StreamObserver<T> streamObserver = this.wrappedStreamObserver;
        synchronized (streamObserver) {
            this.wrappedStreamObserver.onNext(t);
        }
        logger.debug("Sending response to messaging platform, remaining permits: {}", (Object)this.remainingPermits.get());
        if (this.isConfirmationMessage.test(t)) {
            this.markConsumed(1);
        }
    }

    public void onError(Throwable throwable) {
        this.wrappedStreamObserver.onError(throwable);
    }

    public void onCompleted() {
        logger.debug("Observer stopped");
        try {
            this.wrappedStreamObserver.onCompleted();
        }
        catch (Exception ignore) {
            logger.info("Observer stopped: {}", (Object)ignore.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markConsumed(Integer consumed) {
        if (this.remainingPermits.updateAndGet(old -> old - (long)consumed.intValue()) == 0L) {
            this.remainingPermits.addAndGet(this.newPermits);
            StreamObserver<T> streamObserver = this.wrappedStreamObserver;
            synchronized (streamObserver) {
                this.wrappedStreamObserver.onNext(this.newPermitsRequest);
            }
            logger.debug("Requesting new permits: {}", this.newPermitsRequest);
        }
    }
}

