/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axondb.client.util;

import io.axoniq.axondb.client.util.EventStoreClientException;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;

public class GrpcExceptionParser {
    private static Metadata.Key<String> ERROR_CODE_KEY = Metadata.Key.of((String)"ErrorCode", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public static EventStoreClientException parse(Throwable ex) {
        String code = "AXONIQ-0001";
        if (ex instanceof StatusRuntimeException) {
            if (ex.getCause() instanceof EventStoreClientException) {
                return (EventStoreClientException)ex.getCause();
            }
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)ex;
            Metadata trailer = statusRuntimeException.getTrailers();
            String errorCode = (String)trailer.get(ERROR_CODE_KEY);
            if (errorCode != null) {
                code = errorCode;
            }
        }
        return new EventStoreClientException(code, ex.getMessage(), ex);
    }
}

