package io.axoniq.axonserver.grpc.admin;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 ****************************** Event Processor Admin Service ***************************
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.19.0)",
    comments = "Source: admin.proto")
public final class EventProcessorAdminServiceGrpc {

  private EventProcessorAdminServiceGrpc() {}

  public static final String SERVICE_NAME = "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getPauseEventProcessorMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PauseEventProcessor",
      requestType = io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.class,
      responseType = io.axoniq.axonserver.grpc.admin.AdminActionResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getPauseEventProcessorMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult> getPauseEventProcessorMethod;
    if ((getPauseEventProcessorMethod = EventProcessorAdminServiceGrpc.getPauseEventProcessorMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getPauseEventProcessorMethod = EventProcessorAdminServiceGrpc.getPauseEventProcessorMethod) == null) {
          EventProcessorAdminServiceGrpc.getPauseEventProcessorMethod = getPauseEventProcessorMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "PauseEventProcessor"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.AdminActionResult.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("PauseEventProcessor"))
                  .build();
          }
        }
     }
     return getPauseEventProcessorMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getStartEventProcessorMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StartEventProcessor",
      requestType = io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.class,
      responseType = io.axoniq.axonserver.grpc.admin.AdminActionResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getStartEventProcessorMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult> getStartEventProcessorMethod;
    if ((getStartEventProcessorMethod = EventProcessorAdminServiceGrpc.getStartEventProcessorMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getStartEventProcessorMethod = EventProcessorAdminServiceGrpc.getStartEventProcessorMethod) == null) {
          EventProcessorAdminServiceGrpc.getStartEventProcessorMethod = getStartEventProcessorMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "StartEventProcessor"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.AdminActionResult.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("StartEventProcessor"))
                  .build();
          }
        }
     }
     return getStartEventProcessorMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getSplitEventProcessorMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SplitEventProcessor",
      requestType = io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.class,
      responseType = io.axoniq.axonserver.grpc.admin.AdminActionResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getSplitEventProcessorMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult> getSplitEventProcessorMethod;
    if ((getSplitEventProcessorMethod = EventProcessorAdminServiceGrpc.getSplitEventProcessorMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getSplitEventProcessorMethod = EventProcessorAdminServiceGrpc.getSplitEventProcessorMethod) == null) {
          EventProcessorAdminServiceGrpc.getSplitEventProcessorMethod = getSplitEventProcessorMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "SplitEventProcessor"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.AdminActionResult.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("SplitEventProcessor"))
                  .build();
          }
        }
     }
     return getSplitEventProcessorMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getMergeEventProcessorMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "MergeEventProcessor",
      requestType = io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.class,
      responseType = io.axoniq.axonserver.grpc.admin.AdminActionResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getMergeEventProcessorMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult> getMergeEventProcessorMethod;
    if ((getMergeEventProcessorMethod = EventProcessorAdminServiceGrpc.getMergeEventProcessorMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getMergeEventProcessorMethod = EventProcessorAdminServiceGrpc.getMergeEventProcessorMethod) == null) {
          EventProcessorAdminServiceGrpc.getMergeEventProcessorMethod = getMergeEventProcessorMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier, io.axoniq.axonserver.grpc.admin.AdminActionResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "MergeEventProcessor"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.AdminActionResult.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("MergeEventProcessor"))
                  .build();
          }
        }
     }
     return getMergeEventProcessorMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.MoveSegment,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getMoveEventProcessorSegmentMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "MoveEventProcessorSegment",
      requestType = io.axoniq.axonserver.grpc.admin.MoveSegment.class,
      responseType = io.axoniq.axonserver.grpc.admin.AdminActionResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.MoveSegment,
      io.axoniq.axonserver.grpc.admin.AdminActionResult> getMoveEventProcessorSegmentMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.MoveSegment, io.axoniq.axonserver.grpc.admin.AdminActionResult> getMoveEventProcessorSegmentMethod;
    if ((getMoveEventProcessorSegmentMethod = EventProcessorAdminServiceGrpc.getMoveEventProcessorSegmentMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getMoveEventProcessorSegmentMethod = EventProcessorAdminServiceGrpc.getMoveEventProcessorSegmentMethod) == null) {
          EventProcessorAdminServiceGrpc.getMoveEventProcessorSegmentMethod = getMoveEventProcessorSegmentMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.admin.MoveSegment, io.axoniq.axonserver.grpc.admin.AdminActionResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "MoveEventProcessorSegment"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.MoveSegment.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.AdminActionResult.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("MoveEventProcessorSegment"))
                  .build();
          }
        }
     }
     return getMoveEventProcessorSegmentMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.axoniq.axonserver.grpc.admin.EventProcessor> getGetAllEventProcessorsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetAllEventProcessors",
      requestType = com.google.protobuf.Empty.class,
      responseType = io.axoniq.axonserver.grpc.admin.EventProcessor.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.axoniq.axonserver.grpc.admin.EventProcessor> getGetAllEventProcessorsMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, io.axoniq.axonserver.grpc.admin.EventProcessor> getGetAllEventProcessorsMethod;
    if ((getGetAllEventProcessorsMethod = EventProcessorAdminServiceGrpc.getGetAllEventProcessorsMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getGetAllEventProcessorsMethod = EventProcessorAdminServiceGrpc.getGetAllEventProcessorsMethod) == null) {
          EventProcessorAdminServiceGrpc.getGetAllEventProcessorsMethod = getGetAllEventProcessorsMethod = 
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, io.axoniq.axonserver.grpc.admin.EventProcessor>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "GetAllEventProcessors"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.EventProcessor.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("GetAllEventProcessors"))
                  .build();
          }
        }
     }
     return getGetAllEventProcessorsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.Component,
      io.axoniq.axonserver.grpc.admin.EventProcessor> getGetEventProcessorsByComponentMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetEventProcessorsByComponent",
      requestType = io.axoniq.axonserver.grpc.Component.class,
      responseType = io.axoniq.axonserver.grpc.admin.EventProcessor.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.Component,
      io.axoniq.axonserver.grpc.admin.EventProcessor> getGetEventProcessorsByComponentMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.Component, io.axoniq.axonserver.grpc.admin.EventProcessor> getGetEventProcessorsByComponentMethod;
    if ((getGetEventProcessorsByComponentMethod = EventProcessorAdminServiceGrpc.getGetEventProcessorsByComponentMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getGetEventProcessorsByComponentMethod = EventProcessorAdminServiceGrpc.getGetEventProcessorsByComponentMethod) == null) {
          EventProcessorAdminServiceGrpc.getGetEventProcessorsByComponentMethod = getGetEventProcessorsByComponentMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.Component, io.axoniq.axonserver.grpc.admin.EventProcessor>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "GetEventProcessorsByComponent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.Component.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.EventProcessor.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("GetEventProcessorsByComponent"))
                  .build();
          }
        }
     }
     return getGetEventProcessorsByComponentMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest,
      com.google.protobuf.Empty> getLoadBalanceProcessorMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "LoadBalanceProcessor",
      requestType = io.axoniq.axonserver.grpc.admin.LoadBalanceRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest,
      com.google.protobuf.Empty> getLoadBalanceProcessorMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest, com.google.protobuf.Empty> getLoadBalanceProcessorMethod;
    if ((getLoadBalanceProcessorMethod = EventProcessorAdminServiceGrpc.getLoadBalanceProcessorMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getLoadBalanceProcessorMethod = EventProcessorAdminServiceGrpc.getLoadBalanceProcessorMethod) == null) {
          EventProcessorAdminServiceGrpc.getLoadBalanceProcessorMethod = getLoadBalanceProcessorMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "LoadBalanceProcessor"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.LoadBalanceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("LoadBalanceProcessor"))
                  .build();
          }
        }
     }
     return getLoadBalanceProcessorMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest,
      com.google.protobuf.Empty> getSetAutoLoadBalanceStrategyMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SetAutoLoadBalanceStrategy",
      requestType = io.axoniq.axonserver.grpc.admin.LoadBalanceRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest,
      com.google.protobuf.Empty> getSetAutoLoadBalanceStrategyMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest, com.google.protobuf.Empty> getSetAutoLoadBalanceStrategyMethod;
    if ((getSetAutoLoadBalanceStrategyMethod = EventProcessorAdminServiceGrpc.getSetAutoLoadBalanceStrategyMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getSetAutoLoadBalanceStrategyMethod = EventProcessorAdminServiceGrpc.getSetAutoLoadBalanceStrategyMethod) == null) {
          EventProcessorAdminServiceGrpc.getSetAutoLoadBalanceStrategyMethod = getSetAutoLoadBalanceStrategyMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.admin.LoadBalanceRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "SetAutoLoadBalanceStrategy"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.LoadBalanceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("SetAutoLoadBalanceStrategy"))
                  .build();
          }
        }
     }
     return getSetAutoLoadBalanceStrategyMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy> getGetBalancingStrategiesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetBalancingStrategies",
      requestType = com.google.protobuf.Empty.class,
      responseType = io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy> getGetBalancingStrategiesMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy> getGetBalancingStrategiesMethod;
    if ((getGetBalancingStrategiesMethod = EventProcessorAdminServiceGrpc.getGetBalancingStrategiesMethod) == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        if ((getGetBalancingStrategiesMethod = EventProcessorAdminServiceGrpc.getGetBalancingStrategiesMethod) == null) {
          EventProcessorAdminServiceGrpc.getGetBalancingStrategiesMethod = getGetBalancingStrategiesMethod = 
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.admin.EventProcessorAdminService", "GetBalancingStrategies"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy.getDefaultInstance()))
                  .setSchemaDescriptor(new EventProcessorAdminServiceMethodDescriptorSupplier("GetBalancingStrategies"))
                  .build();
          }
        }
     }
     return getGetBalancingStrategiesMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static EventProcessorAdminServiceStub newStub(io.grpc.Channel channel) {
    return new EventProcessorAdminServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static EventProcessorAdminServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new EventProcessorAdminServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static EventProcessorAdminServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new EventProcessorAdminServiceFutureStub(channel);
  }

  /**
   * <pre>
   ****************************** Event Processor Admin Service ***************************
   * </pre>
   */
  public static abstract class EventProcessorAdminServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Request to pause an event processor 
     * </pre>
     */
    public void pauseEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnimplementedUnaryCall(getPauseEventProcessorMethod(), responseObserver);
    }

    /**
     * <pre>
     * Request to start an event processor 
     * </pre>
     */
    public void startEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnimplementedUnaryCall(getStartEventProcessorMethod(), responseObserver);
    }

    /**
     * <pre>
     * Request to split the largest segment of a streaming event processor 
     * </pre>
     */
    public void splitEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSplitEventProcessorMethod(), responseObserver);
    }

    /**
     * <pre>
     * Request to merge the smallest two segments of a streaming event processor 
     * </pre>
     */
    public void mergeEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnimplementedUnaryCall(getMergeEventProcessorMethod(), responseObserver);
    }

    /**
     * <pre>
     * Request to move the specified segment of a streaming event processor to the desired destination 
     * </pre>
     */
    public void moveEventProcessorSegment(io.axoniq.axonserver.grpc.admin.MoveSegment request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnimplementedUnaryCall(getMoveEventProcessorSegmentMethod(), responseObserver);
    }

    /**
     * <pre>
     * Retrieves all event processors registered in an Axon Server cluster 
     * </pre>
     */
    public void getAllEventProcessors(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.EventProcessor> responseObserver) {
      asyncUnimplementedUnaryCall(getGetAllEventProcessorsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Retrieves all event processors registered in an Axon Server cluster for the specified component
     * </pre>
     */
    public void getEventProcessorsByComponent(io.axoniq.axonserver.grpc.Component request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.EventProcessor> responseObserver) {
      asyncUnimplementedUnaryCall(getGetEventProcessorsByComponentMethod(), responseObserver);
    }

    /**
     */
    public void loadBalanceProcessor(io.axoniq.axonserver.grpc.admin.LoadBalanceRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getLoadBalanceProcessorMethod(), responseObserver);
    }

    /**
     */
    public void setAutoLoadBalanceStrategy(io.axoniq.axonserver.grpc.admin.LoadBalanceRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getSetAutoLoadBalanceStrategyMethod(), responseObserver);
    }

    /**
     */
    public void getBalancingStrategies(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy> responseObserver) {
      asyncUnimplementedUnaryCall(getGetBalancingStrategiesMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPauseEventProcessorMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
                io.axoniq.axonserver.grpc.admin.AdminActionResult>(
                  this, METHODID_PAUSE_EVENT_PROCESSOR)))
          .addMethod(
            getStartEventProcessorMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
                io.axoniq.axonserver.grpc.admin.AdminActionResult>(
                  this, METHODID_START_EVENT_PROCESSOR)))
          .addMethod(
            getSplitEventProcessorMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
                io.axoniq.axonserver.grpc.admin.AdminActionResult>(
                  this, METHODID_SPLIT_EVENT_PROCESSOR)))
          .addMethod(
            getMergeEventProcessorMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier,
                io.axoniq.axonserver.grpc.admin.AdminActionResult>(
                  this, METHODID_MERGE_EVENT_PROCESSOR)))
          .addMethod(
            getMoveEventProcessorSegmentMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.admin.MoveSegment,
                io.axoniq.axonserver.grpc.admin.AdminActionResult>(
                  this, METHODID_MOVE_EVENT_PROCESSOR_SEGMENT)))
          .addMethod(
            getGetAllEventProcessorsMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                com.google.protobuf.Empty,
                io.axoniq.axonserver.grpc.admin.EventProcessor>(
                  this, METHODID_GET_ALL_EVENT_PROCESSORS)))
          .addMethod(
            getGetEventProcessorsByComponentMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.Component,
                io.axoniq.axonserver.grpc.admin.EventProcessor>(
                  this, METHODID_GET_EVENT_PROCESSORS_BY_COMPONENT)))
          .addMethod(
            getLoadBalanceProcessorMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.admin.LoadBalanceRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_LOAD_BALANCE_PROCESSOR)))
          .addMethod(
            getSetAutoLoadBalanceStrategyMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.admin.LoadBalanceRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_SET_AUTO_LOAD_BALANCE_STRATEGY)))
          .addMethod(
            getGetBalancingStrategiesMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                com.google.protobuf.Empty,
                io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy>(
                  this, METHODID_GET_BALANCING_STRATEGIES)))
          .build();
    }
  }

  /**
   * <pre>
   ****************************** Event Processor Admin Service ***************************
   * </pre>
   */
  public static final class EventProcessorAdminServiceStub extends io.grpc.stub.AbstractStub<EventProcessorAdminServiceStub> {
    private EventProcessorAdminServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventProcessorAdminServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventProcessorAdminServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventProcessorAdminServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Request to pause an event processor 
     * </pre>
     */
    public void pauseEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPauseEventProcessorMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Request to start an event processor 
     * </pre>
     */
    public void startEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getStartEventProcessorMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Request to split the largest segment of a streaming event processor 
     * </pre>
     */
    public void splitEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSplitEventProcessorMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Request to merge the smallest two segments of a streaming event processor 
     * </pre>
     */
    public void mergeEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getMergeEventProcessorMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Request to move the specified segment of a streaming event processor to the desired destination 
     * </pre>
     */
    public void moveEventProcessorSegment(io.axoniq.axonserver.grpc.admin.MoveSegment request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getMoveEventProcessorSegmentMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieves all event processors registered in an Axon Server cluster 
     * </pre>
     */
    public void getAllEventProcessors(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.EventProcessor> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getGetAllEventProcessorsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Retrieves all event processors registered in an Axon Server cluster for the specified component
     * </pre>
     */
    public void getEventProcessorsByComponent(io.axoniq.axonserver.grpc.Component request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.EventProcessor> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getGetEventProcessorsByComponentMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void loadBalanceProcessor(io.axoniq.axonserver.grpc.admin.LoadBalanceRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getLoadBalanceProcessorMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void setAutoLoadBalanceStrategy(io.axoniq.axonserver.grpc.admin.LoadBalanceRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getSetAutoLoadBalanceStrategyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void getBalancingStrategies(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getGetBalancingStrategiesMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   ****************************** Event Processor Admin Service ***************************
   * </pre>
   */
  public static final class EventProcessorAdminServiceBlockingStub extends io.grpc.stub.AbstractStub<EventProcessorAdminServiceBlockingStub> {
    private EventProcessorAdminServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventProcessorAdminServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventProcessorAdminServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventProcessorAdminServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Request to pause an event processor 
     * </pre>
     */
    public io.axoniq.axonserver.grpc.admin.AdminActionResult pauseEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return blockingUnaryCall(
          getChannel(), getPauseEventProcessorMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Request to start an event processor 
     * </pre>
     */
    public io.axoniq.axonserver.grpc.admin.AdminActionResult startEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return blockingUnaryCall(
          getChannel(), getStartEventProcessorMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Request to split the largest segment of a streaming event processor 
     * </pre>
     */
    public io.axoniq.axonserver.grpc.admin.AdminActionResult splitEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return blockingUnaryCall(
          getChannel(), getSplitEventProcessorMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Request to merge the smallest two segments of a streaming event processor 
     * </pre>
     */
    public io.axoniq.axonserver.grpc.admin.AdminActionResult mergeEventProcessor(io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return blockingUnaryCall(
          getChannel(), getMergeEventProcessorMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Request to move the specified segment of a streaming event processor to the desired destination 
     * </pre>
     */
    public io.axoniq.axonserver.grpc.admin.AdminActionResult moveEventProcessorSegment(io.axoniq.axonserver.grpc.admin.MoveSegment request) {
      return blockingUnaryCall(
          getChannel(), getMoveEventProcessorSegmentMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieves all event processors registered in an Axon Server cluster 
     * </pre>
     */
    public java.util.Iterator<io.axoniq.axonserver.grpc.admin.EventProcessor> getAllEventProcessors(
        com.google.protobuf.Empty request) {
      return blockingServerStreamingCall(
          getChannel(), getGetAllEventProcessorsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Retrieves all event processors registered in an Axon Server cluster for the specified component
     * </pre>
     */
    public java.util.Iterator<io.axoniq.axonserver.grpc.admin.EventProcessor> getEventProcessorsByComponent(
        io.axoniq.axonserver.grpc.Component request) {
      return blockingServerStreamingCall(
          getChannel(), getGetEventProcessorsByComponentMethod(), getCallOptions(), request);
    }

    /**
     */
    public java.util.Iterator<com.google.protobuf.Empty> loadBalanceProcessor(
        io.axoniq.axonserver.grpc.admin.LoadBalanceRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getLoadBalanceProcessorMethod(), getCallOptions(), request);
    }

    /**
     */
    public java.util.Iterator<com.google.protobuf.Empty> setAutoLoadBalanceStrategy(
        io.axoniq.axonserver.grpc.admin.LoadBalanceRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getSetAutoLoadBalanceStrategyMethod(), getCallOptions(), request);
    }

    /**
     */
    public java.util.Iterator<io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy> getBalancingStrategies(
        com.google.protobuf.Empty request) {
      return blockingServerStreamingCall(
          getChannel(), getGetBalancingStrategiesMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   ****************************** Event Processor Admin Service ***************************
   * </pre>
   */
  public static final class EventProcessorAdminServiceFutureStub extends io.grpc.stub.AbstractStub<EventProcessorAdminServiceFutureStub> {
    private EventProcessorAdminServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventProcessorAdminServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventProcessorAdminServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventProcessorAdminServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Request to pause an event processor 
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.admin.AdminActionResult> pauseEventProcessor(
        io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return futureUnaryCall(
          getChannel().newCall(getPauseEventProcessorMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Request to start an event processor 
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.admin.AdminActionResult> startEventProcessor(
        io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return futureUnaryCall(
          getChannel().newCall(getStartEventProcessorMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Request to split the largest segment of a streaming event processor 
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.admin.AdminActionResult> splitEventProcessor(
        io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return futureUnaryCall(
          getChannel().newCall(getSplitEventProcessorMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Request to merge the smallest two segments of a streaming event processor 
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.admin.AdminActionResult> mergeEventProcessor(
        io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier request) {
      return futureUnaryCall(
          getChannel().newCall(getMergeEventProcessorMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Request to move the specified segment of a streaming event processor to the desired destination 
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.admin.AdminActionResult> moveEventProcessorSegment(
        io.axoniq.axonserver.grpc.admin.MoveSegment request) {
      return futureUnaryCall(
          getChannel().newCall(getMoveEventProcessorSegmentMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PAUSE_EVENT_PROCESSOR = 0;
  private static final int METHODID_START_EVENT_PROCESSOR = 1;
  private static final int METHODID_SPLIT_EVENT_PROCESSOR = 2;
  private static final int METHODID_MERGE_EVENT_PROCESSOR = 3;
  private static final int METHODID_MOVE_EVENT_PROCESSOR_SEGMENT = 4;
  private static final int METHODID_GET_ALL_EVENT_PROCESSORS = 5;
  private static final int METHODID_GET_EVENT_PROCESSORS_BY_COMPONENT = 6;
  private static final int METHODID_LOAD_BALANCE_PROCESSOR = 7;
  private static final int METHODID_SET_AUTO_LOAD_BALANCE_STRATEGY = 8;
  private static final int METHODID_GET_BALANCING_STRATEGIES = 9;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final EventProcessorAdminServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(EventProcessorAdminServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PAUSE_EVENT_PROCESSOR:
          serviceImpl.pauseEventProcessor((io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult>) responseObserver);
          break;
        case METHODID_START_EVENT_PROCESSOR:
          serviceImpl.startEventProcessor((io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult>) responseObserver);
          break;
        case METHODID_SPLIT_EVENT_PROCESSOR:
          serviceImpl.splitEventProcessor((io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult>) responseObserver);
          break;
        case METHODID_MERGE_EVENT_PROCESSOR:
          serviceImpl.mergeEventProcessor((io.axoniq.axonserver.grpc.admin.EventProcessorIdentifier) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult>) responseObserver);
          break;
        case METHODID_MOVE_EVENT_PROCESSOR_SEGMENT:
          serviceImpl.moveEventProcessorSegment((io.axoniq.axonserver.grpc.admin.MoveSegment) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.AdminActionResult>) responseObserver);
          break;
        case METHODID_GET_ALL_EVENT_PROCESSORS:
          serviceImpl.getAllEventProcessors((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.EventProcessor>) responseObserver);
          break;
        case METHODID_GET_EVENT_PROCESSORS_BY_COMPONENT:
          serviceImpl.getEventProcessorsByComponent((io.axoniq.axonserver.grpc.Component) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.EventProcessor>) responseObserver);
          break;
        case METHODID_LOAD_BALANCE_PROCESSOR:
          serviceImpl.loadBalanceProcessor((io.axoniq.axonserver.grpc.admin.LoadBalanceRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_SET_AUTO_LOAD_BALANCE_STRATEGY:
          serviceImpl.setAutoLoadBalanceStrategy((io.axoniq.axonserver.grpc.admin.LoadBalanceRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_GET_BALANCING_STRATEGIES:
          serviceImpl.getBalancingStrategies((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.admin.LoadBalancingStrategy>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class EventProcessorAdminServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    EventProcessorAdminServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.axoniq.axonserver.grpc.admin.Admin.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("EventProcessorAdminService");
    }
  }

  private static final class EventProcessorAdminServiceFileDescriptorSupplier
      extends EventProcessorAdminServiceBaseDescriptorSupplier {
    EventProcessorAdminServiceFileDescriptorSupplier() {}
  }

  private static final class EventProcessorAdminServiceMethodDescriptorSupplier
      extends EventProcessorAdminServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    EventProcessorAdminServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (EventProcessorAdminServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new EventProcessorAdminServiceFileDescriptorSupplier())
              .addMethod(getPauseEventProcessorMethod())
              .addMethod(getStartEventProcessorMethod())
              .addMethod(getSplitEventProcessorMethod())
              .addMethod(getMergeEventProcessorMethod())
              .addMethod(getMoveEventProcessorSegmentMethod())
              .addMethod(getGetAllEventProcessorsMethod())
              .addMethod(getGetEventProcessorsByComponentMethod())
              .addMethod(getLoadBalanceProcessorMethod())
              .addMethod(getSetAutoLoadBalanceStrategyMethod())
              .addMethod(getGetBalancingStrategiesMethod())
              .build();
        }
      }
    }
    return result;
  }
}
