package io.axoniq.axonserver.grpc.event;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Service to transform events in an event store 
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.19.0)",
    comments = "Source: event.proto")
public final class EventTransformationServiceGrpc {

  private EventTransformationServiceGrpc() {}

  public static final String SERVICE_NAME = "io.axoniq.axonserver.grpc.event.EventTransformationService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.axoniq.axonserver.grpc.event.Transformation> getTransformationsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Transformations",
      requestType = com.google.protobuf.Empty.class,
      responseType = io.axoniq.axonserver.grpc.event.Transformation.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.axoniq.axonserver.grpc.event.Transformation> getTransformationsMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, io.axoniq.axonserver.grpc.event.Transformation> getTransformationsMethod;
    if ((getTransformationsMethod = EventTransformationServiceGrpc.getTransformationsMethod) == null) {
      synchronized (EventTransformationServiceGrpc.class) {
        if ((getTransformationsMethod = EventTransformationServiceGrpc.getTransformationsMethod) == null) {
          EventTransformationServiceGrpc.getTransformationsMethod = getTransformationsMethod = 
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, io.axoniq.axonserver.grpc.event.Transformation>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventTransformationService", "Transformations"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.Transformation.getDefaultInstance()))
                  .setSchemaDescriptor(new EventTransformationServiceMethodDescriptorSupplier("Transformations"))
                  .build();
          }
        }
     }
     return getTransformationsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.StartTransformationRequest,
      io.axoniq.axonserver.grpc.event.TransformationId> getStartTransformationMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StartTransformation",
      requestType = io.axoniq.axonserver.grpc.event.StartTransformationRequest.class,
      responseType = io.axoniq.axonserver.grpc.event.TransformationId.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.StartTransformationRequest,
      io.axoniq.axonserver.grpc.event.TransformationId> getStartTransformationMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.StartTransformationRequest, io.axoniq.axonserver.grpc.event.TransformationId> getStartTransformationMethod;
    if ((getStartTransformationMethod = EventTransformationServiceGrpc.getStartTransformationMethod) == null) {
      synchronized (EventTransformationServiceGrpc.class) {
        if ((getStartTransformationMethod = EventTransformationServiceGrpc.getStartTransformationMethod) == null) {
          EventTransformationServiceGrpc.getStartTransformationMethod = getStartTransformationMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.StartTransformationRequest, io.axoniq.axonserver.grpc.event.TransformationId>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventTransformationService", "StartTransformation"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.StartTransformationRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.TransformationId.getDefaultInstance()))
                  .setSchemaDescriptor(new EventTransformationServiceMethodDescriptorSupplier("StartTransformation"))
                  .build();
          }
        }
     }
     return getStartTransformationMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.TransformRequest,
      io.axoniq.axonserver.grpc.event.TransformRequestAck> getTransformEventsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "TransformEvents",
      requestType = io.axoniq.axonserver.grpc.event.TransformRequest.class,
      responseType = io.axoniq.axonserver.grpc.event.TransformRequestAck.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.TransformRequest,
      io.axoniq.axonserver.grpc.event.TransformRequestAck> getTransformEventsMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.TransformRequest, io.axoniq.axonserver.grpc.event.TransformRequestAck> getTransformEventsMethod;
    if ((getTransformEventsMethod = EventTransformationServiceGrpc.getTransformEventsMethod) == null) {
      synchronized (EventTransformationServiceGrpc.class) {
        if ((getTransformEventsMethod = EventTransformationServiceGrpc.getTransformEventsMethod) == null) {
          EventTransformationServiceGrpc.getTransformEventsMethod = getTransformEventsMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.TransformRequest, io.axoniq.axonserver.grpc.event.TransformRequestAck>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventTransformationService", "TransformEvents"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.TransformRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.TransformRequestAck.getDefaultInstance()))
                  .setSchemaDescriptor(new EventTransformationServiceMethodDescriptorSupplier("TransformEvents"))
                  .build();
          }
        }
     }
     return getTransformEventsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.TransformationId,
      com.google.protobuf.Empty> getCancelTransformationMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CancelTransformation",
      requestType = io.axoniq.axonserver.grpc.event.TransformationId.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.TransformationId,
      com.google.protobuf.Empty> getCancelTransformationMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.TransformationId, com.google.protobuf.Empty> getCancelTransformationMethod;
    if ((getCancelTransformationMethod = EventTransformationServiceGrpc.getCancelTransformationMethod) == null) {
      synchronized (EventTransformationServiceGrpc.class) {
        if ((getCancelTransformationMethod = EventTransformationServiceGrpc.getCancelTransformationMethod) == null) {
          EventTransformationServiceGrpc.getCancelTransformationMethod = getCancelTransformationMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.TransformationId, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventTransformationService", "CancelTransformation"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.TransformationId.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new EventTransformationServiceMethodDescriptorSupplier("CancelTransformation"))
                  .build();
          }
        }
     }
     return getCancelTransformationMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.ApplyTransformationRequest,
      com.google.protobuf.Empty> getApplyTransformationMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ApplyTransformation",
      requestType = io.axoniq.axonserver.grpc.event.ApplyTransformationRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.ApplyTransformationRequest,
      com.google.protobuf.Empty> getApplyTransformationMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.ApplyTransformationRequest, com.google.protobuf.Empty> getApplyTransformationMethod;
    if ((getApplyTransformationMethod = EventTransformationServiceGrpc.getApplyTransformationMethod) == null) {
      synchronized (EventTransformationServiceGrpc.class) {
        if ((getApplyTransformationMethod = EventTransformationServiceGrpc.getApplyTransformationMethod) == null) {
          EventTransformationServiceGrpc.getApplyTransformationMethod = getApplyTransformationMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.ApplyTransformationRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventTransformationService", "ApplyTransformation"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.ApplyTransformationRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new EventTransformationServiceMethodDescriptorSupplier("ApplyTransformation"))
                  .build();
          }
        }
     }
     return getApplyTransformationMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.CompactionRequest,
      com.google.protobuf.Empty> getCompactMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Compact",
      requestType = io.axoniq.axonserver.grpc.event.CompactionRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.CompactionRequest,
      com.google.protobuf.Empty> getCompactMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.CompactionRequest, com.google.protobuf.Empty> getCompactMethod;
    if ((getCompactMethod = EventTransformationServiceGrpc.getCompactMethod) == null) {
      synchronized (EventTransformationServiceGrpc.class) {
        if ((getCompactMethod = EventTransformationServiceGrpc.getCompactMethod) == null) {
          EventTransformationServiceGrpc.getCompactMethod = getCompactMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.CompactionRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventTransformationService", "Compact"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.CompactionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new EventTransformationServiceMethodDescriptorSupplier("Compact"))
                  .build();
          }
        }
     }
     return getCompactMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static EventTransformationServiceStub newStub(io.grpc.Channel channel) {
    return new EventTransformationServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static EventTransformationServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new EventTransformationServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static EventTransformationServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new EventTransformationServiceFutureStub(channel);
  }

  /**
   * <pre>
   * Service to transform events in an event store 
   * </pre>
   */
  public static abstract class EventTransformationServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Returns the list of all transformations.
     * </pre>
     */
    public void transformations(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.Transformation> responseObserver) {
      asyncUnimplementedUnaryCall(getTransformationsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Starts a new transformation.
     * </pre>
     */
    public void startTransformation(io.axoniq.axonserver.grpc.event.StartTransformationRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformationId> responseObserver) {
      asyncUnimplementedUnaryCall(getStartTransformationMethod(), responseObserver);
    }

    /**
     * <pre>
     * Adds requests to transform an event to a transformation.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformRequest> transformEvents(
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformRequestAck> responseObserver) {
      return asyncUnimplementedStreamingCall(getTransformEventsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Cancels a transformation before it is applied.
     * </pre>
     */
    public void cancelTransformation(io.axoniq.axonserver.grpc.event.TransformationId request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getCancelTransformationMethod(), responseObserver);
    }

    /**
     * <pre>
     * Applies the changes from a transformation in the event store.
     * </pre>
     */
    public void applyTransformation(io.axoniq.axonserver.grpc.event.ApplyTransformationRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getApplyTransformationMethod(), responseObserver);
    }

    /**
     * <pre>
     * Deletes old versions of events updated by a transformation.
     * </pre>
     */
    public void compact(io.axoniq.axonserver.grpc.event.CompactionRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getCompactMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getTransformationsMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                com.google.protobuf.Empty,
                io.axoniq.axonserver.grpc.event.Transformation>(
                  this, METHODID_TRANSFORMATIONS)))
          .addMethod(
            getStartTransformationMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.StartTransformationRequest,
                io.axoniq.axonserver.grpc.event.TransformationId>(
                  this, METHODID_START_TRANSFORMATION)))
          .addMethod(
            getTransformEventsMethod(),
            asyncBidiStreamingCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.TransformRequest,
                io.axoniq.axonserver.grpc.event.TransformRequestAck>(
                  this, METHODID_TRANSFORM_EVENTS)))
          .addMethod(
            getCancelTransformationMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.TransformationId,
                com.google.protobuf.Empty>(
                  this, METHODID_CANCEL_TRANSFORMATION)))
          .addMethod(
            getApplyTransformationMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.ApplyTransformationRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_APPLY_TRANSFORMATION)))
          .addMethod(
            getCompactMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.CompactionRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_COMPACT)))
          .build();
    }
  }

  /**
   * <pre>
   * Service to transform events in an event store 
   * </pre>
   */
  public static final class EventTransformationServiceStub extends io.grpc.stub.AbstractStub<EventTransformationServiceStub> {
    private EventTransformationServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventTransformationServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventTransformationServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventTransformationServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the list of all transformations.
     * </pre>
     */
    public void transformations(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.Transformation> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getTransformationsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Starts a new transformation.
     * </pre>
     */
    public void startTransformation(io.axoniq.axonserver.grpc.event.StartTransformationRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformationId> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getStartTransformationMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Adds requests to transform an event to a transformation.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformRequest> transformEvents(
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformRequestAck> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(getTransformEventsMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Cancels a transformation before it is applied.
     * </pre>
     */
    public void cancelTransformation(io.axoniq.axonserver.grpc.event.TransformationId request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getCancelTransformationMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Applies the changes from a transformation in the event store.
     * </pre>
     */
    public void applyTransformation(io.axoniq.axonserver.grpc.event.ApplyTransformationRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getApplyTransformationMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Deletes old versions of events updated by a transformation.
     * </pre>
     */
    public void compact(io.axoniq.axonserver.grpc.event.CompactionRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getCompactMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Service to transform events in an event store 
   * </pre>
   */
  public static final class EventTransformationServiceBlockingStub extends io.grpc.stub.AbstractStub<EventTransformationServiceBlockingStub> {
    private EventTransformationServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventTransformationServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventTransformationServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventTransformationServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Returns the list of all transformations.
     * </pre>
     */
    public java.util.Iterator<io.axoniq.axonserver.grpc.event.Transformation> transformations(
        com.google.protobuf.Empty request) {
      return blockingServerStreamingCall(
          getChannel(), getTransformationsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Starts a new transformation.
     * </pre>
     */
    public io.axoniq.axonserver.grpc.event.TransformationId startTransformation(io.axoniq.axonserver.grpc.event.StartTransformationRequest request) {
      return blockingUnaryCall(
          getChannel(), getStartTransformationMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Cancels a transformation before it is applied.
     * </pre>
     */
    public java.util.Iterator<com.google.protobuf.Empty> cancelTransformation(
        io.axoniq.axonserver.grpc.event.TransformationId request) {
      return blockingServerStreamingCall(
          getChannel(), getCancelTransformationMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Applies the changes from a transformation in the event store.
     * </pre>
     */
    public java.util.Iterator<com.google.protobuf.Empty> applyTransformation(
        io.axoniq.axonserver.grpc.event.ApplyTransformationRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getApplyTransformationMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Deletes old versions of events updated by a transformation.
     * </pre>
     */
    public java.util.Iterator<com.google.protobuf.Empty> compact(
        io.axoniq.axonserver.grpc.event.CompactionRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getCompactMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Service to transform events in an event store 
   * </pre>
   */
  public static final class EventTransformationServiceFutureStub extends io.grpc.stub.AbstractStub<EventTransformationServiceFutureStub> {
    private EventTransformationServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventTransformationServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventTransformationServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventTransformationServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Starts a new transformation.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.event.TransformationId> startTransformation(
        io.axoniq.axonserver.grpc.event.StartTransformationRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getStartTransformationMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_TRANSFORMATIONS = 0;
  private static final int METHODID_START_TRANSFORMATION = 1;
  private static final int METHODID_CANCEL_TRANSFORMATION = 2;
  private static final int METHODID_APPLY_TRANSFORMATION = 3;
  private static final int METHODID_COMPACT = 4;
  private static final int METHODID_TRANSFORM_EVENTS = 5;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final EventTransformationServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(EventTransformationServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_TRANSFORMATIONS:
          serviceImpl.transformations((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.Transformation>) responseObserver);
          break;
        case METHODID_START_TRANSFORMATION:
          serviceImpl.startTransformation((io.axoniq.axonserver.grpc.event.StartTransformationRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformationId>) responseObserver);
          break;
        case METHODID_CANCEL_TRANSFORMATION:
          serviceImpl.cancelTransformation((io.axoniq.axonserver.grpc.event.TransformationId) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_APPLY_TRANSFORMATION:
          serviceImpl.applyTransformation((io.axoniq.axonserver.grpc.event.ApplyTransformationRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_COMPACT:
          serviceImpl.compact((io.axoniq.axonserver.grpc.event.CompactionRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_TRANSFORM_EVENTS:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.transformEvents(
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.TransformRequestAck>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class EventTransformationServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    EventTransformationServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.axoniq.axonserver.grpc.event.EventOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("EventTransformationService");
    }
  }

  private static final class EventTransformationServiceFileDescriptorSupplier
      extends EventTransformationServiceBaseDescriptorSupplier {
    EventTransformationServiceFileDescriptorSupplier() {}
  }

  private static final class EventTransformationServiceMethodDescriptorSupplier
      extends EventTransformationServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    EventTransformationServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (EventTransformationServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new EventTransformationServiceFileDescriptorSupplier())
              .addMethod(getTransformationsMethod())
              .addMethod(getStartTransformationMethod())
              .addMethod(getTransformEventsMethod())
              .addMethod(getCancelTransformationMethod())
              .addMethod(getApplyTransformationMethod())
              .addMethod(getCompactMethod())
              .build();
        }
      }
    }
    return result;
  }
}
