/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.ErrorCategory;
import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.connector.impl.CloseableBuffer;
import io.axoniq.axonserver.grpc.ErrorMessage;

public class BufferingReplyChannel<T>
implements ReplyChannel<T> {
    private final ReplyChannel<T> delegate;
    private final CloseableBuffer<T> buffer;

    public BufferingReplyChannel(ReplyChannel<T> delegate, CloseableBuffer<T> buffer) {
        this.delegate = delegate;
        this.buffer = buffer;
    }

    @Override
    public void send(T outboundMessage) {
        this.buffer.put(outboundMessage);
    }

    @Override
    public void sendAck() {
        this.delegate.sendAck();
    }

    @Override
    public void sendNack(ErrorMessage errorMessage) {
        this.delegate.sendNack(errorMessage);
    }

    @Override
    public void complete() {
        this.buffer.close();
    }

    @Override
    public void completeWithError(ErrorMessage errorMessage) {
        this.buffer.closeExceptionally(errorMessage);
    }

    @Override
    public void completeWithError(ErrorCategory errorCategory, String message) {
        ErrorMessage error = ErrorMessage.newBuilder().setErrorCode(errorCategory.errorCode()).setMessage(message).build();
        this.buffer.closeExceptionally(error);
    }
}

