/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.grpc.stub.ClientCallStreamObserver;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedRequestStream<T>
extends ClientCallStreamObserver<T> {
    private final ClientCallStreamObserver<T> delegate;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean halfClosed = new AtomicBoolean(false);

    public SynchronizedRequestStream(ClientCallStreamObserver<T> requestStream) {
        this.delegate = requestStream;
    }

    public void cancel(String message, Throwable cause) {
        this.halfClosed.set(true);
        this.delegate.cancel(message, cause);
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        this.delegate.setOnReadyHandler(onReadyHandler);
    }

    public void disableAutoInboundFlowControl() {
        this.delegate.disableAutoInboundFlowControl();
    }

    public void request(int count) {
        this.delegate.request(count);
    }

    public void setMessageCompression(boolean enable) {
        this.delegate.setMessageCompression(enable);
    }

    public void onNext(T value) {
        this.inLock(() -> this.delegate.onNext(value));
    }

    public void disableAutoRequestWithInitial(int request) {
        this.delegate.disableAutoRequestWithInitial(request);
    }

    public void onError(Throwable t) {
        this.inLock(() -> {
            this.delegate.onError(t);
            this.halfClosed.set(true);
        });
    }

    public void onCompleted() {
        this.inLock(() -> {
            this.delegate.onCompleted();
            this.halfClosed.set(true);
        });
    }

    private void inLock(Runnable action) {
        try {
            this.lock.lock();
            if (!this.halfClosed.get()) {
                action.run();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

