/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.AxonServerException;
import io.axoniq.axonserver.connector.ErrorCategory;
import io.axoniq.axonserver.connector.InstructionHandler;
import io.axoniq.axonserver.connector.Registration;
import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.connector.control.ControlChannel;
import io.axoniq.axonserver.connector.control.ProcessorInstructionHandler;
import io.axoniq.axonserver.connector.impl.AbstractAxonServerChannel;
import io.axoniq.axonserver.connector.impl.AbstractIncomingInstructionStream;
import io.axoniq.axonserver.connector.impl.AxonServerManagedChannel;
import io.axoniq.axonserver.connector.impl.HeartbeatMonitor;
import io.axoniq.axonserver.connector.impl.ObjectUtils;
import io.axoniq.axonserver.connector.impl.ProcessorInstructions;
import io.axoniq.axonserver.connector.impl.SyncRegistration;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.axoniq.axonserver.grpc.control.EventProcessorInfo;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformServiceGrpc;
import io.grpc.Channel;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlChannelImpl
extends AbstractAxonServerChannel
implements ControlChannel {
    private static final Logger logger = LoggerFactory.getLogger(ControlChannelImpl.class);
    private final ClientIdentification clientIdentification;
    private final ScheduledExecutorService executor;
    private final long processorInfoUpdateFrequency;
    private final Runnable reconnectHandler;
    private final AtomicReference<CallStreamObserver<PlatformInboundInstruction>> instructionDispatcher = new AtomicReference();
    private final Map<PlatformOutboundInstruction.RequestCase, InstructionHandler<PlatformOutboundInstruction, PlatformInboundInstruction>> instructionHandlers = new EnumMap<PlatformOutboundInstruction.RequestCase, InstructionHandler<PlatformOutboundInstruction, PlatformInboundInstruction>>(PlatformOutboundInstruction.RequestCase.class);
    private final HeartbeatMonitor heartbeatMonitor;
    private final Map<String, CompletableFuture<InstructionAck>> awaitingAck = new ConcurrentHashMap<String, CompletableFuture<InstructionAck>>();
    private final String context;
    private final Map<String, ProcessorInstructionHandler> processorInstructionHandlers = new ConcurrentHashMap<String, ProcessorInstructionHandler>();
    private final Map<String, Supplier<EventProcessorInfo>> processorInfoSuppliers = new ConcurrentHashMap<String, Supplier<EventProcessorInfo>>();
    private final AtomicBoolean infoSupplierActive = new AtomicBoolean();
    private final PlatformServiceGrpc.PlatformServiceStub platformServiceStub;

    public ControlChannelImpl(ClientIdentification clientIdentification, String context, ScheduledExecutorService executor, AxonServerManagedChannel channel, long processorInfoUpdateFrequency, Runnable reconnectHandler) {
        super(executor, channel);
        this.clientIdentification = clientIdentification;
        this.context = context;
        this.executor = executor;
        this.processorInfoUpdateFrequency = processorInfoUpdateFrequency;
        this.reconnectHandler = reconnectHandler;
        this.heartbeatMonitor = new HeartbeatMonitor(executor, this::sendHeartBeat, channel::forceReconnect);
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.ACK, i -> new AckHandler());
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.HEARTBEAT, i -> (msg, reply) -> this.heartbeatMonitor.handleIncomingBeat(reply));
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.MERGE_EVENT_PROCESSOR_SEGMENT, i -> ProcessorInstructions.mergeHandler(this.processorInstructionHandlers));
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.SPLIT_EVENT_PROCESSOR_SEGMENT, i -> ProcessorInstructions.splitHandler(this.processorInstructionHandlers));
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.START_EVENT_PROCESSOR, i -> ProcessorInstructions.startHandler(this.processorInstructionHandlers));
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.PAUSE_EVENT_PROCESSOR, i -> ProcessorInstructions.pauseHandler(this.processorInstructionHandlers));
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.RELEASE_SEGMENT, i -> ProcessorInstructions.releaseSegmentHandler(this.processorInstructionHandlers));
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.REQUEST_EVENT_PROCESSOR_INFO, i -> ProcessorInstructions.requestInfoHandler(this.processorInfoSuppliers));
        this.instructionHandlers.computeIfAbsent(PlatformOutboundInstruction.RequestCase.REQUEST_RECONNECT, i -> this::handleReconnectRequest);
        this.platformServiceStub = PlatformServiceGrpc.newStub((Channel)channel);
    }

    private CompletableFuture<InstructionAck> sendHeartBeat() {
        if (!this.isConnected()) {
            return CompletableFuture.completedFuture(null);
        }
        PlatformInboundInstruction heartbeatMessage = PlatformInboundInstruction.newBuilder().setInstructionId(UUID.randomUUID().toString()).setHeartbeat(Heartbeat.getDefaultInstance()).build();
        return this.sendInstruction(heartbeatMessage);
    }

    void handleReconnectRequest(PlatformOutboundInstruction platformOutboundInstruction, ReplyChannel<PlatformInboundInstruction> replyChannel) {
        logger.info("AxonServer requested reconnect for context '{}'", (Object)this.context);
        replyChannel.sendAck();
        this.reconnectHandler.run();
    }

    @Override
    public synchronized void connect() {
        StreamObserver existing = (StreamObserver)this.instructionDispatcher.get();
        if (existing != null) {
            logger.info("ControlChannel for context '{}' is already connected", (Object)this.context);
        } else {
            PlatformOutboundInstructionHandler responseObserver = new PlatformOutboundInstructionHandler(this.clientIdentification.getClientId(), this::handleDisconnect, this::registerOutboundStream);
            logger.debug("Opening instruction stream for context '{}'", (Object)this.context);
            this.platformServiceStub.openStream((StreamObserver<PlatformOutboundInstruction>)responseObserver);
            ClientCallStreamObserver instructionsForPlatform = responseObserver.getInstructionsForPlatform();
            try {
                logger.info("Connected instruction stream for context '{}'. Sending client identification", (Object)this.context);
                instructionsForPlatform.onNext((Object)PlatformInboundInstruction.newBuilder().setRegister(this.clientIdentification).build());
                this.heartbeatMonitor.resume();
            }
            catch (Exception e) {
                this.instructionDispatcher.set(null);
                instructionsForPlatform.onError((Throwable)e);
            }
        }
    }

    private void registerOutboundStream(CallStreamObserver<PlatformInboundInstruction> upstream) {
        StreamObserver previous = (StreamObserver)this.instructionDispatcher.getAndSet(upstream);
        ObjectUtils.silently(previous, StreamObserver::onCompleted);
    }

    @Override
    public void reconnect() {
        ObjectUtils.doIfNotNull(this.instructionDispatcher.getAndSet(null), StreamObserver::onCompleted);
        this.scheduleImmediateReconnect();
    }

    private void handleDisconnect(Throwable cause) {
        this.failOpenInstructions(cause);
        this.scheduleReconnect();
    }

    private void failOpenInstructions(Throwable cause) {
        while (!this.awaitingAck.isEmpty()) {
            this.awaitingAck.keySet().forEach(k -> ObjectUtils.doIfNotNull(this.awaitingAck.remove(k), cf -> cf.completeExceptionally(cause)));
        }
    }

    @Override
    public void disconnect() {
        this.heartbeatMonitor.disableHeartbeat();
        StreamObserver dispatcher = this.instructionDispatcher.getAndSet(null);
        if (dispatcher != null) {
            dispatcher.onCompleted();
        }
    }

    @Override
    public Registration registerInstructionHandler(PlatformOutboundInstruction.RequestCase type, InstructionHandler<PlatformOutboundInstruction, PlatformInboundInstruction> handler) {
        this.instructionHandlers.put(type, handler);
        return new SyncRegistration(() -> this.instructionHandlers.remove((Object)type, handler));
    }

    @Override
    public Registration registerEventProcessor(String processorName, Supplier<EventProcessorInfo> infoSupplier, ProcessorInstructionHandler instructionHandler) {
        this.processorInstructionHandlers.put(processorName, instructionHandler);
        this.processorInfoSuppliers.put(processorName, infoSupplier);
        if (this.infoSupplierActive.compareAndSet(false, true)) {
            this.sendScheduledProcessorInfo();
        }
        return new SyncRegistration(() -> {
            this.processorInstructionHandlers.remove(processorName, instructionHandler);
            this.processorInfoSuppliers.remove(processorName, infoSupplier);
        });
    }

    private void sendScheduledProcessorInfo() {
        Collection<Supplier<EventProcessorInfo>> infoSupplies = this.processorInfoSuppliers.values();
        if (infoSupplies.isEmpty()) {
            this.infoSupplierActive.set(false);
            if (!this.processorInfoSuppliers.isEmpty() && this.infoSupplierActive.compareAndSet(false, true)) {
                this.sendScheduledProcessorInfo();
            }
        } else {
            CallStreamObserver<PlatformInboundInstruction> outbound = this.instructionDispatcher.get();
            if (outbound != null && outbound.isReady()) {
                infoSupplies.forEach(info -> ObjectUtils.doIfNotNull(info.get(), this::sendProcessorInfo));
            } else {
                logger.debug("Not sending processor info for context '{}'. Channel not ready...", (Object)this.context);
            }
            this.executor.schedule(this::sendScheduledProcessorInfo, this.processorInfoUpdateFrequency, TimeUnit.MILLISECONDS);
        }
    }

    private CompletableFuture<InstructionAck> sendProcessorInfo(EventProcessorInfo processorInfo) {
        return this.sendInstruction(PlatformInboundInstruction.newBuilder().setEventProcessorInfo(processorInfo).build());
    }

    @Override
    public void enableHeartbeat(long interval, long timeout, TimeUnit timeUnit) {
        this.heartbeatMonitor.enableHeartbeat(interval, timeout, timeUnit);
    }

    @Override
    public void disableHeartbeat() {
        this.heartbeatMonitor.disableHeartbeat();
    }

    @Override
    public CompletableFuture<InstructionAck> sendInstruction(PlatformInboundInstruction instruction) {
        CompletableFuture<InstructionAck> result = new CompletableFuture<InstructionAck>();
        String instructionId = instruction.getInstructionId();
        StreamObserver dispatcher = (StreamObserver)this.instructionDispatcher.get();
        if (dispatcher == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to send instruction: {} {}. Disconnected.", (Object)instruction.getRequestCase().name(), (Object)instructionId);
            }
            result.completeExceptionally(new AxonServerException(ErrorCategory.INSTRUCTION_EXECUTION_ERROR, "Unable to send instruction", this.clientIdentification.getClientId()));
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending instruction: {} {}", (Object)instruction.getRequestCase().name(), (Object)instructionId);
            }
            if (ObjectUtils.hasLength(instructionId)) {
                this.awaitingAck.put(instructionId, result);
            }
            try {
                dispatcher.onNext((Object)instruction);
                if (!ObjectUtils.hasLength(instructionId)) {
                    result.complete(InstructionAck.newBuilder().setSuccess(true).build());
                }
            }
            catch (Exception e) {
                this.awaitingAck.remove(instructionId);
                result.completeExceptionally(e);
                ObjectUtils.silently(dispatcher, d -> d.onError((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public boolean isConnected() {
        return this.instructionDispatcher.get() != null;
    }

    private class AckHandler
    implements InstructionHandler<PlatformOutboundInstruction, PlatformInboundInstruction> {
        private AckHandler() {
        }

        @Override
        public void handle(PlatformOutboundInstruction ackMessage, ReplyChannel<PlatformInboundInstruction> replyChannel) {
            String instructionId = ackMessage.getAck().getInstructionId();
            logger.debug("Received ACK for {}", (Object)instructionId);
            CompletableFuture handle = (CompletableFuture)ControlChannelImpl.this.awaitingAck.remove(instructionId);
            if (handle != null) {
                handle.complete(ackMessage.getAck());
            }
        }
    }

    private class PlatformOutboundInstructionHandler
    extends AbstractIncomingInstructionStream<PlatformOutboundInstruction, PlatformInboundInstruction> {
        public PlatformOutboundInstructionHandler(String clientId, Consumer<Throwable> disconnectHandler, Consumer<CallStreamObserver<PlatformInboundInstruction>> beforeStartHandler) {
            super(clientId, 0, 0, disconnectHandler, beforeStartHandler);
        }

        @Override
        protected PlatformInboundInstruction buildAckMessage(InstructionAck ack) {
            return PlatformInboundInstruction.newBuilder().setAck(ack).build();
        }

        @Override
        protected String getInstructionId(PlatformOutboundInstruction instruction) {
            return instruction.getInstructionId();
        }

        @Override
        protected InstructionHandler<PlatformOutboundInstruction, PlatformInboundInstruction> getHandler(PlatformOutboundInstruction platformOutboundInstruction) {
            return (InstructionHandler)ControlChannelImpl.this.instructionHandlers.get((Object)platformOutboundInstruction.getRequestCase());
        }

        @Override
        protected boolean unregisterOutboundStream(CallStreamObserver<PlatformInboundInstruction> expected) {
            ControlChannelImpl.this.heartbeatMonitor.pause();
            boolean disconnected = ControlChannelImpl.this.instructionDispatcher.compareAndSet(expected, null);
            if (disconnected) {
                ControlChannelImpl.this.failOpenInstructions(new AxonServerException(ErrorCategory.INSTRUCTION_ACK_ERROR, "Disconnected from AxonServer before receiving instruction ACK", this.clientId()));
            }
            return disconnected;
        }

        @Override
        protected PlatformInboundInstruction buildFlowControlMessage(FlowControl flowControl) {
            return null;
        }
    }
}

