/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.ErrorCategory;
import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.grpc.ErrorMessage;
import java.util.concurrent.atomic.AtomicBoolean;

public class CloseAwareReplyChannel<T>
implements ReplyChannel<T> {
    private final ReplyChannel<T> delegate;
    private final Runnable onClose;
    private final AtomicBoolean closed = new AtomicBoolean();

    public CloseAwareReplyChannel(ReplyChannel<T> delegate) {
        this(delegate, () -> {});
    }

    public CloseAwareReplyChannel(ReplyChannel<T> delegate, Runnable onClose) {
        this.delegate = delegate;
        this.onClose = () -> {
            this.closed.set(true);
            onClose.run();
        };
    }

    @Override
    public void send(T outboundMessage) {
        this.delegate.send(outboundMessage);
    }

    @Override
    public void sendLast(T outboundMessage) {
        this.delegate.sendLast(outboundMessage);
        this.onClose.run();
    }

    @Override
    public void sendAck() {
        this.delegate.sendAck();
    }

    @Override
    public void sendNack() {
        this.delegate.sendNack();
    }

    @Override
    public void sendNack(ErrorMessage errorMessage) {
        this.delegate.sendNack(errorMessage);
    }

    @Override
    public void complete() {
        this.delegate.complete();
        this.onClose.run();
    }

    @Override
    public void completeWithError(ErrorMessage errorMessage) {
        this.delegate.completeWithError(errorMessage);
        this.onClose.run();
    }

    @Override
    public void completeWithError(ErrorCategory errorCategory, String message) {
        this.delegate.completeWithError(errorCategory, message);
        this.onClose.run();
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

