/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.plugin;

import io.axoniq.axonserver.plugin.AttributeType;
import io.axoniq.axonserver.plugin.Cardinality;
import java.util.List;

public class PluginPropertyDefinition {
    private final String id;
    private final String name;
    private final Cardinality cardinality;
    private final Object defaultValue;
    private final AttributeType type;
    private final String description;
    private final List<String> optionLabels;
    private final List<String> optionValues;

    private PluginPropertyDefinition(String id, String name, Cardinality cardinality, Object defaultValue, AttributeType type, String description, List<String> optionLabels, List<String> optionValues) {
        this.id = id;
        this.name = name;
        this.cardinality = cardinality;
        this.defaultValue = defaultValue;
        this.type = type;
        this.description = description;
        this.optionLabels = optionLabels;
        this.optionValues = optionValues;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Cardinality cardinality() {
        return this.cardinality;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public AttributeType type() {
        return this.type;
    }

    public List<String> optionLabels() {
        return this.optionLabels;
    }

    public List<String> optionValues() {
        return this.optionValues;
    }

    public String description() {
        return this.description;
    }

    public static Builder newBuilder(String id, String name) {
        return new Builder(id, name);
    }

    public static class Builder {
        private final String id;
        private final String name;
        private Cardinality cardinality = Cardinality.SINGLE;
        private String description;
        private AttributeType type = AttributeType.STRING;
        private Object defaultValue;
        private List<String> optionLabels;
        private List<String> optionValues;

        private Builder(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder options(List<String> optionLabels, List<String> optionValues) {
            assert (optionLabels.size() == optionValues.size());
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
            return this;
        }

        public Builder type(AttributeType type) {
            this.type = type;
            return this;
        }

        public Builder cardinality(Cardinality cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public PluginPropertyDefinition build() {
            return new PluginPropertyDefinition(this.id, this.name, this.cardinality, this.defaultValue, this.type, this.description, this.optionLabels, this.optionValues);
        }
    }
}

