/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.api;

import io.axoniq.console.framework.api.ConsoleClientIdentifier;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0005J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/axoniq/console/framework/api/ConsoleClientAuthentication;", "", "identification", "Lio/axoniq/console/framework/api/ConsoleClientIdentifier;", "accessToken", "", "(Lio/axoniq/console/framework/api/ConsoleClientIdentifier;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getIdentification", "()Lio/axoniq/console/framework/api/ConsoleClientIdentifier;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toBearerToken", "toString", "Companion", "console-framework-client-api"})
public final class ConsoleClientAuthentication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConsoleClientIdentifier identification;
    @NotNull
    private final String accessToken;
    @NotNull
    private static final String BEARER_PREFIX = "Bearer ";
    @NotNull
    private static final String TOKEN_ERROR = "Not a valid Bearer token!";

    public ConsoleClientAuthentication(@NotNull ConsoleClientIdentifier identification, @NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)identification, (String)"identification");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        this.identification = identification;
        this.accessToken = accessToken;
    }

    @NotNull
    public final ConsoleClientIdentifier getIdentification() {
        return this.identification;
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    @NotNull
    public final String toBearerToken() {
        Object[] objectArray = new String[]{this.identification.getEnvironmentId(), Companion.encode(this.identification.getApplicationName()), Companion.encode(this.identification.getNodeName()), this.accessToken};
        return BEARER_PREFIX + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final ConsoleClientIdentifier component1() {
        return this.identification;
    }

    @NotNull
    public final String component2() {
        return this.accessToken;
    }

    @NotNull
    public final ConsoleClientAuthentication copy(@NotNull ConsoleClientIdentifier identification, @NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)identification, (String)"identification");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        return new ConsoleClientAuthentication(identification, accessToken);
    }

    public static /* synthetic */ ConsoleClientAuthentication copy$default(ConsoleClientAuthentication consoleClientAuthentication, ConsoleClientIdentifier consoleClientIdentifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            consoleClientIdentifier = consoleClientAuthentication.identification;
        }
        if ((n & 2) != 0) {
            string = consoleClientAuthentication.accessToken;
        }
        return consoleClientAuthentication.copy(consoleClientIdentifier, string);
    }

    @NotNull
    public String toString() {
        return "ConsoleClientAuthentication(identification=" + this.identification + ", accessToken=" + this.accessToken + ')';
    }

    public int hashCode() {
        int result = this.identification.hashCode();
        result = result * 31 + this.accessToken.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConsoleClientAuthentication)) {
            return false;
        }
        ConsoleClientAuthentication consoleClientAuthentication = (ConsoleClientAuthentication)other;
        if (!Intrinsics.areEqual((Object)this.identification, (Object)consoleClientAuthentication.identification)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.accessToken, (Object)consoleClientAuthentication.accessToken);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\f\u0010\t\u001a\u00020\u0004*\u00020\u0004H\u0002J\n\u0010\n\u001a\u00020\u0004*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/axoniq/console/framework/api/ConsoleClientAuthentication$Companion;", "", "()V", "BEARER_PREFIX", "", "TOKEN_ERROR", "fromToken", "Lio/axoniq/console/framework/api/ConsoleClientAuthentication;", "token", "decode", "encode", "console-framework-client-api"})
    @SourceDebugExtension(value={"SMAP\nclientIdentification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 clientIdentification.kt\nio/axoniq/console/framework/api/ConsoleClientAuthentication$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConsoleClientAuthentication fromToken(@NotNull String token) {
            boolean environmentId2;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            boolean bl = StringsKt.startsWith$default((String)token, (String)ConsoleClientAuthentication.BEARER_PREFIX, (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$32 = false;
                String $i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$32 = ConsoleClientAuthentication.TOKEN_ERROR;
                throw new AssertionError((Object)$i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$32);
            }
            String[] $i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$32 = new String[]{":"};
            List tokenParts = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)token, (CharSequence)ConsoleClientAuthentication.BEARER_PREFIX), (String[])$i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$32, (boolean)false, (int)0, (int)6, null);
            if (tokenParts.size() == 5) {
                String environmentId2 = (String)tokenParts.get(1);
                String applicationName = (String)tokenParts.get(2);
                String nodeName = (String)tokenParts.get(3);
                String accessToken = (String)tokenParts.get(4);
                return new ConsoleClientAuthentication(new ConsoleClientIdentifier(environmentId2, this.decode(applicationName), this.decode(nodeName)), accessToken);
            }
            boolean bl2 = environmentId2 = tokenParts.size() == 4;
            if (_Assertions.ENABLED && !environmentId2) {
                boolean $i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$42 = false;
                String $i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$42 = ConsoleClientAuthentication.TOKEN_ERROR;
                throw new AssertionError((Object)$i$a$-assert-ConsoleClientAuthentication$Companion$fromToken$42);
            }
            String environmentId2 = (String)tokenParts.get(0);
            String applicationName = (String)tokenParts.get(1);
            String nodeName = (String)tokenParts.get(2);
            String accessToken = (String)tokenParts.get(3);
            return new ConsoleClientAuthentication(new ConsoleClientIdentifier(environmentId2, this.decode(applicationName), this.decode(nodeName)), accessToken);
        }

        @NotNull
        public final String encode(@NotNull String $this$encode) {
            Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
            String string = URLEncoder.encode($this$encode, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            return string;
        }

        private final String decode(String $this$decode) {
            String string = URLDecoder.decode($this$decode, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

