/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.starter;

import io.axoniq.console.framework.AxoniqConsoleConfigurerModule;
import io.axoniq.console.framework.messaging.AxoniqConsoleWrappedEventScheduler;
import io.axoniq.console.framework.messaging.SpanMatcher;
import io.axoniq.console.framework.messaging.SpanMatcherPredicateMap;
import io.axoniq.console.framework.starter.AxoniqConsoleSpringProperties;
import io.axoniq.console.framework.util.PostProcessHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@Configuration
@EnableConfigurationProperties(value={AxoniqConsoleSpringProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0012J\b\u0010\u000e\u001a\u00020\u000fH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/axoniq/console/framework/starter/AxoniqConsoleAutoConfiguration;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "axoniqConsoleConfigurerModule", "Lorg/axonframework/config/ConfigurerModule;", "properties", "Lio/axoniq/console/framework/starter/AxoniqConsoleSpringProperties;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "axoniqConsoleSpanFactoryPostProcessor", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "spanMatcherPredicateMap", "Lio/axoniq/console/framework/messaging/SpanMatcherPredicateMap;", "enhanceEventScheduler", "Lorg/axonframework/eventhandling/scheduling/EventScheduler;", "eventScheduler", "getApplicationName", "", "console-framework-client-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nAxoniqConsoleAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxoniqConsoleAutoConfiguration.kt\nio/axoniq/console/framework/starter/AxoniqConsoleAutoConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1849#2,2:126\n1#3:128\n*S KotlinDebug\n*F\n+ 1 AxoniqConsoleAutoConfiguration.kt\nio/axoniq/console/framework/starter/AxoniqConsoleAutoConfiguration\n*L\n77#1:126,2\n*E\n"})
public class AxoniqConsoleAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @ConditionalOnProperty(value={"axoniq.console.credentials"}, matchIfMissing=false)
    @NotNull
    public ConfigurerModule axoniqConsoleConfigurerModule(@NotNull AxoniqConsoleSpringProperties properties, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        String credentials = properties.getCredentials();
        if (credentials == null) {
            this.logger.warn("No credentials were provided for the connection to AxonIQ Console. Please provide them as instructed through the 'axoniq.console.credentials' property.");
            return AxoniqConsoleAutoConfiguration::axoniqConsoleConfigurerModule$lambda$0;
        }
        if (!StringsKt.contains$default((CharSequence)credentials, (CharSequence)":", (boolean)false, (int)2, null)) {
            this.logger.warn("The credentials for the connection to AxonIQ Console don't have the right format. Please provide them as instructed through the 'axoniq.console.credentials' property.");
            return AxoniqConsoleAutoConfiguration::axoniqConsoleConfigurerModule$lambda$1;
        }
        String applicationName = this.getApplicationName(properties, applicationContext);
        if (applicationName == null) {
            this.logger.warn("Was unable to determine your application's name. Please provide it through the 'axoniq.console.application-name' property.");
            return AxoniqConsoleAutoConfiguration::axoniqConsoleConfigurerModule$lambda$2;
        }
        String[] stringArray = new String[]{":"};
        List list = StringsKt.split$default((CharSequence)credentials, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String environmentId = (String)list.get(0);
        String accessToken = (String)list.get(1);
        this.logger.info("Setting up client for AxonIQ Console environment {}. This application will be registered as {}", (Object)environmentId, (Object)applicationName);
        AxoniqConsoleConfigurerModule.Builder builder = AxoniqConsoleConfigurerModule.builder((String)environmentId, (String)accessToken, (String)applicationName).port(properties.getPort()).host(properties.getHost()).dlqMode(properties.getDlqMode()).secure(properties.isSecure()).initialDelay(properties.getInitialDelay()).disableSpanFactoryInConfiguration().managementMaxThreadPoolSize(Integer.valueOf(properties.getMaxConcurrentManagementTasks()));
        List<String> list2 = properties.getDlqDiagnosticsWhitelist();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDlqDiagnosticsWhitelist(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.addDlqDiagnosticsWhitelistKey(it);
        }
        AxoniqConsoleConfigurerModule axoniqConsoleConfigurerModule = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)axoniqConsoleConfigurerModule, (String)"build(...)");
        return (ConfigurerModule)axoniqConsoleConfigurerModule;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpanMatcherPredicateMap.class})
    @NotNull
    public SpanMatcherPredicateMap spanMatcherPredicateMap() {
        return SpanMatcher.Companion.getSpanMatcherPredicateMap();
    }

    @Bean
    @ConditionalOnProperty(value={"axoniq.console.credentials"}, matchIfMissing=false)
    @NotNull
    public BeanPostProcessor axoniqConsoleSpanFactoryPostProcessor(@NotNull SpanMatcherPredicateMap spanMatcherPredicateMap, @NotNull AxoniqConsoleSpringProperties properties, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)spanMatcherPredicateMap, (String)"spanMatcherPredicateMap");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return new BeanPostProcessor(this, properties, applicationContext, spanMatcherPredicateMap){
            final /* synthetic */ AxoniqConsoleAutoConfiguration this$0;
            final /* synthetic */ AxoniqConsoleSpringProperties $properties;
            final /* synthetic */ ApplicationContext $applicationContext;
            final /* synthetic */ SpanMatcherPredicateMap $spanMatcherPredicateMap;
            {
                this.this$0 = $receiver;
                this.$properties = $properties;
                this.$applicationContext = $applicationContext;
                this.$spanMatcherPredicateMap = $spanMatcherPredicateMap;
            }

            @NotNull
            public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
                Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
                Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
                return bean instanceof EventScheduler ? AxoniqConsoleAutoConfiguration.access$enhanceEventScheduler(this.this$0, (EventScheduler)bean, this.$properties, this.$applicationContext) : PostProcessHelper.Companion.enhance(bean, beanName, this.$spanMatcherPredicateMap);
            }
        };
    }

    private EventScheduler enhanceEventScheduler(EventScheduler eventScheduler, AxoniqConsoleSpringProperties properties, ApplicationContext applicationContext) {
        EventScheduler eventScheduler2;
        if (eventScheduler instanceof AxoniqConsoleWrappedEventScheduler) {
            eventScheduler2 = eventScheduler;
        } else {
            String string = this.getApplicationName(properties, applicationContext);
            if (string != null) {
                String it = string;
                boolean bl = false;
                eventScheduler2 = (EventScheduler)new AxoniqConsoleWrappedEventScheduler(eventScheduler, it);
            } else {
                eventScheduler2 = eventScheduler;
            }
        }
        return eventScheduler2;
    }

    private String getApplicationName(AxoniqConsoleSpringProperties properties, ApplicationContext applicationContext) {
        String string;
        block9: {
            CharSequence charSequence;
            block8: {
                CharSequence charSequence2;
                string = properties.getApplicationName();
                if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) break block8;
                CharSequence charSequence3 = string;
                if (charSequence3.length() == 0) {
                    boolean bl = false;
                    charSequence2 = null;
                } else {
                    charSequence2 = charSequence3;
                }
                if ((string = (String)charSequence2) != null) break block9;
            }
            String string2 = applicationContext.getApplicationName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getApplicationName(...)");
            CharSequence charSequence4 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (charSequence4.length() == 0) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence4;
            }
            if ((string = (String)charSequence) == null) {
                String string3 = applicationContext.getId();
                string = string3 != null ? StringsKt.removeSuffix((String)string3, (CharSequence)"-1") : null;
            }
        }
        return string;
    }

    private static final void axoniqConsoleConfigurerModule$lambda$0(Configurer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void axoniqConsoleConfigurerModule$lambda$1(Configurer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void axoniqConsoleConfigurerModule$lambda$2(Configurer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    public static final /* synthetic */ EventScheduler access$enhanceEventScheduler(AxoniqConsoleAutoConfiguration $this, EventScheduler eventScheduler, AxoniqConsoleSpringProperties properties, ApplicationContext applicationContext) {
        return $this.enhanceEventScheduler(eventScheduler, properties, applicationContext);
    }
}

