/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.eventprocessor;

import io.axoniq.console.framework.api.ResetDecision;
import io.axoniq.console.framework.api.ResetDecisions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.pooled.PooledStreamingEventProcessor;
import org.axonframework.messaging.StreamableMessageSource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0002J#\u0010\u001b\u001a\n \t*\u0004\u0018\u00010\r0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!J#\u0010\"\u001a\n \t*\u0004\u0018\u00010\r0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010#\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010$\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010&\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010'\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010(\u001a\u00020)*\u00020\u00012\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0014\u0010+\u001a\u00020,*\u00020\u00012\u0006\u0010*\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/axoniq/console/framework/eventprocessor/EventProcessorManager;", "", "eventProcessingConfig", "Lorg/axonframework/config/EventProcessingConfiguration;", "transactionManager", "Lorg/axonframework/common/transaction/TransactionManager;", "(Lorg/axonframework/config/EventProcessingConfiguration;Lorg/axonframework/common/transaction/TransactionManager;)V", "lastLogForOldVersion", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "claimSegment", "", "processorName", "", "segmentId", "", "eventProcessor", "Lorg/axonframework/eventhandling/StreamingEventProcessor;", "executeClaimMethodOrFallback", "", "processor", "executeFallback", "logIfTimeExpired", "block", "Lkotlin/Function0;", "mergeSegment", "(Ljava/lang/String;I)Ljava/lang/Boolean;", "releaseSegment", "removeReleaseDeadlineForTrackingProcoessor", "resetTokens", "resetDecision", "Lio/axoniq/console/framework/api/ResetDecision;", "splitSegment", "start", "stop", "triggerImmediateCoordinationTaskWithTokenClaim", "waitForProcessorToHaveClaimedSegment", "waitForProcessorToHaveUnclaimedSegment", "getField", "Ljava/lang/reflect/Field;", "name", "getMethod", "Ljava/lang/reflect/Method;", "console-framework-client"})
public final class EventProcessorManager {
    @NotNull
    private final EventProcessingConfiguration eventProcessingConfig;
    @NotNull
    private final TransactionManager transactionManager;
    private final Logger logger;
    private Instant lastLogForOldVersion;

    public EventProcessorManager(@NotNull EventProcessingConfiguration eventProcessingConfig, @NotNull TransactionManager transactionManager) {
        Intrinsics.checkNotNullParameter((Object)eventProcessingConfig, (String)"eventProcessingConfig");
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"transactionManager");
        this.eventProcessingConfig = eventProcessingConfig;
        this.transactionManager = transactionManager;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.lastLogForOldVersion = Instant.EPOCH;
    }

    public final void start(@NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        this.eventProcessor(processorName).start();
    }

    public final void stop(@NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        this.eventProcessor(processorName).shutDown();
    }

    public final void releaseSegment(@NotNull String processorName, int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        StreamingEventProcessor eventProcessor = this.eventProcessor(processorName);
        eventProcessor.releaseSegment(segmentId);
        this.waitForProcessorToHaveUnclaimedSegment(eventProcessor, segmentId);
    }

    public final Boolean splitSegment(@NotNull String processorName, int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return (Boolean)this.eventProcessor(processorName).splitSegment(segmentId).get(5L, TimeUnit.SECONDS);
    }

    public final Boolean mergeSegment(@NotNull String processorName, int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return (Boolean)this.eventProcessor(processorName).mergeSegment(segmentId).get(5L, TimeUnit.SECONDS);
    }

    public final void resetTokens(@NotNull ResetDecision resetDecision) {
        Intrinsics.checkNotNullParameter((Object)resetDecision, (String)"resetDecision");
        this.eventProcessor(resetDecision.getProcessorName()).resetTokens(arg_0 -> EventProcessorManager.resetTokens$lambda-0(resetDecision, arg_0));
    }

    public final boolean claimSegment(@NotNull String processorName, int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        StreamingEventProcessor processor = this.eventProcessor(processorName);
        this.transactionManager.executeInTransaction(() -> EventProcessorManager.claimSegment$lambda-1(this, processorName, segmentId));
        this.executeClaimMethodOrFallback(processor, segmentId);
        return this.waitForProcessorToHaveClaimedSegment(processor, segmentId);
    }

    private final boolean waitForProcessorToHaveClaimedSegment(StreamingEventProcessor processor, int segmentId) {
        int loop;
        for (loop = 0; loop < 300; ++loop) {
            Thread.sleep(100L);
            if (!processor.processingStatus().containsKey(segmentId)) continue;
            this.logger.info("Processor [" + processor.getName() + "] successfully claimed segment [" + segmentId + "] in approx. [" + loop * 100 + "ms].");
            return true;
        }
        this.logger.info("Processor [" + processor.getName() + "] failed to claim [" + segmentId + "] in approx. [" + loop * 100 + "ms].");
        return false;
    }

    private final boolean waitForProcessorToHaveUnclaimedSegment(StreamingEventProcessor processor, int segmentId) {
        int loop;
        for (loop = 0; loop < 300; ++loop) {
            Thread.sleep(100L);
            if (processor.processingStatus().containsKey(segmentId)) {
                Object v = processor.processingStatus().get(segmentId);
                Intrinsics.checkNotNull(v);
                if (!((EventTrackerStatus)v).isErrorState()) continue;
            }
            this.logger.info("Processor [" + processor.getName() + "] successfully unclaimed segment [" + segmentId + "] in approx. [" + loop * 100 + "ms].");
            return true;
        }
        this.logger.info("Processor [" + processor.getName() + "] failed to unclaim [" + segmentId + "] in approx. [" + loop * 100 + "ms].");
        return false;
    }

    private final void executeClaimMethodOrFallback(StreamingEventProcessor processor, int segmentId) {
        try {
            Method claimMethod = this.getMethod(processor, "claimSegment");
            ReflectionUtils.ensureAccessible((AccessibleObject)claimMethod);
            Object[] objectArray = new Object[]{segmentId};
            claimMethod.invoke((Object)processor, objectArray);
        }
        catch (Exception e) {
            this.executeFallback(processor, segmentId);
        }
    }

    private final void executeFallback(StreamingEventProcessor processor, int segmentId) {
        this.logIfTimeExpired((Function0<Unit>)((Function0)new Function0<Unit>(this, processor){
            final /* synthetic */ EventProcessorManager this$0;
            final /* synthetic */ StreamingEventProcessor $processor;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
                super(0);
            }

            public final void invoke() {
                EventProcessorManager.access$getLogger$p(this.this$0).info("You processor is being load-balanced and you are using Axon Framework 4.8.x or earlier. Using 4.9.x or later will improve the usability and performance greatly. Read the information in the AxonIQ Console UI.");
                if (this.$processor instanceof TrackingEventProcessor) {
                    EventProcessorManager.access$getLogger$p(this.this$0).info("Your TrackingEventProcessor " + ((TrackingEventProcessor)this.$processor).getName() + " is being load-balanced. This can cause interruptions due to the long waits. Read the information in the AxonIQ Console UI.");
                }
            }
        }));
        if (processor instanceof TrackingEventProcessor) {
            try {
                this.removeReleaseDeadlineForTrackingProcoessor(processor, segmentId);
            }
            catch (Exception e) {
                this.logger.warn("Was unable to remove release deadline for the TrackingEventProcessor", (Throwable)e);
            }
        } else if (processor instanceof PooledStreamingEventProcessor) {
            try {
                this.triggerImmediateCoordinationTaskWithTokenClaim(processor, segmentId);
            }
            catch (Exception e) {
                this.logger.warn("Was unable to trigger coordination task with immediate claim for the PooledStreamingEventProcessor", (Throwable)e);
            }
        }
    }

    private final void logIfTimeExpired(Function0<Unit> block) {
        if (Instant.now().isAfter(this.lastLogForOldVersion.plusSeconds(120L))) {
            block.invoke();
            this.lastLogForOldVersion = Instant.now();
        }
    }

    private final void triggerImmediateCoordinationTaskWithTokenClaim(StreamingEventProcessor processor, int segmentId) {
        Field coordinatorField = this.getField(processor, "coordinator");
        Object coordinator = ReflectionUtils.getFieldValue((Field)coordinatorField, (Object)processor);
        Intrinsics.checkNotNullExpressionValue((Object)coordinator, (String)"coordinator");
        Field coordinationTaskField = this.getField(coordinator, "coordinationTask");
        AtomicReference coordinationTaskAtomicReference = (AtomicReference)ReflectionUtils.getFieldValue((Field)coordinationTaskField, (Object)coordinator);
        Object coordinationTask = coordinationTaskAtomicReference.get();
        Intrinsics.checkNotNullExpressionValue(coordinationTask, (String)"coordinationTask");
        Field unclaimedSegmentValidationThresholdField = this.getField(coordinationTask, "unclaimedSegmentValidationThreshold");
        ReflectionUtils.setFieldValue((Field)unclaimedSegmentValidationThresholdField, coordinationTask, (Object)0L);
        Field releasesDeadlinesField = this.getField(coordinator, "releasesDeadlines");
        Map map = (Map)ReflectionUtils.getFieldValue((Field)releasesDeadlinesField, (Object)coordinator);
        map.remove(segmentId);
        Method taskMethod = this.getMethod(coordinationTask, "scheduleImmediateCoordinationTask");
        ReflectionUtils.ensureAccessible((AccessibleObject)taskMethod);
        taskMethod.invoke(coordinationTask, new Object[0]);
    }

    private final void removeReleaseDeadlineForTrackingProcoessor(StreamingEventProcessor processor, int segmentId) {
        Field releasesDeadlinesField = this.getField(processor, "segmentReleaseDeadlines");
        Map map = (Map)ReflectionUtils.getFieldValue((Field)releasesDeadlinesField, (Object)processor);
        map.remove(segmentId);
    }

    private final StreamingEventProcessor eventProcessor(String processorName) {
        Object t = this.eventProcessingConfig.eventProcessor(processorName, StreamingEventProcessor.class).orElseThrow(() -> EventProcessorManager.eventProcessor$lambda-2(processorName));
        Intrinsics.checkNotNullExpressionValue(t, (String)"eventProcessingConfig.ev\u2026essorName] not found!\") }");
        return (StreamingEventProcessor)t;
    }

    private final Field getField(Object $this$getField, String name) {
        Object object;
        block2: {
            Field[] fieldArray = $this$getField.getClass().getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"this::class.java.declaredFields");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Field field = (Field)object;
        if (field == null) {
            throw new IllegalStateException("Could not find field [" + name + "]!");
        }
        return field;
    }

    private final Method getMethod(Object $this$getMethod, String name) {
        Object object;
        block2: {
            Method[] methodArray = $this$getMethod.getClass().getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"this::class.java.declaredMethods");
            Object[] $this$firstOrNull$iv = methodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Method method = (Method)object;
        if (method == null) {
            throw new IllegalStateException("Could not find method [" + name + "]!");
        }
        return method;
    }

    private static final TrackingToken resetTokens$lambda-0(ResetDecision $resetDecision, StreamableMessageSource messageSource) {
        TrackingToken trackingToken;
        Intrinsics.checkNotNullParameter((Object)$resetDecision, (String)"$resetDecision");
        switch (WhenMappings.$EnumSwitchMapping$0[$resetDecision.getDecision().ordinal()]) {
            case 1: {
                trackingToken = messageSource.createHeadToken();
                break;
            }
            case 2: {
                trackingToken = messageSource.createTailToken();
                break;
            }
            case 3: {
                Instant instant = $resetDecision.getFrom();
                Intrinsics.checkNotNull((Object)instant);
                trackingToken = messageSource.createTokenAt(instant);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return trackingToken;
    }

    private static final void claimSegment$lambda-1(EventProcessorManager this$0, String $processorName, int $segmentId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        this$0.eventProcessingConfig.tokenStore($processorName).fetchToken($processorName, $segmentId);
    }

    private static final IllegalArgumentException eventProcessor$lambda-2(String $processorName) {
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        return new IllegalArgumentException("Event Processor [" + $processorName + "] not found!");
    }

    public static final /* synthetic */ Logger access$getLogger$p(EventProcessorManager $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResetDecisions.values().length];
            nArray[ResetDecisions.HEAD.ordinal()] = 1;
            nArray[ResetDecisions.TAIL.ordinal()] = 2;
            nArray[ResetDecisions.FROM.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

