/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.eventprocessor;

import io.axoniq.console.framework.api.ProcessingGroupStatus;
import io.axoniq.console.framework.api.ProcessorMode;
import io.axoniq.console.framework.api.ProcessorStatus;
import io.axoniq.console.framework.api.ProcessorStatusReport;
import io.axoniq.console.framework.api.SegmentDetails;
import io.axoniq.console.framework.api.SegmentOverview;
import io.axoniq.console.framework.api.SegmentStatus;
import io.axoniq.console.framework.eventprocessor.metrics.ProcessorMetricsRegistry;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.AbstractEventProcessor;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.MultiEventHandlerInvoker;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventHandlerInvoker;
import org.axonframework.eventhandling.pooled.PooledStreamingEventProcessor;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u0013\u001a\u00020\u0011*\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016*\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/axoniq/console/framework/eventprocessor/ProcessorReportCreator;", "", "processingConfig", "Lorg/axonframework/config/EventProcessingConfiguration;", "metricsRegistry", "Lio/axoniq/console/framework/eventprocessor/metrics/ProcessorMetricsRegistry;", "(Lorg/axonframework/config/EventProcessingConfiguration;Lio/axoniq/console/framework/eventprocessor/metrics/ProcessorMetricsRegistry;)V", "createReport", "Lio/axoniq/console/framework/api/ProcessorStatusReport;", "createSegmentOverview", "Lio/axoniq/console/framework/api/SegmentOverview;", "processorName", "", "getField", "Ljava/lang/reflect/Field;", "name", "getStatusByReflectionOrDefault", "Lio/axoniq/console/framework/api/ProcessingGroupStatus;", "Lorg/axonframework/eventhandling/deadletter/DeadLetteringEventHandlerInvoker;", "toProcessingGroupStatus", "Lorg/axonframework/eventhandling/EventHandlerInvoker;", "toProcessingGroupStatuses", "", "Lorg/axonframework/eventhandling/EventProcessor;", "toStatus", "Lio/axoniq/console/framework/api/SegmentStatus;", "Lorg/axonframework/eventhandling/EventTrackerStatus;", "toType", "Lio/axoniq/console/framework/api/ProcessorMode;", "Lorg/axonframework/eventhandling/StreamingEventProcessor;", "console-framework-client"})
public final class ProcessorReportCreator {
    @NotNull
    private final EventProcessingConfiguration processingConfig;
    @NotNull
    private final ProcessorMetricsRegistry metricsRegistry;

    public ProcessorReportCreator(@NotNull EventProcessingConfiguration processingConfig, @NotNull ProcessorMetricsRegistry metricsRegistry) {
        Intrinsics.checkNotNullParameter((Object)processingConfig, (String)"processingConfig");
        Intrinsics.checkNotNullParameter((Object)metricsRegistry, (String)"metricsRegistry");
        this.processingConfig = processingConfig;
        this.metricsRegistry = metricsRegistry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProcessorStatusReport createReport() {
        void $this$mapTo$iv$iv;
        Map map = this.processingConfig.eventProcessors();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"processingConfig.eventProcessors()");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ProcessorStatus processorStatus;
            StreamingEventProcessor sep;
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (entry.getValue() instanceof StreamingEventProcessor) {
                Collection<SegmentStatus> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Map $this$filterValues$iv;
                Object v = entry.getValue();
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.axonframework.eventhandling.StreamingEventProcessor");
                }
                sep = (StreamingEventProcessor)v;
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                String string = (String)k;
                Object v2 = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"entry.value");
                List<ProcessingGroupStatus> list = this.toProcessingGroupStatuses((EventProcessor)v2);
                String string2 = sep.getTokenStoreIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sep.tokenStoreIdentifier");
                ProcessorMode processorMode = this.toType(sep);
                boolean bl2 = sep.isRunning();
                boolean bl3 = sep.isError();
                int n = sep.maxCapacity();
                Intrinsics.checkNotNullExpressionValue((Object)sep.processingStatus(), (String)"sep.processingStatus()");
                int n2 = n;
                boolean bl4 = bl3;
                boolean bl5 = bl2;
                ProcessorMode processorMode2 = processorMode;
                String string3 = string2;
                List<ProcessingGroupStatus> list2 = list;
                String string4 = string;
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                    EventTrackerStatus it = (EventTrackerStatus)entry$iv.getValue();
                    boolean bl6 = false;
                    if (!(!it.isErrorState())) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map map3 = result$iv;
                int n3 = map3.size();
                Intrinsics.checkNotNullExpressionValue((Object)sep.processingStatus(), (String)"sep.processingStatus()");
                int n4 = n3;
                boolean $i$f$map2 = false;
                result$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
                boolean $i$f$mapTo2 = false;
                Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry item$iv$iv2;
                    Map.Entry entry3 = item$iv$iv2 = iterator2.next();
                    collection2 = destination$iv$iv2;
                    boolean bl7 = false;
                    EventTrackerStatus segment = (EventTrackerStatus)entry3.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)segment, (String)"segment");
                    Object k2 = entry.getKey();
                    Intrinsics.checkNotNullExpressionValue(k2, (String)"entry.key");
                    collection2.add(this.toStatus(segment, (String)k2));
                }
                Collection<SegmentStatus> collection3 = collection2 = (List)destination$iv$iv2;
                int n5 = n4;
                int n6 = n2;
                boolean bl8 = bl4;
                boolean bl9 = bl5;
                ProcessorMode processorMode3 = processorMode2;
                String string5 = string3;
                List<ProcessingGroupStatus> list3 = list2;
                String string6 = string4;
                processorStatus = new ProcessorStatus(string6, list3, string5, processorMode3, bl9, bl8, n6, n5, collection3);
            } else {
                Object v = entry.getValue();
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.axonframework.eventhandling.SubscribingEventProcessor");
                }
                sep = (SubscribingEventProcessor)v;
                String string = sep.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sep.name");
                processorStatus = new ProcessorStatus(string, CollectionsKt.emptyList(), "", ProcessorMode.SUBSCRIBING, sep.isRunning(), sep.isError(), 0, 0, CollectionsKt.emptyList());
            }
            collection.add(processorStatus);
        }
        List list = (List)destination$iv$iv;
        return new ProcessorStatusReport(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SegmentOverview createSegmentOverview(@NotNull String processorName) {
        Collection collection;
        Object $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        TokenStore tokenStore = this.processingConfig.tokenStore(processorName);
        int[] segments = tokenStore.fetchSegments(processorName);
        Intrinsics.checkNotNullExpressionValue((Object)segments, (String)"segments");
        Object $this$map$iv = segments;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv2;
            void var12_15 = item$iv$iv2 = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Segment.computeSegment((int)it, (int[])Arrays.copyOf(segments, segments.length)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Segment item$iv$iv2 = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SegmentDetails(it.getSegmentId(), it.mergeableSegmentId(), it.getMask()));
        }
        List list = (List)destination$iv$iv;
        return new SegmentOverview(list);
    }

    private final ProcessorMode toType(StreamingEventProcessor $this$toType) {
        StreamingEventProcessor streamingEventProcessor = $this$toType;
        return streamingEventProcessor instanceof TrackingEventProcessor ? ProcessorMode.TRACKING : (streamingEventProcessor instanceof PooledStreamingEventProcessor ? ProcessorMode.POOLED : ProcessorMode.UNKNOWN);
    }

    private final SegmentStatus toStatus(EventTrackerStatus $this$toStatus, String name) {
        Serializable serializable;
        Throwable throwable = $this$toStatus.getError();
        OptionalLong optionalLong = $this$toStatus.getCurrentPosition();
        OptionalLong optionalLong2 = $this$toStatus.getResetPosition();
        return new SegmentStatus($this$toStatus.getSegment().getSegmentId(), $this$toStatus.getSegment().mergeableSegmentId(), $this$toStatus.getSegment().getMask(), $this$toStatus.getSegment().getMask() + 1, $this$toStatus.isCaughtUp(), $this$toStatus.isErrorState(), (serializable = $this$toStatus.getError()) != null && (serializable = serializable.getClass()) != null ? ((Class)serializable).getTypeName() : null, throwable != null ? throwable.getMessage() : null, Double.valueOf(this.metricsRegistry.ingestLatencyForProcessor(name, $this$toStatus.getSegment().getSegmentId()).getValue()), Double.valueOf(this.metricsRegistry.commitLatencyForProcessor(name, $this$toStatus.getSegment().getSegmentId()).getValue()), Long.valueOf(optionalLong != null ? optionalLong.orElse(-1L) : -1L), Long.valueOf(optionalLong2 != null ? optionalLong2.orElse(-1L) : -1L));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProcessingGroupStatus> toProcessingGroupStatuses(EventProcessor $this$toProcessingGroupStatuses) {
        List list;
        if ($this$toProcessingGroupStatuses instanceof AbstractEventProcessor) {
            EventHandlerInvoker invoker = ((AbstractEventProcessor)$this$toProcessingGroupStatuses).eventHandlerInvoker();
            if (invoker instanceof MultiEventHandlerInvoker) {
                void $this$mapTo$iv$iv;
                List list2 = ((MultiEventHandlerInvoker)invoker).delegates();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"invoker.delegates()");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void i;
                    EventHandlerInvoker eventHandlerInvoker = (EventHandlerInvoker)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
                    String string = ((AbstractEventProcessor)$this$toProcessingGroupStatuses).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
                    collection.add(this.toProcessingGroupStatus((EventHandlerInvoker)i, string));
                }
                list = (List)destination$iv$iv;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)invoker, (String)"invoker");
                String string = ((AbstractEventProcessor)$this$toProcessingGroupStatuses).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
                list = CollectionsKt.listOf((Object)this.toProcessingGroupStatus(invoker, string));
            }
        } else {
            String string = $this$toProcessingGroupStatuses.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
            list = CollectionsKt.listOf((Object)new ProcessingGroupStatus(string, null));
        }
        return list;
    }

    private final ProcessingGroupStatus toProcessingGroupStatus(EventHandlerInvoker $this$toProcessingGroupStatus, String processorName) {
        return $this$toProcessingGroupStatus instanceof DeadLetteringEventHandlerInvoker ? this.getStatusByReflectionOrDefault((DeadLetteringEventHandlerInvoker)$this$toProcessingGroupStatus, processorName) : new ProcessingGroupStatus(processorName, null);
    }

    private final ProcessingGroupStatus getStatusByReflectionOrDefault(DeadLetteringEventHandlerInvoker $this$getStatusByReflectionOrDefault, String processorName) {
        Field field = this.getField($this$getStatusByReflectionOrDefault, "queue");
        if (field == null) {
            return new ProcessingGroupStatus(processorName, null);
        }
        Field queueField = field;
        SequencedDeadLetterQueue queue = (SequencedDeadLetterQueue)ReflectionUtils.getFieldValue((Field)queueField, (Object)$this$getStatusByReflectionOrDefault);
        Intrinsics.checkNotNullExpressionValue((Object)queue, (String)"queue");
        Field field2 = this.getField(queue, "processingGroup");
        if (field2 == null) {
            return new ProcessingGroupStatus(processorName, null);
        }
        Field processingGroupField = field2;
        String processingGroup = (String)ReflectionUtils.getFieldValue((Field)processingGroupField, (Object)queue);
        Intrinsics.checkNotNullExpressionValue((Object)processingGroup, (String)"processingGroup");
        return new ProcessingGroupStatus(processingGroup, Long.valueOf(queue.amountOfSequences()));
    }

    private final Field getField(Object $this$getField, String name) {
        Object object;
        block1: {
            Field[] fieldArray = $this$getField.getClass().getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"this::class.java.declaredFields");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (Field)object;
    }
}

