/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.messaging;

import io.axoniq.console.framework.api.metrics.HandlerStatisticsMetricIdentifier;
import io.axoniq.console.framework.api.metrics.HandlerType;
import io.axoniq.console.framework.api.metrics.MessageIdentifier;
import io.axoniq.console.framework.api.metrics.StatisticDistribution;
import io.axoniq.console.framework.messaging.AxoniqConsoleSpanFactory;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.AggregateScopeDescriptor;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u001a\u001d\u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u0016\u001a\n\u0010\u0017\u001a\u00020\t*\u00020\t\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isAggregateLifecycleActive", "", "extractHandler", "Lio/axoniq/console/framework/api/metrics/HandlerStatisticsMetricIdentifier;", "Lorg/axonframework/messaging/unitofwork/UnitOfWork;", "declaringClassName", "", "processingGroup", "ofPercentile", "", "", "Lio/micrometer/core/instrument/distribution/ValueAtPercentile;", "percentile", "([Lio/micrometer/core/instrument/distribution/ValueAtPercentile;D)D", "toDistribution", "Lio/axoniq/console/framework/api/metrics/StatisticDistribution;", "Lio/micrometer/core/instrument/distribution/HistogramSnapshot;", "toInformation", "Lio/axoniq/console/framework/api/metrics/MessageIdentifier;", "Lorg/axonframework/messaging/Message;", "toSimpleName", "console-framework-client"})
public final class ExtensionsKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"axoniq-console-extensions");

    @NotNull
    public static final MessageIdentifier toInformation(@NotNull Message<?> $this$toInformation) {
        String string;
        Intrinsics.checkNotNullParameter($this$toInformation, (String)"<this>");
        Message<?> message = $this$toInformation;
        Message<?> message2 = message instanceof DeadlineMessage ? DeadlineMessage.class.getSimpleName() : (message instanceof CommandMessage ? CommandMessage.class.getSimpleName() : (message instanceof EventMessage ? EventMessage.class.getSimpleName() : (message instanceof QueryMessage ? QueryMessage.class.getSimpleName() : (message instanceof SubscriptionQueryUpdateMessage ? SubscriptionQueryUpdateMessage.class.getSimpleName() : $this$toInformation.getClass().getSimpleName()))));
        Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"when (this) {\n        is\u2026ass.java.simpleName\n    }");
        Message<?> message3 = message2;
        message2 = $this$toInformation;
        if (message2 instanceof CommandMessage) {
            String string2 = ((CommandMessage)$this$toInformation).getCommandName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.commandName");
            string = ExtensionsKt.toSimpleName(string2);
        } else if (message2 instanceof QueryMessage) {
            String string3 = ((QueryMessage)$this$toInformation).getQueryName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.queryName");
            string = ExtensionsKt.toSimpleName(string3);
        } else if (message2 instanceof DeadlineMessage) {
            String string4 = ((DeadlineMessage)$this$toInformation).getDeadlineName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this.deadlineName");
            string = ExtensionsKt.toSimpleName(string4);
        } else {
            String string5 = $this$toInformation.getPayloadType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this.payloadType.name");
            string = ExtensionsKt.toSimpleName(string5);
        }
        return new MessageIdentifier(message3, string);
    }

    @NotNull
    public static final String toSimpleName(@NotNull String $this$toSimpleName) {
        Intrinsics.checkNotNullParameter((Object)$this$toSimpleName, (String)"<this>");
        String[] stringArray = new String[]{"."};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)$this$toSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @Nullable
    public static final HandlerStatisticsMetricIdentifier extractHandler(@NotNull UnitOfWork<?> $this$extractHandler, @NotNull String declaringClassName, @Nullable String processingGroup) {
        HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier;
        Intrinsics.checkNotNullParameter($this$extractHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaringClassName, (String)"declaringClassName");
        try {
            String string;
            boolean isAggregate = $this$extractHandler.getMessage() instanceof CommandMessage && ExtensionsKt.isAggregateLifecycleActive();
            boolean isProcessor = processingGroup != null;
            if (isAggregate) {
                ScopeDescriptor scopeDescriptor = AggregateLifecycle.describeCurrentScope();
                if (scopeDescriptor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.axonframework.modelling.command.AggregateScopeDescriptor");
                }
                string = ((AggregateScopeDescriptor)scopeDescriptor).getType();
            } else if (isProcessor) {
                string = processingGroup;
                if (string == null) {
                    AxoniqConsoleSpanFactory.MeasuringConsoleSpan measuringConsoleSpan = AxoniqConsoleSpanFactory.Companion.currentSpan();
                    string = measuringConsoleSpan != null ? measuringConsoleSpan.getProcessorName() : null;
                }
            } else {
                string = declaringClassName;
            }
            String component = string;
            HandlerType type = isAggregate ? HandlerType.Aggregate : (isProcessor ? HandlerType.EventProcessor : HandlerType.Message);
            Message message = $this$extractHandler.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
            handlerStatisticsMetricIdentifier = new HandlerStatisticsMetricIdentifier(type, component, ExtensionsKt.toInformation(message));
        }
        catch (Exception e) {
            logger.warn("Could not extract handler from AxonIQ Console invocation. Skipping registration of message.", (Throwable)e);
            handlerStatisticsMetricIdentifier = null;
        }
        return handlerStatisticsMetricIdentifier;
    }

    public static final boolean isAggregateLifecycleActive() {
        boolean bl;
        try {
            ScopeDescriptor scope = AggregateLifecycle.describeCurrentScope();
            bl = scope instanceof AggregateScopeDescriptor;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final StatisticDistribution toDistribution(@NotNull HistogramSnapshot $this$toDistribution) {
        Intrinsics.checkNotNullParameter((Object)$this$toDistribution, (String)"<this>");
        ValueAtPercentile[] valueAtPercentileArray = $this$toDistribution.percentileValues();
        Intrinsics.checkNotNullExpressionValue((Object)valueAtPercentileArray, (String)"percentileValues()");
        ValueAtPercentile[] percentiles = valueAtPercentileArray;
        double d = ExtensionsKt.ofPercentile(percentiles, 0.01);
        double d2 = ExtensionsKt.ofPercentile(percentiles, 0.9);
        double d3 = ExtensionsKt.ofPercentile(percentiles, 0.95);
        double d4 = ExtensionsKt.ofPercentile(percentiles, 0.5);
        double d5 = $this$toDistribution.mean(TimeUnit.MILLISECONDS);
        double d6 = ExtensionsKt.ofPercentile(percentiles, 1.0);
        return new StatisticDistribution(d, d4, d5, d3, d2, d6);
    }

    public static final double ofPercentile(@NotNull ValueAtPercentile[] $this$ofPercentile, double percentile) {
        ValueAtPercentile valueAtPercentile;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$ofPercentile, (String)"<this>");
            ValueAtPercentile[] $this$firstOrNull$iv = $this$ofPercentile;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                ValueAtPercentile element$iv;
                ValueAtPercentile pc = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(pc.percentile() == percentile)) continue;
                valueAtPercentile = element$iv;
                break block1;
            }
            valueAtPercentile = null;
        }
        ValueAtPercentile valueAtPercentile2 = valueAtPercentile;
        Double d = valueAtPercentile2 != null ? Double.valueOf(valueAtPercentile2.value(TimeUnit.MILLISECONDS)) : null;
        Intrinsics.checkNotNull(d);
        return d;
    }
}

