/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework;

import io.axoniq.console.framework.AxoniqConsoleAggregateConfigurerModule;
import io.axoniq.console.framework.AxoniqConsoleDlqMode;
import io.axoniq.console.framework.AxoniqConsoleEnhancingConfigurerModule;
import io.axoniq.console.framework.application.ApplicationMetricRegistry;
import io.axoniq.console.framework.application.ApplicationMetricReporter;
import io.axoniq.console.framework.application.ApplicationReportCreator;
import io.axoniq.console.framework.client.AxoniqConsoleRSocketClient;
import io.axoniq.console.framework.client.ClientSettingsService;
import io.axoniq.console.framework.client.RSocketHandlerRegistrar;
import io.axoniq.console.framework.client.ServerProcessorReporter;
import io.axoniq.console.framework.client.SetupPayloadCreator;
import io.axoniq.console.framework.client.strategy.CborEncodingStrategy;
import io.axoniq.console.framework.client.strategy.RSocketPayloadEncodingStrategy;
import io.axoniq.console.framework.eventprocessor.DeadLetterManager;
import io.axoniq.console.framework.eventprocessor.EventProcessorManager;
import io.axoniq.console.framework.eventprocessor.ProcessorReportCreator;
import io.axoniq.console.framework.eventprocessor.RSocketDlqResponder;
import io.axoniq.console.framework.eventprocessor.RSocketProcessorResponder;
import io.axoniq.console.framework.eventprocessor.metrics.AxoniqConsoleProcessorInterceptor;
import io.axoniq.console.framework.eventprocessor.metrics.ProcessorMetricsRegistry;
import io.axoniq.console.framework.messaging.AxoniqConsoleDispatchInterceptor;
import io.axoniq.console.framework.messaging.AxoniqConsoleSpanFactory;
import io.axoniq.console.framework.messaging.AxoniqConsoleWrappedEventScheduler;
import io.axoniq.console.framework.messaging.HandlerMetricsRegistry;
import io.axoniq.console.framework.messaging.SpanMatcher;
import io.axoniq.console.framework.messaging.SpanMatcherPredicateMap;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.tracing.SpanFactory;
import org.jetbrains.annotations.NotNull;

public class AxoniqConsoleConfigurerModule
implements ConfigurerModule {
    private final String environmentId;
    private final String accessToken;
    private final String applicationName;
    private final String host;
    private final Integer port;
    private final Boolean secure;
    private final Long initialDelay;
    private final AxoniqConsoleDlqMode dlqMode;
    private final List<String> dlqDiagnosticsWhitelist;
    private final ScheduledExecutorService reportingTaskExecutor;
    private final ExecutorService managementTaskExecutor;
    private final boolean configureSpanFactory;
    private final SpanMatcherPredicateMap spanMatcherPredicateMap;
    private final EventScheduler eventScheduler;
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    protected AxoniqConsoleConfigurerModule(Builder builder) {
        this.environmentId = builder.environmentId;
        this.accessToken = builder.accessToken;
        this.applicationName = builder.applicationName.replaceAll("([\\[\\]])", "-");
        this.host = builder.host;
        this.port = builder.port;
        this.secure = builder.secure;
        this.initialDelay = builder.initialDelay;
        this.dlqMode = builder.dlqMode;
        this.dlqDiagnosticsWhitelist = builder.dlqDiagnosticsWhitelist;
        this.reportingTaskExecutor = builder.reportingTaskExecutor;
        this.managementTaskExecutor = builder.managementTaskExecutor;
        this.configureSpanFactory = !builder.disableSpanFactoryInConfiguration;
        this.spanMatcherPredicateMap = builder.spanMatcherPredicateMap;
        this.eventScheduler = builder.eventScheduler;
    }

    public static Builder builder(String environmentId, String accessToken, String applicationName) {
        return new Builder(environmentId, accessToken, applicationName);
    }

    public void configureModule(@NotNull Configurer configurer) {
        configurer.registerComponent(ClientSettingsService.class, c -> new ClientSettingsService()).registerComponent(ProcessorMetricsRegistry.class, c -> new ProcessorMetricsRegistry()).registerComponent(ApplicationMetricRegistry.class, c -> new ApplicationMetricRegistry(this.meterRegistry)).registerComponent(ProcessorReportCreator.class, c -> new ProcessorReportCreator(c.eventProcessingConfiguration(), (ProcessorMetricsRegistry)c.getComponent(ProcessorMetricsRegistry.class))).registerComponent(ApplicationReportCreator.class, c -> new ApplicationReportCreator((ApplicationMetricRegistry)c.getComponent(ApplicationMetricRegistry.class))).registerComponent(SetupPayloadCreator.class, SetupPayloadCreator::new).registerComponent(EventProcessorManager.class, c -> new EventProcessorManager(c.eventProcessingConfiguration(), (TransactionManager)c.getComponent(TransactionManager.class, NoTransactionManager::instance))).registerComponent(RSocketPayloadEncodingStrategy.class, c -> new CborEncodingStrategy()).registerComponent(RSocketHandlerRegistrar.class, c -> new RSocketHandlerRegistrar((RSocketPayloadEncodingStrategy)c.getComponent(RSocketPayloadEncodingStrategy.class))).registerComponent(RSocketProcessorResponder.class, c -> new RSocketProcessorResponder((EventProcessorManager)c.getComponent(EventProcessorManager.class), (ProcessorReportCreator)c.getComponent(ProcessorReportCreator.class), (RSocketHandlerRegistrar)c.getComponent(RSocketHandlerRegistrar.class))).registerComponent(AxoniqConsoleRSocketClient.class, c -> new AxoniqConsoleRSocketClient(this.environmentId, this.accessToken, this.applicationName, this.host, this.port, this.secure, this.initialDelay, (SetupPayloadCreator)c.getComponent(SetupPayloadCreator.class), (RSocketHandlerRegistrar)c.getComponent(RSocketHandlerRegistrar.class), (RSocketPayloadEncodingStrategy)c.getComponent(RSocketPayloadEncodingStrategy.class), (ClientSettingsService)c.getComponent(ClientSettingsService.class), this.reportingTaskExecutor, ManagementFactory.getRuntimeMXBean().getName())).registerComponent(ServerProcessorReporter.class, c -> new ServerProcessorReporter((AxoniqConsoleRSocketClient)c.getComponent(AxoniqConsoleRSocketClient.class), (ProcessorReportCreator)c.getComponent(ProcessorReportCreator.class), (ClientSettingsService)c.getComponent(ClientSettingsService.class), this.reportingTaskExecutor)).registerComponent(ApplicationMetricReporter.class, c -> new ApplicationMetricReporter((AxoniqConsoleRSocketClient)c.getComponent(AxoniqConsoleRSocketClient.class), (ApplicationReportCreator)c.getComponent(ApplicationReportCreator.class), (ClientSettingsService)c.getComponent(ClientSettingsService.class), this.reportingTaskExecutor)).registerComponent(HandlerMetricsRegistry.class, c -> new HandlerMetricsRegistry((AxoniqConsoleRSocketClient)c.getComponent(AxoniqConsoleRSocketClient.class), (ClientSettingsService)c.getComponent(ClientSettingsService.class), this.reportingTaskExecutor, this.applicationName)).registerComponent(DeadLetterManager.class, c -> new DeadLetterManager(c.eventProcessingConfiguration(), c.eventSerializer(), this.dlqMode, this.dlqDiagnosticsWhitelist, this.managementTaskExecutor)).registerComponent(RSocketDlqResponder.class, c -> new RSocketDlqResponder((DeadLetterManager)c.getComponent(DeadLetterManager.class), (RSocketHandlerRegistrar)c.getComponent(RSocketHandlerRegistrar.class))).eventProcessing().registerDefaultHandlerInterceptor((c, name) -> new AxoniqConsoleProcessorInterceptor((ProcessorMetricsRegistry)c.getComponent(ProcessorMetricsRegistry.class), (String)name));
        if (this.configureSpanFactory) {
            configurer.registerComponent(SpanFactory.class, c -> new AxoniqConsoleSpanFactory(this.spanMatcherPredicateMap));
        }
        if (Objects.nonNull(this.eventScheduler)) {
            configurer.registerComponent(EventScheduler.class, c -> new AxoniqConsoleWrappedEventScheduler(this.eventScheduler, this.applicationName));
        }
        configurer.onInitialize(c -> {
            c.getComponent(ServerProcessorReporter.class);
            c.getComponent(ApplicationMetricReporter.class);
            c.getComponent(RSocketProcessorResponder.class);
            c.getComponent(RSocketDlqResponder.class);
            c.getComponent(HandlerMetricsRegistry.class);
        });
        configurer.onStart(() -> {
            Configuration config = configurer.buildConfiguration();
            AxoniqConsoleDispatchInterceptor interceptor = new AxoniqConsoleDispatchInterceptor((HandlerMetricsRegistry)config.getComponent(HandlerMetricsRegistry.class), this.applicationName);
            config.eventBus().registerDispatchInterceptor((MessageDispatchInterceptor)interceptor);
            config.commandBus().registerDispatchInterceptor((MessageDispatchInterceptor)interceptor);
            config.queryBus().registerDispatchInterceptor((MessageDispatchInterceptor)interceptor);
            config.deadlineManager().registerDispatchInterceptor((MessageDispatchInterceptor)interceptor);
        });
        configurer.onShutdown(() -> {
            this.managementTaskExecutor.shutdown();
            this.reportingTaskExecutor.shutdown();
        });
        new AxoniqConsoleAggregateConfigurerModule().configureModule(configurer);
        new AxoniqConsoleEnhancingConfigurerModule(this.spanMatcherPredicateMap).configureModule(configurer);
    }

    public static class Builder {
        private final String environmentId;
        private final String accessToken;
        private final String applicationName;
        private String host = "framework.console.axoniq.io";
        private Boolean secure = true;
        private Integer port = 7000;
        private AxoniqConsoleDlqMode dlqMode = AxoniqConsoleDlqMode.NONE;
        private final List<String> dlqDiagnosticsWhitelist = new ArrayList<String>();
        private Long initialDelay = 0L;
        private boolean disableSpanFactoryInConfiguration = false;
        private final SpanMatcherPredicateMap spanMatcherPredicateMap = SpanMatcher.getSpanMatcherPredicateMap();
        private ScheduledExecutorService reportingTaskExecutor;
        private Integer reportingThreadPoolSize = 2;
        private ExecutorService managementTaskExecutor;
        private Integer managementMaxThreadPoolSize = 5;
        private EventScheduler eventScheduler;

        public Builder(String environmentId, String accessToken, String applicationName) {
            BuilderUtils.assertNonEmpty((String)environmentId, (String)"AxonIQ Console environmentId may not be null or empty");
            BuilderUtils.assertNonEmpty((String)accessToken, (String)"AxonIQ Console accessToken may not be null or empty");
            BuilderUtils.assertNonEmpty((String)applicationName, (String)"AxonIQ Console applicationName may not be null or empty");
            this.environmentId = environmentId;
            this.accessToken = accessToken;
            this.applicationName = applicationName;
        }

        public Builder host(String host) {
            BuilderUtils.assertNonEmpty((String)host, (String)"AxonIQ Console host may not be null or empty");
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            BuilderUtils.assertNonNull((Object)this.host, (String)"AxonIQ Console port may not be null");
            this.port = port;
            return this;
        }

        public Builder dlqMode(AxoniqConsoleDlqMode dlqMode) {
            BuilderUtils.assertNonNull((Object)((Object)dlqMode), (String)"AxonIQ Console dlqMode may not be null");
            this.dlqMode = dlqMode;
            return this;
        }

        public Builder addDlqDiagnosticsWhitelistKey(String key) {
            BuilderUtils.assertNonEmpty((String)key, (String)"Dlq diagnostics whitelist key may not be null");
            this.dlqDiagnosticsWhitelist.add(key);
            return this;
        }

        public Builder initialDelay(Long initialDelay) {
            BuilderUtils.assertPositive((long)initialDelay, (String)"AxonIQ Console initialDelay must be positive");
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder reportingThreadPoolSize(Integer reportingThreadPoolSize) {
            BuilderUtils.assertPositive((int)reportingThreadPoolSize, (String)"AxonIQ Console reportingThreadPoolSize must be positive");
            this.reportingThreadPoolSize = reportingThreadPoolSize;
            return this;
        }

        public Builder reportingTaskExecutor(ScheduledExecutorService executorService) {
            BuilderUtils.assertNonNull((Object)this.reportingTaskExecutor, (String)"AxonIQ Console reportingTaskExecutor must be non-null");
            this.reportingTaskExecutor = executorService;
            return this;
        }

        public Builder managementMaxThreadPoolSize(Integer managementMaxThreadPoolSize) {
            BuilderUtils.assertPositive((int)managementMaxThreadPoolSize, (String)"AxonIQ Console managementMaxThreadPoolSize must be positive");
            this.managementMaxThreadPoolSize = managementMaxThreadPoolSize;
            return this;
        }

        public Builder managementTaskExecutor(ExecutorService executorService) {
            BuilderUtils.assertNonNull((Object)this.managementTaskExecutor, (String)"AxonIQ Console managementTaskExecutor must be non-null");
            this.managementTaskExecutor = executorService;
            return this;
        }

        public Builder disableSpanFactoryInConfiguration() {
            this.disableSpanFactoryInConfiguration = true;
            return this;
        }

        public Builder changeSpanPredicate(SpanMatcher spanMatcher, Predicate<String> predicate) {
            BuilderUtils.assertNonNull((Object)((Object)spanMatcher), (String)"Span matcher to update spanMatcherPredicateMap must be non-null");
            BuilderUtils.assertNonNull(predicate, (String)"Predicate to update spanMatcherPredicateMap must be non-null");
            this.spanMatcherPredicateMap.put(spanMatcher, predicate);
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder eventScheduler(EventScheduler eventScheduler) {
            BuilderUtils.assertNonNull((Object)eventScheduler, (String)"Event scheduler must be non-null");
            this.eventScheduler = eventScheduler;
            return this;
        }

        public AxoniqConsoleConfigurerModule build() {
            if (this.reportingTaskExecutor == null) {
                this.reportingTaskExecutor = Executors.newScheduledThreadPool(this.reportingThreadPoolSize);
            }
            if (this.managementTaskExecutor == null) {
                this.managementTaskExecutor = new ThreadPoolExecutor(0, this.managementMaxThreadPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            }
            return new AxoniqConsoleConfigurerModule(this);
        }
    }
}

