/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.application;

import io.axoniq.console.framework.api.ClientSettingsV2;
import io.axoniq.console.framework.application.ApplicationMetricReporter;
import io.axoniq.console.framework.application.ApplicationReportCreator;
import io.axoniq.console.framework.client.AxoniqConsoleRSocketClient;
import io.axoniq.console.framework.client.ClientSettingsObserver;
import io.axoniq.console.framework.client.ClientSettingsService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/axoniq/console/framework/application/ApplicationMetricReporter;", "Lio/axoniq/console/framework/client/ClientSettingsObserver;", "client", "Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient;", "reportCreator", "Lio/axoniq/console/framework/application/ApplicationReportCreator;", "clientSettingsService", "Lio/axoniq/console/framework/client/ClientSettingsService;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient;Lio/axoniq/console/framework/application/ApplicationReportCreator;Lio/axoniq/console/framework/client/ClientSettingsService;Ljava/util/concurrent/ScheduledExecutorService;)V", "logger", "Lmu/KLogger;", "reportTask", "Ljava/util/concurrent/ScheduledFuture;", "onConnectedWithSettings", "", "settings", "Lio/axoniq/console/framework/api/ClientSettingsV2;", "onDisconnected", "report", "console-framework-client"})
public final class ApplicationMetricReporter
implements ClientSettingsObserver {
    @NotNull
    private final AxoniqConsoleRSocketClient client;
    @NotNull
    private final ApplicationReportCreator reportCreator;
    @NotNull
    private final ClientSettingsService clientSettingsService;
    @NotNull
    private final ScheduledExecutorService executor;
    @Nullable
    private ScheduledFuture<?> reportTask;
    @NotNull
    private final KLogger logger;

    public ApplicationMetricReporter(@NotNull AxoniqConsoleRSocketClient client, @NotNull ApplicationReportCreator reportCreator, @NotNull ClientSettingsService clientSettingsService, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)reportCreator, (String)"reportCreator");
        Intrinsics.checkNotNullParameter((Object)clientSettingsService, (String)"clientSettingsService");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.client = client;
        this.reportCreator = reportCreator;
        this.clientSettingsService = clientSettingsService;
        this.executor = executor;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.clientSettingsService.subscribeToSettings(this);
    }

    @Override
    public void onConnectedWithSettings(@NotNull ClientSettingsV2 settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.logger.debug((Function0)new Function0<Object>(settings){
            final /* synthetic */ ClientSettingsV2 $settings;
            {
                this.$settings = $settings;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Sending application information every " + this.$settings.getApplicationReportInterval() + "ms to AxonIQ console";
            }
        });
        this.reportTask = this.executor.scheduleWithFixedDelay(() -> ApplicationMetricReporter.onConnectedWithSettings$lambda-0(this), 0L, settings.getApplicationReportInterval(), TimeUnit.MILLISECONDS);
    }

    private final void report() {
        this.client.send("application-info-report", this.reportCreator.createReport()).block();
    }

    @Override
    public void onDisconnected() {
        ScheduledFuture<?> scheduledFuture = this.reportTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.reportTask = null;
    }

    private static final void onConnectedWithSettings$lambda-0(ApplicationMetricReporter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.report();
        }
        catch (Exception e) {
            this$0.logger.debug("Was unable to report application metrics: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

