/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.application;

import io.axoniq.console.framework.api.metrics.ApplicationMetricReport;
import io.axoniq.console.framework.api.metrics.BusMetricReport;
import io.axoniq.console.framework.api.metrics.MemoryPoolReport;
import io.axoniq.console.framework.application.ApplicationMetricRegistry;
import io.axoniq.console.framework.application.CpuMetricsProvider;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/axoniq/console/framework/application/ApplicationReportCreator;", "", "registry", "Lio/axoniq/console/framework/application/ApplicationMetricRegistry;", "(Lio/axoniq/console/framework/application/ApplicationMetricRegistry;)V", "cpuMetricsProvider", "Lio/axoniq/console/framework/application/CpuMetricsProvider;", "memoryBeans", "", "Ljava/lang/management/MemoryPoolMXBean;", "kotlin.jvm.PlatformType", "", "osBean", "Ljava/lang/management/OperatingSystemMXBean;", "threadBean", "Ljava/lang/management/ThreadMXBean;", "createReport", "Lio/axoniq/console/framework/api/metrics/ApplicationMetricReport;", "determineMemoryUsage", "Lio/axoniq/console/framework/api/metrics/MemoryPoolReport;", "toMb", "", "", "console-framework-client"})
public final class ApplicationReportCreator {
    @NotNull
    private final ApplicationMetricRegistry registry;
    private final List<MemoryPoolMXBean> memoryBeans;
    private final ThreadMXBean threadBean;
    private final OperatingSystemMXBean osBean;
    @NotNull
    private final CpuMetricsProvider cpuMetricsProvider;

    public ApplicationReportCreator(@NotNull ApplicationMetricRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.registry = registry;
        this.memoryBeans = ManagementFactory.getMemoryPoolMXBeans();
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
        this.cpuMetricsProvider = new CpuMetricsProvider();
    }

    @NotNull
    public final ApplicationMetricReport createReport() {
        double d = this.osBean.getSystemLoadAverage();
        double d2 = this.cpuMetricsProvider.getProcessCpuUsage();
        double d3 = this.cpuMetricsProvider.getSystemCpuUsage();
        MemoryPoolReport memoryPoolReport = this.determineMemoryUsage();
        int n = this.threadBean.getThreadCount();
        BusMetricReport busMetricReport = this.registry.getCommandBusMetrics();
        BusMetricReport busMetricReport2 = this.registry.getQueryBusMetrics();
        return new ApplicationMetricReport(d, d3, d2, n, memoryPoolReport, busMetricReport, busMetricReport2);
    }

    /*
     * WARNING - void declaration
     */
    private final MemoryPoolReport determineMemoryUsage() {
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        List<MemoryPoolMXBean> list = this.memoryBeans;
        Intrinsics.checkNotNullExpressionValue(list, (String)"memoryBeans");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MemoryPoolMXBean it = (MemoryPoolMXBean)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == MemoryType.HEAP && it.getUsage().getMax() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        MemoryPoolReport initial$iv = new MemoryPoolReport(0.0, 0.0, 0.0);
        boolean $i$f$fold = false;
        MemoryPoolReport accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bean;
            Object element$iv$iv;
            element$iv$iv = (MemoryPoolMXBean)element$iv;
            MemoryPoolReport acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new MemoryPoolReport(acc.getCommitted() + this.toMb(bean.getUsage().getUsed()), acc.getUsed() + this.toMb(bean.getUsage().getCommitted()), acc.getMax() + this.toMb(bean.getUsage().getMax()));
        }
        return accumulator$iv;
    }

    private final double toMb(Number $this$toMb) {
        return $this$toMb.doubleValue() / (double)1024 / (double)1024;
    }
}

