/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.eventprocessor;

import io.axoniq.console.framework.api.ProcessingGroupStatus;
import io.axoniq.console.framework.api.ProcessorMode;
import io.axoniq.console.framework.api.ProcessorStatus;
import io.axoniq.console.framework.api.ProcessorStatusReport;
import io.axoniq.console.framework.api.SegmentDetails;
import io.axoniq.console.framework.api.SegmentOverview;
import io.axoniq.console.framework.api.SegmentStatus;
import io.axoniq.console.framework.eventprocessor.metrics.ProcessorMetricsRegistry;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.AbstractEventProcessor;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.MultiEventHandlerInvoker;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventHandlerInvoker;
import org.axonframework.eventhandling.pooled.PooledStreamingEventProcessor;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u001d\u001a\u00020\u001b*\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013*\u00020\u0011H\u0002J\u0014\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\f\u0010#\u001a\u00020$*\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/axoniq/console/framework/eventprocessor/ProcessorReportCreator;", "", "processingConfig", "Lorg/axonframework/config/EventProcessingConfiguration;", "metricsRegistry", "Lio/axoniq/console/framework/eventprocessor/metrics/ProcessorMetricsRegistry;", "(Lorg/axonframework/config/EventProcessingConfiguration;Lio/axoniq/console/framework/eventprocessor/metrics/ProcessorMetricsRegistry;)V", "createReport", "Lio/axoniq/console/framework/api/ProcessorStatusReport;", "createSegmentOverview", "Lio/axoniq/console/framework/api/SegmentOverview;", "processorName", "", "defaultStatus", "Lio/axoniq/console/framework/api/ProcessorStatus;", "name", "processor", "Lorg/axonframework/eventhandling/EventProcessor;", "ignoreMultiTenantProcessorOrDefault", "", "streamingStatus", "Lorg/axonframework/eventhandling/StreamingEventProcessor;", "subscribingStatus", "Lorg/axonframework/eventhandling/SubscribingEventProcessor;", "getField", "Ljava/lang/reflect/Field;", "getStatusByReflectionOrDefault", "Lio/axoniq/console/framework/api/ProcessingGroupStatus;", "Lorg/axonframework/eventhandling/deadletter/DeadLetteringEventHandlerInvoker;", "toProcessingGroupStatus", "Lorg/axonframework/eventhandling/EventHandlerInvoker;", "toProcessingGroupStatuses", "toStatus", "Lio/axoniq/console/framework/api/SegmentStatus;", "Lorg/axonframework/eventhandling/EventTrackerStatus;", "toType", "Lio/axoniq/console/framework/api/ProcessorMode;", "Companion", "console-framework-client"})
public final class ProcessorReportCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventProcessingConfiguration processingConfig;
    @NotNull
    private final ProcessorMetricsRegistry metricsRegistry;
    @NotNull
    public static final String MULTI_TENANT_PROCESSOR_CLASS = "org.axonframework.extensions.multitenancy.components.eventhandeling.MultiTenantEventProcessor";

    public ProcessorReportCreator(@NotNull EventProcessingConfiguration processingConfig, @NotNull ProcessorMetricsRegistry metricsRegistry) {
        Intrinsics.checkNotNullParameter((Object)processingConfig, (String)"processingConfig");
        Intrinsics.checkNotNullParameter((Object)metricsRegistry, (String)"metricsRegistry");
        this.processingConfig = processingConfig;
        this.metricsRegistry = metricsRegistry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProcessorStatusReport createReport() {
        void $this$flatMapTo$iv$iv;
        Map map = this.processingConfig.eventProcessors();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"processingConfig.eventProcessors()");
        Map $this$flatMap$iv = map;
        boolean $i$f$flatMap = false;
        Map map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List<ProcessorStatus> list;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            EventProcessor processor = (EventProcessor)entry.getValue();
            if (processor instanceof StreamingEventProcessor) {
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                list = CollectionsKt.listOf((Object)this.streamingStatus((String)k, (StreamingEventProcessor)processor));
            } else if (processor instanceof SubscribingEventProcessor) {
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                list = CollectionsKt.listOf((Object)this.subscribingStatus((String)k, (SubscribingEventProcessor)processor));
            } else {
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                String string = (String)k;
                Intrinsics.checkNotNullExpressionValue((Object)processor, (String)"processor");
                list = this.ignoreMultiTenantProcessorOrDefault(string, processor);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return new ProcessorStatusReport(list);
    }

    /*
     * WARNING - void declaration
     */
    private final ProcessorStatus streamingStatus(String name, StreamingEventProcessor processor) {
        Collection<SegmentStatus> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map $this$filterValues$iv;
        List<ProcessingGroupStatus> list = this.toProcessingGroupStatuses((EventProcessor)processor);
        String string = processor.getTokenStoreIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processor.tokenStoreIdentifier");
        ProcessorMode processorMode = this.toType(processor);
        boolean bl = processor.isRunning();
        boolean bl2 = processor.isError();
        int n = processor.maxCapacity();
        Map map = processor.processingStatus();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"processor.processingStatus()");
        Map map2 = map;
        int n2 = n;
        boolean bl3 = bl2;
        boolean bl4 = bl;
        ProcessorMode processorMode2 = processorMode;
        String string2 = string;
        List<ProcessingGroupStatus> list2 = list;
        String string3 = name;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            EventTrackerStatus it = (EventTrackerStatus)entry$iv.getValue();
            boolean bl5 = false;
            if (!(!it.isErrorState())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map map3 = result$iv;
        int n3 = map3.size();
        Map map4 = processor.processingStatus();
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"processor.processingStatus()");
        $this$filterValues$iv = map4;
        int n4 = n3;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl6 = false;
            EventTrackerStatus segment = (EventTrackerStatus)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)segment, (String)"segment");
            collection.add(this.toStatus(segment, name));
        }
        Collection<SegmentStatus> collection2 = collection = (List)destination$iv$iv;
        int n5 = n4;
        int n6 = n2;
        boolean bl7 = bl3;
        boolean bl8 = bl4;
        ProcessorMode processorMode3 = processorMode2;
        String string4 = string2;
        List<ProcessingGroupStatus> list3 = list2;
        String string5 = string3;
        return new ProcessorStatus(string5, list3, string4, processorMode3, bl8, bl7, n6, n5, collection2);
    }

    private final ProcessorStatus subscribingStatus(String name, SubscribingEventProcessor processor) {
        return new ProcessorStatus(name, CollectionsKt.emptyList(), "", ProcessorMode.SUBSCRIBING, processor.isRunning(), processor.isError(), 0, 0, CollectionsKt.emptyList());
    }

    private final ProcessorStatus defaultStatus(String name, EventProcessor processor) {
        return new ProcessorStatus(name, CollectionsKt.emptyList(), "", ProcessorMode.UNKNOWN, processor.isRunning(), processor.isError(), 0, 0, CollectionsKt.emptyList());
    }

    private final List<ProcessorStatus> ignoreMultiTenantProcessorOrDefault(String name, EventProcessor processor) {
        return Intrinsics.areEqual((Object)processor.getClass().getName(), (Object)MULTI_TENANT_PROCESSOR_CLASS) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.defaultStatus(name, processor));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SegmentOverview createSegmentOverview(@NotNull String processorName) {
        Collection collection;
        Object $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        TokenStore tokenStore = this.processingConfig.tokenStore(processorName);
        int[] segments = tokenStore.fetchSegments(processorName);
        Intrinsics.checkNotNullExpressionValue((Object)segments, (String)"segments");
        Object $this$map$iv = segments;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv2;
            void var12_15 = item$iv$iv2 = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Segment.computeSegment((int)it, (int[])Arrays.copyOf(segments, segments.length)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Segment item$iv$iv2 = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SegmentDetails(it.getSegmentId(), it.mergeableSegmentId(), it.getMask()));
        }
        List list = (List)destination$iv$iv;
        return new SegmentOverview(list);
    }

    private final ProcessorMode toType(StreamingEventProcessor $this$toType) {
        StreamingEventProcessor streamingEventProcessor = $this$toType;
        return streamingEventProcessor instanceof TrackingEventProcessor ? ProcessorMode.TRACKING : (streamingEventProcessor instanceof PooledStreamingEventProcessor ? ProcessorMode.POOLED : ProcessorMode.UNKNOWN);
    }

    private final SegmentStatus toStatus(EventTrackerStatus $this$toStatus, String name) {
        Serializable serializable;
        Throwable throwable = $this$toStatus.getError();
        OptionalLong optionalLong = $this$toStatus.getCurrentPosition();
        OptionalLong optionalLong2 = $this$toStatus.getResetPosition();
        return new SegmentStatus($this$toStatus.getSegment().getSegmentId(), $this$toStatus.getSegment().mergeableSegmentId(), $this$toStatus.getSegment().getMask(), $this$toStatus.getSegment().getMask() + 1, $this$toStatus.isCaughtUp(), $this$toStatus.isErrorState(), (serializable = $this$toStatus.getError()) != null && (serializable = serializable.getClass()) != null ? ((Class)serializable).getTypeName() : null, throwable != null ? throwable.getMessage() : null, Double.valueOf(this.metricsRegistry.ingestLatencyForProcessor(name, $this$toStatus.getSegment().getSegmentId()).getValue()), Double.valueOf(this.metricsRegistry.commitLatencyForProcessor(name, $this$toStatus.getSegment().getSegmentId()).getValue()), Long.valueOf(optionalLong != null ? optionalLong.orElse(-1L) : -1L), Long.valueOf(optionalLong2 != null ? optionalLong2.orElse(-1L) : -1L));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProcessingGroupStatus> toProcessingGroupStatuses(EventProcessor $this$toProcessingGroupStatuses) {
        List list;
        if ($this$toProcessingGroupStatuses instanceof AbstractEventProcessor) {
            EventHandlerInvoker invoker = ((AbstractEventProcessor)$this$toProcessingGroupStatuses).eventHandlerInvoker();
            if (invoker instanceof MultiEventHandlerInvoker) {
                void $this$mapTo$iv$iv;
                List list2 = ((MultiEventHandlerInvoker)invoker).delegates();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"invoker.delegates()");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void i;
                    EventHandlerInvoker eventHandlerInvoker = (EventHandlerInvoker)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)i, (String)"i");
                    String string = ((AbstractEventProcessor)$this$toProcessingGroupStatuses).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
                    collection.add(this.toProcessingGroupStatus((EventHandlerInvoker)i, string));
                }
                list = (List)destination$iv$iv;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)invoker, (String)"invoker");
                String string = ((AbstractEventProcessor)$this$toProcessingGroupStatuses).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
                list = CollectionsKt.listOf((Object)this.toProcessingGroupStatus(invoker, string));
            }
        } else {
            String string = $this$toProcessingGroupStatuses.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
            list = CollectionsKt.listOf((Object)new ProcessingGroupStatus(string, null));
        }
        return list;
    }

    private final ProcessingGroupStatus toProcessingGroupStatus(EventHandlerInvoker $this$toProcessingGroupStatus, String processorName) {
        return $this$toProcessingGroupStatus instanceof DeadLetteringEventHandlerInvoker ? this.getStatusByReflectionOrDefault((DeadLetteringEventHandlerInvoker)$this$toProcessingGroupStatus, processorName) : new ProcessingGroupStatus(processorName, null);
    }

    private final ProcessingGroupStatus getStatusByReflectionOrDefault(DeadLetteringEventHandlerInvoker $this$getStatusByReflectionOrDefault, String processorName) {
        Field field = this.getField($this$getStatusByReflectionOrDefault, "queue");
        if (field == null) {
            return new ProcessingGroupStatus(processorName, null);
        }
        Field queueField = field;
        SequencedDeadLetterQueue queue = (SequencedDeadLetterQueue)ReflectionUtils.getFieldValue((Field)queueField, (Object)$this$getStatusByReflectionOrDefault);
        Intrinsics.checkNotNullExpressionValue((Object)queue, (String)"queue");
        Field field2 = this.getField(queue, "processingGroup");
        if (field2 == null) {
            return new ProcessingGroupStatus(processorName, null);
        }
        Field processingGroupField = field2;
        String processingGroup = (String)ReflectionUtils.getFieldValue((Field)processingGroupField, (Object)queue);
        Intrinsics.checkNotNullExpressionValue((Object)processingGroup, (String)"processingGroup");
        return new ProcessingGroupStatus(processingGroup, Long.valueOf(queue.amountOfSequences()));
    }

    private final Field getField(Object $this$getField, String name) {
        Object object;
        block1: {
            Field[] fieldArray = $this$getField.getClass().getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"this::class.java.declaredFields");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (Field)object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/axoniq/console/framework/eventprocessor/ProcessorReportCreator$Companion;", "", "()V", "MULTI_TENANT_PROCESSOR_CLASS", "", "console-framework-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

