/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.messaging;

import io.axoniq.console.framework.UtilsKt;
import io.axoniq.console.framework.api.ClientSettingsV2;
import io.axoniq.console.framework.api.metrics.AggregateStatisticIdentifier;
import io.axoniq.console.framework.api.metrics.AggregateStatistics;
import io.axoniq.console.framework.api.metrics.AggregateStatisticsWithIdentifier;
import io.axoniq.console.framework.api.metrics.DispatcherStatisticIdentifier;
import io.axoniq.console.framework.api.metrics.DispatcherStatistics;
import io.axoniq.console.framework.api.metrics.DispatcherStatisticsWithIdentifier;
import io.axoniq.console.framework.api.metrics.HandlerStatistics;
import io.axoniq.console.framework.api.metrics.HandlerStatisticsMetricIdentifier;
import io.axoniq.console.framework.api.metrics.HandlerStatisticsWithIdentifier;
import io.axoniq.console.framework.api.metrics.HandlerType;
import io.axoniq.console.framework.api.metrics.MessageIdentifier;
import io.axoniq.console.framework.api.metrics.Metric;
import io.axoniq.console.framework.api.metrics.MetricTargetType;
import io.axoniq.console.framework.api.metrics.StatisticDistribution;
import io.axoniq.console.framework.api.metrics.StatisticReport;
import io.axoniq.console.framework.client.AxoniqConsoleRSocketClient;
import io.axoniq.console.framework.client.ClientSettingsObserver;
import io.axoniq.console.framework.client.ClientSettingsService;
import io.axoniq.console.framework.messaging.ExtensionsKt;
import io.axoniq.console.framework.messaging.HandlerMetricsRegistry;
import io.axoniq.console.framework.messaging.RollingCountMeasure;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u0003567B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0002J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020$H\u0016J\u000e\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0010J\u000e\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,J2\u0010-\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020103R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry;", "Lio/axoniq/console/framework/client/ClientSettingsObserver;", "axoniqConsoleRSocketClient", "Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient;", "clientSettingsService", "Lio/axoniq/console/framework/client/ClientSettingsService;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "componentName", "", "(Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient;Lio/axoniq/console/framework/client/ClientSettingsService;Ljava/util/concurrent/ScheduledExecutorService;Ljava/lang/String;)V", "aggregates", "", "Lio/axoniq/console/framework/api/metrics/AggregateStatisticIdentifier;", "Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry$AggregateRegistryStatistics;", "dispatches", "Lio/axoniq/console/framework/api/metrics/DispatcherStatisticIdentifier;", "Lio/axoniq/console/framework/messaging/RollingCountMeasure;", "handlers", "Lio/axoniq/console/framework/api/metrics/HandlerStatisticsMetricIdentifier;", "Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry$HandlerRegistryStatistics;", "logger", "Lmu/KLogger;", "meterRegistry", "Lio/micrometer/core/instrument/simple/SimpleMeterRegistry;", "noHandlerIdentifier", "reportTask", "Ljava/util/concurrent/ScheduledFuture;", "createTimer", "Lio/micrometer/core/instrument/Timer;", "handler", "", "name", "getStats", "Lio/axoniq/console/framework/api/metrics/StatisticReport;", "onConnectedWithSettings", "", "settings", "Lio/axoniq/console/framework/api/ClientSettingsV2;", "onDisconnected", "registerMessageDispatchedDuringHandling", "dispatcher", "registerMessageDispatchedWithoutHandling", "message", "Lio/axoniq/console/framework/api/metrics/MessageIdentifier;", "registerMessageHandled", "success", "", "duration", "", "metrics", "", "Lio/axoniq/console/framework/api/metrics/Metric;", "AggregateRegistryStatistics", "Companion", "HandlerRegistryStatistics", "console-framework-client"})
public final class HandlerMetricsRegistry
implements ClientSettingsObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AxoniqConsoleRSocketClient axoniqConsoleRSocketClient;
    @NotNull
    private final ClientSettingsService clientSettingsService;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final String componentName;
    @NotNull
    private final KLogger logger;
    @Nullable
    private ScheduledFuture<?> reportTask;
    @NotNull
    private final SimpleMeterRegistry meterRegistry;
    @NotNull
    private final Map<DispatcherStatisticIdentifier, RollingCountMeasure> dispatches;
    @NotNull
    private final Map<HandlerStatisticsMetricIdentifier, HandlerRegistryStatistics> handlers;
    @NotNull
    private final Map<AggregateStatisticIdentifier, AggregateRegistryStatistics> aggregates;
    @NotNull
    private final HandlerStatisticsMetricIdentifier noHandlerIdentifier;
    @Nullable
    private static HandlerMetricsRegistry instance;

    public HandlerMetricsRegistry(@NotNull AxoniqConsoleRSocketClient axoniqConsoleRSocketClient, @NotNull ClientSettingsService clientSettingsService, @NotNull ScheduledExecutorService executor, @NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)axoniqConsoleRSocketClient, (String)"axoniqConsoleRSocketClient");
        Intrinsics.checkNotNullParameter((Object)clientSettingsService, (String)"clientSettingsService");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.axoniqConsoleRSocketClient = axoniqConsoleRSocketClient;
        this.clientSettingsService = clientSettingsService;
        this.executor = executor;
        this.componentName = componentName;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.meterRegistry = new SimpleMeterRegistry();
        this.dispatches = new ConcurrentHashMap();
        this.handlers = new ConcurrentHashMap();
        this.aggregates = new ConcurrentHashMap();
        this.noHandlerIdentifier = new HandlerStatisticsMetricIdentifier(HandlerType.Origin, "application", new MessageIdentifier("Dispatcher", this.componentName));
        if (instance != null) {
            this.logger.warn("HandlerMetricsRegistry already initialized. The new one will be the active.");
            HandlerMetricsRegistry handlerMetricsRegistry = instance;
            if (handlerMetricsRegistry != null) {
                handlerMetricsRegistry.onDisconnected();
            }
        }
        instance = this;
        this.clientSettingsService.subscribeToSettings(this);
    }

    @Override
    public void onConnectedWithSettings(@NotNull ClientSettingsV2 settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.logger.debug((Function0)new Function0<Object>(settings){
            final /* synthetic */ ClientSettingsV2 $settings;
            {
                this.$settings = $settings;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Sending handler information every " + this.$settings.getHandlerReportInterval() + "ms to AxonIQ console";
            }
        });
        this.reportTask = this.executor.scheduleAtFixedRate(() -> HandlerMetricsRegistry.onConnectedWithSettings$lambda-0(this), 0L, settings.getHandlerReportInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void onDisconnected() {
        ScheduledFuture<?> scheduledFuture = this.reportTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.reportTask = null;
    }

    /*
     * WARNING - void declaration
     */
    private final StatisticReport getStats() {
        Object object;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Timer v;
        Metric k;
        Collection<Pair> collection;
        Map.Entry entry;
        Map.Entry<Object, Object> item$iv$iv;
        Iterator<Map.Entry<Object, Object>> iterator;
        Map<Metric, Timer> $this$mapTo$iv$iv2;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Map<Metric, Timer> $this$map$iv2;
        boolean $i$f$map;
        HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier;
        double d;
        double d2;
        StatisticDistribution statisticDistribution;
        Map.Entry it;
        boolean bl;
        Collection collection2;
        void $this$mapTo$iv$iv22;
        Object $this$map$iv22 = this.handlers.entrySet();
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object t : $this$mapTo$iv$iv22) {
            Map.Entry entry2 = (Map.Entry)t;
            collection2 = destination$iv$iv2;
            bl = false;
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier2 = (HandlerStatisticsMetricIdentifier)it.getKey();
            double d3 = ((HandlerRegistryStatistics)it.getValue()).getTotalCount().count();
            double d4 = ((HandlerRegistryStatistics)it.getValue()).getFailureCount().count();
            HistogramSnapshot histogramSnapshot = ((HandlerRegistryStatistics)it.getValue()).getTotalTimer().takeSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot, (String)"it.value.totalTimer.takeSnapshot()");
            Map<Metric, Timer> map = ((HandlerRegistryStatistics)it.getValue()).getMetrics();
            statisticDistribution = ExtensionsKt.toDistribution(histogramSnapshot);
            d2 = d4;
            d = d3;
            handlerStatisticsMetricIdentifier = handlerStatisticsMetricIdentifier2;
            $i$f$map = false;
            void var19_24 = $this$map$iv2;
            destination$iv$iv = new ArrayList($this$map$iv2.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                k = (Metric)entry.getKey();
                v = (Timer)entry.getValue();
                String string = k.getFullIdentifier();
                HistogramSnapshot histogramSnapshot2 = v.takeSnapshot();
                Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot2, (String)"v.takeSnapshot()");
                collection.add(TuplesKt.to((Object)string, (Object)ExtensionsKt.toDistribution(histogramSnapshot2)));
            }
            collection = (List)destination$iv$iv;
            Map map2 = MapsKt.toMap((Iterable)collection);
            StatisticDistribution statisticDistribution2 = statisticDistribution;
            double d5 = d2;
            double d6 = d;
            HandlerStatistics handlerStatistics = new HandlerStatistics(d6, d5, statisticDistribution2, map2);
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier3 = handlerStatisticsMetricIdentifier;
            collection2.add(new HandlerStatisticsWithIdentifier(handlerStatisticsMetricIdentifier3, handlerStatistics));
        }
        $this$map$iv22 = this.dispatches;
        collection2 = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv22 = $this$filter$iv;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry3;
            it = entry3 = (Map.Entry)iterator2.next();
            bl = false;
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier4 = ((DispatcherStatisticIdentifier)it.getKey()).getHandlerInformation();
            if (!((handlerStatisticsMetricIdentifier4 != null ? handlerStatisticsMetricIdentifier4.getType() : null) == HandlerType.Origin)) continue;
            destination$iv$iv3.put(entry3.getKey(), entry3.getValue());
        }
        $this$filter$iv = destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo3 = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry4;
            it = entry4 = (Map.Entry)iterator2.next();
            object2 = destination$iv$iv3;
            bl = false;
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier5 = ((DispatcherStatisticIdentifier)it.getKey()).getHandlerInformation();
            Intrinsics.checkNotNull((Object)handlerStatisticsMetricIdentifier5);
            object2.add(new HandlerStatisticsWithIdentifier(handlerStatisticsMetricIdentifier5, new HandlerStatistics(0.0, 0.0, null, MapsKt.emptyMap())));
        }
        $this$map$iv = this.dispatches.entrySet();
        collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv3));
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object object3 : $this$mapTo$iv$iv) {
            it = (Map.Entry)object3;
            object2 = destination$iv$iv3;
            bl = false;
            object2.add(new DispatcherStatisticsWithIdentifier((DispatcherStatisticIdentifier)it.getKey(), new DispatcherStatistics(((RollingCountMeasure)it.getValue()).count())));
        }
        $this$map$iv = this.aggregates.entrySet();
        object2 = (List)destination$iv$iv3;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object object4 : $this$mapTo$iv$iv) {
            it = (Map.Entry)object4;
            object = destination$iv$iv3;
            bl = false;
            AggregateStatisticIdentifier aggregateStatisticIdentifier = (AggregateStatisticIdentifier)it.getKey();
            double d7 = ((AggregateRegistryStatistics)it.getValue()).getTotalCount().count();
            double d8 = ((AggregateRegistryStatistics)it.getValue()).getFailureCount().count();
            HistogramSnapshot histogramSnapshot = ((AggregateRegistryStatistics)it.getValue()).getTotalTimer().takeSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot, (String)"it.value.totalTimer.takeSnapshot()");
            $this$map$iv2 = ((AggregateRegistryStatistics)it.getValue()).getMetrics();
            statisticDistribution = ExtensionsKt.toDistribution(histogramSnapshot);
            d2 = d8;
            d = d7;
            handlerStatisticsMetricIdentifier = aggregateStatisticIdentifier;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList($this$map$iv2.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl3 = false;
                k = (Metric)entry.getKey();
                v = (Timer)entry.getValue();
                String string = k.getFullIdentifier();
                HistogramSnapshot histogramSnapshot3 = v.takeSnapshot();
                Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot3, (String)"v.takeSnapshot()");
                collection.add(TuplesKt.to((Object)string, (Object)ExtensionsKt.toDistribution(histogramSnapshot3)));
            }
            collection = (List)destination$iv$iv;
            Map map = MapsKt.toMap((Iterable)collection);
            StatisticDistribution statisticDistribution3 = statisticDistribution;
            double d9 = d2;
            double d10 = d;
            AggregateStatistics aggregateStatistics = new AggregateStatistics(d10, d9, statisticDistribution3, map);
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier6 = handlerStatisticsMetricIdentifier;
            object.add(new AggregateStatisticsWithIdentifier((AggregateStatisticIdentifier)handlerStatisticsMetricIdentifier6, aggregateStatistics));
        }
        object = (List)destination$iv$iv3;
        List list = object;
        Object object5 = object2;
        Collection collection3 = collection2;
        StatisticReport flow = new StatisticReport((List)collection3, (List)object5, list);
        return flow;
    }

    private final Timer createTimer(Object handler, String name) {
        return UtilsKt.createTimer((MeterRegistry)this.meterRegistry, handler + "_timer_" + name);
    }

    /*
     * WARNING - void declaration
     */
    public final void registerMessageHandled(@NotNull HandlerStatisticsMetricIdentifier handler, boolean success, long duration, @NotNull Map<Metric, Long> metrics) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        HandlerRegistryStatistics handlerStats2 = (HandlerRegistryStatistics)UtilsKt.computeIfAbsentWithRetry$default(this.handlers, handler, 0, (Function1)new Function1<HandlerStatisticsMetricIdentifier, HandlerRegistryStatistics>(this, handler){
            final /* synthetic */ HandlerMetricsRegistry this$0;
            final /* synthetic */ HandlerStatisticsMetricIdentifier $handler;
            {
                this.this$0 = $receiver;
                this.$handler = $handler;
                super(1);
            }

            @NotNull
            public final HandlerRegistryStatistics invoke(@NotNull HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier) {
                Intrinsics.checkNotNullParameter((Object)handlerStatisticsMetricIdentifier, (String)"<anonymous parameter 0>");
                return new HandlerRegistryStatistics(HandlerMetricsRegistry.access$createTimer(this.this$0, this.$handler, "total"), null, null, null, 14, null);
            }
        }, 2, null);
        handlerStats2.getTotalTimer().record(duration, TimeUnit.NANOSECONDS);
        Map $this$filter$iv = metrics;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Metric)it.getKey()).getTargetTypes().contains(MetricTargetType.HANDLER)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $i$f$filterTo2 = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            Metric metric = (Metric)$i$f$filterTo2.getKey();
            long value = ((Number)$i$f$filterTo2.getValue()).longValue();
            ((Timer)UtilsKt.computeIfAbsentWithRetry$default(handlerStats2.getMetrics(), metric, 0, (Function1)new Function1<Metric, Timer>(this, handler, metric){
                final /* synthetic */ HandlerMetricsRegistry this$0;
                final /* synthetic */ HandlerStatisticsMetricIdentifier $handler;
                final /* synthetic */ Metric $metric;
                {
                    this.this$0 = $receiver;
                    this.$handler = $handler;
                    this.$metric = $metric;
                    super(1);
                }

                @NotNull
                public final Timer invoke(@NotNull Metric it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return HandlerMetricsRegistry.access$createTimer(this.this$0, this.$handler, this.$metric.getFullIdentifier());
                }
            }, 2, null)).record(value, metric.getType().getDistributionUnit());
        }
        handlerStats2.getTotalCount().increment();
        if (!success) {
            handlerStats2.getFailureCount().increment();
        }
        if (handler.getType() == HandlerType.Aggregate) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv2;
            String string = handler.getComponent();
            Intrinsics.checkNotNull((Object)string);
            AggregateStatisticIdentifier id = new AggregateStatisticIdentifier(string);
            AggregateRegistryStatistics aggStats2 = (AggregateRegistryStatistics)UtilsKt.computeIfAbsentWithRetry$default(this.aggregates, id, 0, (Function1)new Function1<AggregateStatisticIdentifier, AggregateRegistryStatistics>(this, id){
                final /* synthetic */ HandlerMetricsRegistry this$0;
                final /* synthetic */ AggregateStatisticIdentifier $id;
                {
                    this.this$0 = $receiver;
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final AggregateRegistryStatistics invoke(@NotNull AggregateStatisticIdentifier aggregateStatisticIdentifier) {
                    Intrinsics.checkNotNullParameter((Object)aggregateStatisticIdentifier, (String)"<anonymous parameter 0>");
                    return new AggregateRegistryStatistics(HandlerMetricsRegistry.access$createTimer(this.this$0, this.$id, "total"), null, null, null, 14, null);
                }
            }, 2, null);
            Map $this$filter$iv2 = metrics;
            boolean $i$f$filter2 = false;
            Map $i$f$filterTo2 = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo3 = false;
            Iterator value = $this$filterTo$iv$iv2.entrySet().iterator();
            while (value.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = value.next();
                boolean bl = false;
                if (!((Metric)it.getKey()).getTargetTypes().contains(MetricTargetType.AGGREGATE)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv2 = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                Metric metric = (Metric)entry.getKey();
                long value2 = ((Number)entry.getValue()).longValue();
                ((Timer)UtilsKt.computeIfAbsentWithRetry$default(aggStats2.getMetrics(), metric, 0, (Function1)new Function1<Metric, Timer>(this, id, metric){
                    final /* synthetic */ HandlerMetricsRegistry this$0;
                    final /* synthetic */ AggregateStatisticIdentifier $id;
                    final /* synthetic */ Metric $metric;
                    {
                        this.this$0 = $receiver;
                        this.$id = $id;
                        this.$metric = $metric;
                        super(1);
                    }

                    @NotNull
                    public final Timer invoke(@NotNull Metric it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return HandlerMetricsRegistry.access$createTimer(this.this$0, this.$id, this.$metric.getFullIdentifier());
                    }
                }, 2, null)).record(value2, metric.getType().getDistributionUnit());
            }
            aggStats2.getTotalTimer().record(duration, TimeUnit.NANOSECONDS);
            aggStats2.getTotalCount().increment();
            if (!success) {
                aggStats2.getFailureCount().increment();
            }
        }
    }

    public final void registerMessageDispatchedDuringHandling(@NotNull DispatcherStatisticIdentifier dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        ((RollingCountMeasure)UtilsKt.computeIfAbsentWithRetry$default(this.dispatches, dispatcher, 0, registerMessageDispatchedDuringHandling.1.INSTANCE, 2, null)).increment();
    }

    public final void registerMessageDispatchedWithoutHandling(@NotNull MessageIdentifier message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((RollingCountMeasure)UtilsKt.computeIfAbsentWithRetry$default(this.dispatches, new DispatcherStatisticIdentifier(this.noHandlerIdentifier, message), 0, registerMessageDispatchedWithoutHandling.1.INSTANCE, 2, null)).increment();
    }

    private static final void onConnectedWithSettings$lambda-0(HandlerMetricsRegistry this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            StatisticReport stats = this$0.getStats();
            this$0.logger.debug("Sending metrics: {}", (Object)stats);
            this$0.axoniqConsoleRSocketClient.send("message-flow-stats", stats).block();
        }
        catch (Exception e) {
            this$0.logger.warn("No metrics could be reported to AxonIQ Console: {}", (Object)e.getMessage());
        }
    }

    public static final /* synthetic */ Timer access$createTimer(HandlerMetricsRegistry $this, Object handler, String name) {
        return $this.createTimer(handler, name);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry$Companion;", "", "()V", "instance", "Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry;", "getInstance", "console-framework-client"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HandlerMetricsRegistry getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry$HandlerRegistryStatistics;", "", "totalTimer", "Lio/micrometer/core/instrument/Timer;", "totalCount", "Lio/axoniq/console/framework/messaging/RollingCountMeasure;", "failureCount", "metrics", "", "Lio/axoniq/console/framework/api/metrics/Metric;", "(Lio/micrometer/core/instrument/Timer;Lio/axoniq/console/framework/messaging/RollingCountMeasure;Lio/axoniq/console/framework/messaging/RollingCountMeasure;Ljava/util/Map;)V", "getFailureCount", "()Lio/axoniq/console/framework/messaging/RollingCountMeasure;", "getMetrics", "()Ljava/util/Map;", "getTotalCount", "getTotalTimer", "()Lio/micrometer/core/instrument/Timer;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "console-framework-client"})
    private static final class HandlerRegistryStatistics {
        @NotNull
        private final Timer totalTimer;
        @NotNull
        private final RollingCountMeasure totalCount;
        @NotNull
        private final RollingCountMeasure failureCount;
        @NotNull
        private final Map<Metric, Timer> metrics;

        public HandlerRegistryStatistics(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            this.totalTimer = totalTimer;
            this.totalCount = totalCount;
            this.failureCount = failureCount;
            this.metrics = metrics;
        }

        public /* synthetic */ HandlerRegistryStatistics(Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                rollingCountMeasure = new RollingCountMeasure();
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = new RollingCountMeasure();
            }
            if ((n & 8) != 0) {
                map = new ConcurrentHashMap();
            }
            this(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public final Timer getTotalTimer() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure getFailureCount() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> getMetrics() {
            return this.metrics;
        }

        @NotNull
        public final Timer component1() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure component2() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure component3() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> component4() {
            return this.metrics;
        }

        @NotNull
        public final HandlerRegistryStatistics copy(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            return new HandlerRegistryStatistics(totalTimer, totalCount, failureCount, metrics);
        }

        public static /* synthetic */ HandlerRegistryStatistics copy$default(HandlerRegistryStatistics handlerRegistryStatistics, Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                timer = handlerRegistryStatistics.totalTimer;
            }
            if ((n & 2) != 0) {
                rollingCountMeasure = handlerRegistryStatistics.totalCount;
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = handlerRegistryStatistics.failureCount;
            }
            if ((n & 8) != 0) {
                map = handlerRegistryStatistics.metrics;
            }
            return handlerRegistryStatistics.copy(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public String toString() {
            return "HandlerRegistryStatistics(totalTimer=" + this.totalTimer + ", totalCount=" + this.totalCount + ", failureCount=" + this.failureCount + ", metrics=" + this.metrics + ')';
        }

        public int hashCode() {
            int result = this.totalTimer.hashCode();
            result = result * 31 + this.totalCount.hashCode();
            result = result * 31 + this.failureCount.hashCode();
            result = result * 31 + ((Object)this.metrics).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HandlerRegistryStatistics)) {
                return false;
            }
            HandlerRegistryStatistics handlerRegistryStatistics = (HandlerRegistryStatistics)other;
            if (!Intrinsics.areEqual((Object)this.totalTimer, (Object)handlerRegistryStatistics.totalTimer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.totalCount, (Object)handlerRegistryStatistics.totalCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.failureCount, (Object)handlerRegistryStatistics.failureCount)) {
                return false;
            }
            return Intrinsics.areEqual(this.metrics, handlerRegistryStatistics.metrics);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry$AggregateRegistryStatistics;", "", "totalTimer", "Lio/micrometer/core/instrument/Timer;", "totalCount", "Lio/axoniq/console/framework/messaging/RollingCountMeasure;", "failureCount", "metrics", "", "Lio/axoniq/console/framework/api/metrics/Metric;", "(Lio/micrometer/core/instrument/Timer;Lio/axoniq/console/framework/messaging/RollingCountMeasure;Lio/axoniq/console/framework/messaging/RollingCountMeasure;Ljava/util/Map;)V", "getFailureCount", "()Lio/axoniq/console/framework/messaging/RollingCountMeasure;", "getMetrics", "()Ljava/util/Map;", "getTotalCount", "getTotalTimer", "()Lio/micrometer/core/instrument/Timer;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "console-framework-client"})
    private static final class AggregateRegistryStatistics {
        @NotNull
        private final Timer totalTimer;
        @NotNull
        private final RollingCountMeasure totalCount;
        @NotNull
        private final RollingCountMeasure failureCount;
        @NotNull
        private final Map<Metric, Timer> metrics;

        public AggregateRegistryStatistics(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            this.totalTimer = totalTimer;
            this.totalCount = totalCount;
            this.failureCount = failureCount;
            this.metrics = metrics;
        }

        public /* synthetic */ AggregateRegistryStatistics(Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                rollingCountMeasure = new RollingCountMeasure();
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = new RollingCountMeasure();
            }
            if ((n & 8) != 0) {
                map = new ConcurrentHashMap();
            }
            this(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public final Timer getTotalTimer() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure getFailureCount() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> getMetrics() {
            return this.metrics;
        }

        @NotNull
        public final Timer component1() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure component2() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure component3() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> component4() {
            return this.metrics;
        }

        @NotNull
        public final AggregateRegistryStatistics copy(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            return new AggregateRegistryStatistics(totalTimer, totalCount, failureCount, metrics);
        }

        public static /* synthetic */ AggregateRegistryStatistics copy$default(AggregateRegistryStatistics aggregateRegistryStatistics, Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                timer = aggregateRegistryStatistics.totalTimer;
            }
            if ((n & 2) != 0) {
                rollingCountMeasure = aggregateRegistryStatistics.totalCount;
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = aggregateRegistryStatistics.failureCount;
            }
            if ((n & 8) != 0) {
                map = aggregateRegistryStatistics.metrics;
            }
            return aggregateRegistryStatistics.copy(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public String toString() {
            return "AggregateRegistryStatistics(totalTimer=" + this.totalTimer + ", totalCount=" + this.totalCount + ", failureCount=" + this.failureCount + ", metrics=" + this.metrics + ')';
        }

        public int hashCode() {
            int result = this.totalTimer.hashCode();
            result = result * 31 + this.totalCount.hashCode();
            result = result * 31 + this.failureCount.hashCode();
            result = result * 31 + ((Object)this.metrics).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AggregateRegistryStatistics)) {
                return false;
            }
            AggregateRegistryStatistics aggregateRegistryStatistics = (AggregateRegistryStatistics)other;
            if (!Intrinsics.areEqual((Object)this.totalTimer, (Object)aggregateRegistryStatistics.totalTimer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.totalCount, (Object)aggregateRegistryStatistics.totalCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.failureCount, (Object)aggregateRegistryStatistics.failureCount)) {
                return false;
            }
            return Intrinsics.areEqual(this.metrics, aggregateRegistryStatistics.metrics);
        }
    }
}

