/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.application;

import io.axoniq.console.framework.application.UtilsKt;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/axoniq/console/framework/application/CpuMetricsProvider;", "", "()V", "cpuLoadMethod", "Ljava/lang/reflect/Method;", "osBean", "Ljava/lang/management/OperatingSystemMXBean;", "kotlin.jvm.PlatformType", "osBeanClass", "Ljava/lang/Class;", "processCpuUsageMethod", "getProcessCpuUsage", "", "getSystemCpuUsage", "console-framework-client"})
public final class CpuMetricsProvider {
    private final OperatingSystemMXBean osBean;
    @Nullable
    private final Class<?> osBeanClass;
    @Nullable
    private final Method cpuLoadMethod;
    @Nullable
    private final Method processCpuUsageMethod;

    public CpuMetricsProvider() {
        Method method;
        GenericDeclaration genericDeclaration;
        block8: {
            block7: {
                this.osBean = ManagementFactory.getOperatingSystemMXBean();
                Object[] objectArray = new String[]{"com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean"};
                this.osBeanClass = UtilsKt.firstExistingClass(CollectionsKt.listOf((Object[])objectArray));
                genericDeclaration = this.osBeanClass;
                if (genericDeclaration == null) break block7;
                OperatingSystemMXBean operatingSystemMXBean = this.osBean;
                Intrinsics.checkNotNullExpressionValue((Object)operatingSystemMXBean, (String)"osBean");
                if ((genericDeclaration = UtilsKt.detectMethod(genericDeclaration, operatingSystemMXBean, "getCpuLoad")) != null) break block8;
            }
            Class<?> clazz = this.osBeanClass;
            if (clazz != null) {
                OperatingSystemMXBean operatingSystemMXBean = this.osBean;
                Intrinsics.checkNotNullExpressionValue((Object)operatingSystemMXBean, (String)"osBean");
                genericDeclaration = UtilsKt.detectMethod(clazz, operatingSystemMXBean, "getSystemCpuLoad");
            } else {
                genericDeclaration = null;
            }
        }
        this.cpuLoadMethod = genericDeclaration;
        Class<?> clazz = this.osBeanClass;
        if (clazz != null) {
            OperatingSystemMXBean operatingSystemMXBean = this.osBean;
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystemMXBean, (String)"osBean");
            method = UtilsKt.detectMethod(clazz, operatingSystemMXBean, "getProcessCpuLoad");
        } else {
            method = null;
        }
        this.processCpuUsageMethod = method;
    }

    public final double getSystemCpuUsage() {
        Method method = this.cpuLoadMethod;
        Double d = (Double)(method != null ? method.invoke((Object)this.osBean, new Object[0]) : null);
        return d != null ? d : -1.0;
    }

    public final double getProcessCpuUsage() {
        Method method = this.processCpuUsageMethod;
        Double d = (Double)(method != null ? method.invoke((Object)this.osBean, new Object[0]) : null);
        return d != null ? d : -1.0;
    }
}

