/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.client;

import io.axoniq.console.framework.api.ClientSettingsV2;
import io.axoniq.console.framework.api.ConsoleClientAuthentication;
import io.axoniq.console.framework.api.ConsoleClientIdentifier;
import io.axoniq.console.framework.api.notifications.Notification;
import io.axoniq.console.framework.api.notifications.NotificationLevel;
import io.axoniq.console.framework.api.notifications.NotificationList;
import io.axoniq.console.framework.client.ClientSettingsObserver;
import io.axoniq.console.framework.client.ClientSettingsService;
import io.axoniq.console.framework.client.RSocketHandlerRegistrar;
import io.axoniq.console.framework.client.SetupPayloadCreator;
import io.axoniq.console.framework.client.UtilsKt;
import io.axoniq.console.framework.client.strategy.RSocketPayloadEncodingStrategy;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.ConnectionSetupPayload;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.axonframework.lifecycle.Lifecycle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 H2\u00020\u0001:\u0002HIBm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0018J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0003H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020'J\u0006\u00100\u001a\u00020'J\b\u00101\u001a\u00020'H\u0002J\u0006\u00102\u001a\u00020\nJ\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J$\u00109\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010'0'072\u0006\u0010:\u001a\u00020;2\u0006\u0010+\u001a\u00020\u0003J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020'072\u0006\u0010+\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;J\u0006\u0010=\u001a\u00020'J\b\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u00020AH\u0002J\u0014\u0010B\u001a\u00020'*\u00020 2\u0006\u0010C\u001a\u00020DH\u0002J\u0014\u0010E\u001a\u00020'*\u00020 2\u0006\u0010F\u001a\u00020GH\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient;", "Lorg/axonframework/lifecycle/Lifecycle;", "environmentId", "", "accessToken", "applicationName", "host", "port", "", "secure", "", "initialDelay", "", "setupPayloadCreator", "Lio/axoniq/console/framework/client/SetupPayloadCreator;", "registrar", "Lio/axoniq/console/framework/client/RSocketHandlerRegistrar;", "encodingStrategy", "Lio/axoniq/console/framework/client/strategy/RSocketPayloadEncodingStrategy;", "clientSettingsService", "Lio/axoniq/console/framework/client/ClientSettingsService;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "instanceName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZJLio/axoniq/console/framework/client/SetupPayloadCreator;Lio/axoniq/console/framework/client/RSocketHandlerRegistrar;Lio/axoniq/console/framework/client/strategy/RSocketPayloadEncodingStrategy;Lio/axoniq/console/framework/client/ClientSettingsService;Ljava/util/concurrent/ScheduledExecutorService;Ljava/lang/String;)V", "connectionRetryCount", "heartbeatOrchestrator", "Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient$HeartbeatOrchestrator;", "lastConnectionTry", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "maintenanceTask", "Ljava/util/concurrent/ScheduledFuture;", "pausedReports", "rsocket", "Lio/rsocket/RSocket;", "connectSafely", "", "createRSocket", "createRoutingMetadata", "Lio/netty/buffer/CompositeByteBuf;", "route", "createSetupMetadata", "auth", "Lio/axoniq/console/framework/api/ConsoleClientAuthentication;", "disposeClient", "disposeCurrentConnection", "ensureConnected", "isConnected", "registerLifecycleHandlers", "registry", "Lorg/axonframework/lifecycle/Lifecycle$LifecycleRegistry;", "retrieveSettings", "Lreactor/core/publisher/Mono;", "Lio/axoniq/console/framework/api/ClientSettingsV2;", "sendMessage", "payload", "", "sendReport", "start", "tcpClient", "Lreactor/netty/tcp/TcpClient;", "tcpClientTransport", "Lio/rsocket/transport/netty/client/TcpClientTransport;", "log", "notificationList", "Lio/axoniq/console/framework/api/notifications/NotificationList;", "logNotification", "it", "Lio/axoniq/console/framework/api/notifications/Notification;", "Companion", "HeartbeatOrchestrator", "console-framework-client"})
@SourceDebugExtension(value={"SMAP\nAxoniqConsoleRSocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxoniqConsoleRSocketClient.kt\nio/axoniq/console/framework/client/AxoniqConsoleRSocketClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1849#2,2:337\n*S KotlinDebug\n*F\n+ 1 AxoniqConsoleRSocketClient.kt\nio/axoniq/console/framework/client/AxoniqConsoleRSocketClient\n*L\n322#1:337,2\n*E\n"})
public final class AxoniqConsoleRSocketClient
implements Lifecycle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String environmentId;
    @NotNull
    private final String accessToken;
    @NotNull
    private final String applicationName;
    @NotNull
    private final String host;
    private final int port;
    private final boolean secure;
    private final long initialDelay;
    @NotNull
    private final SetupPayloadCreator setupPayloadCreator;
    @NotNull
    private final RSocketHandlerRegistrar registrar;
    @NotNull
    private final RSocketPayloadEncodingStrategy encodingStrategy;
    @NotNull
    private final ClientSettingsService clientSettingsService;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final String instanceName;
    @NotNull
    private final HeartbeatOrchestrator heartbeatOrchestrator;
    @Nullable
    private ScheduledFuture<?> maintenanceTask;
    private final Logger logger;
    @Nullable
    private RSocket rsocket;
    private Instant lastConnectionTry;
    private int connectionRetryCount;
    private boolean pausedReports;
    private static final double BACKOFF_FACTOR = 2.0;

    public AxoniqConsoleRSocketClient(@NotNull String environmentId, @NotNull String accessToken, @NotNull String applicationName, @NotNull String host, int port, boolean secure, long initialDelay, @NotNull SetupPayloadCreator setupPayloadCreator, @NotNull RSocketHandlerRegistrar registrar, @NotNull RSocketPayloadEncodingStrategy encodingStrategy, @NotNull ClientSettingsService clientSettingsService, @NotNull ScheduledExecutorService executor, @NotNull String instanceName) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)setupPayloadCreator, (String)"setupPayloadCreator");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)encodingStrategy, (String)"encodingStrategy");
        Intrinsics.checkNotNullParameter((Object)clientSettingsService, (String)"clientSettingsService");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)instanceName, (String)"instanceName");
        this.environmentId = environmentId;
        this.accessToken = accessToken;
        this.applicationName = applicationName;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.initialDelay = initialDelay;
        this.setupPayloadCreator = setupPayloadCreator;
        this.registrar = registrar;
        this.encodingStrategy = encodingStrategy;
        this.clientSettingsService = clientSettingsService;
        this.executor = executor;
        this.instanceName = instanceName;
        this.heartbeatOrchestrator = new HeartbeatOrchestrator();
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.lastConnectionTry = Instant.EPOCH;
        this.clientSettingsService.subscribeToSettings(this.heartbeatOrchestrator);
        this.registrar.registerHandlerWithPayload("client-settings", ClientSettingsV2.class, (Function1)new Function1<ClientSettingsV2, Unit>(){

            public final void invoke(@NotNull ClientSettingsV2 it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                clientSettingsService.updateSettings(it);
            }
        });
        this.registrar.registerHandlerWithoutPayload("client-reporting-stop", (Function0<? extends Object>)((Function0)new Function0<Object>(){

            @NotNull
            public final Object invoke() {
                pausedReports = true;
                return true;
            }
        }));
        this.registrar.registerHandlerWithoutPayload("client-reporting-start", (Function0<? extends Object>)((Function0)new Function0<Object>(){

            @NotNull
            public final Object invoke() {
                pausedReports = false;
                return true;
            }
        }));
        this.registrar.registerHandlerWithPayload("client-log", Notification.class, (Function1)new Function1<Notification, Unit>(){

            public final void invoke(@NotNull Notification it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger logger2 = logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLogger$p(...)");
                this.logNotification(logger2, it);
            }
        });
    }

    public void registerLifecycleHandlers(@NotNull Lifecycle.LifecycleRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.onStart(-134217728, this::start);
        registry.onShutdown(-134217728, this::disposeClient);
    }

    @NotNull
    public final Mono<Unit> sendReport(@NotNull String route, @NotNull Object payload) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.pausedReports) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty(...)");
            return mono;
        }
        return this.sendMessage(payload, route);
    }

    @NotNull
    public final Mono<Unit> sendMessage(@NotNull Object payload, @NotNull String route) {
        Mono mono;
        Mono mono2;
        Mono mono3;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        RSocket rSocket = this.rsocket;
        Mono mono4 = mono3 = rSocket != null && (mono2 = rSocket.requestResponse(this.encodingStrategy.encode(payload, (ByteBuf)this.createRoutingMetadata(route)))) != null ? mono2.map(arg_0 -> AxoniqConsoleRSocketClient.sendMessage$lambda$0((Function1)new Function1<Payload, Unit>(this){
            final /* synthetic */ AxoniqConsoleRSocketClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Payload it) {
                RSocketPayloadEncodingStrategy rSocketPayloadEncodingStrategy = AxoniqConsoleRSocketClient.access$getEncodingStrategy$p(this.this$0);
                Intrinsics.checkNotNull((Object)it);
                NotificationList notifications = rSocketPayloadEncodingStrategy.decode(it, NotificationList.class);
                Logger logger2 = AxoniqConsoleRSocketClient.access$getLogger$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLogger$p(...)");
                AxoniqConsoleRSocketClient.access$log(this.this$0, logger2, notifications);
            }
        }, arg_0)) : null;
        if (mono3 == null) {
            Mono mono5 = Mono.empty();
            mono = mono5;
            Intrinsics.checkNotNullExpressionValue((Object)mono5, (String)"empty(...)");
        } else {
            mono = mono3;
        }
        return mono;
    }

    public final void start() {
        if (this.maintenanceTask != null) {
            return;
        }
        this.maintenanceTask = this.executor.scheduleWithFixedDelay(this::ensureConnected, this.initialDelay, 1000L, TimeUnit.MILLISECONDS);
    }

    private final void ensureConnected() {
        if (!this.isConnected()) {
            double secondsToWaitForReconnect = RangesKt.coerceAtMost((double)Math.pow(2.0, this.connectionRetryCount), (double)60.0);
            if ((double)ChronoUnit.SECONDS.between(this.lastConnectionTry, Instant.now()) < secondsToWaitForReconnect) {
                return;
            }
            ++this.connectionRetryCount;
            this.lastConnectionTry = Instant.now();
            this.logger.debug("Connecting to AxonIQ Console...");
            this.connectSafely();
        }
    }

    private final void connectSafely() {
        try {
            this.rsocket = this.createRSocket();
            ClientSettingsV2 clientSettingsV2 = (ClientSettingsV2)this.retrieveSettings().block();
            if (clientSettingsV2 == null) {
                throw new IllegalStateException("Could not receive the settings from AxonIQ console!");
            }
            ClientSettingsV2 settings = clientSettingsV2;
            this.clientSettingsService.updateSettings(settings);
            this.logger.info("Connection to AxonIQ Console set up successfully! This instance's name: " + this.instanceName + ", settings: " + settings);
            this.connectionRetryCount = 0;
        }
        catch (Exception e) {
            if (this.connectionRetryCount == 5) {
                this.logger.error("Failed to connect to AxonIQ Console. Error: " + e.getMessage() + ". Will keep trying to connect...");
            }
            this.disposeCurrentConnection();
            this.logger.debug("Failed to connect to AxonIQ Console", (Throwable)e);
        }
    }

    private final RSocket createRSocket() {
        ConsoleClientAuthentication authentication = new ConsoleClientAuthentication(new ConsoleClientIdentifier(this.environmentId, this.applicationName, this.instanceName), this.accessToken);
        Payload setupPayload = this.encodingStrategy.encode(this.setupPayloadCreator.createReport(), (ByteBuf)this.createSetupMetadata(authentication));
        Object object = RSocketConnector.create().metadataMimeType(WellKnownMimeType.MESSAGE_RSOCKET_COMPOSITE_METADATA.getString()).dataMimeType(this.encodingStrategy.getMimeType().getString()).setupPayload(setupPayload).acceptor((arg_0, arg_1) -> AxoniqConsoleRSocketClient.createRSocket$lambda$1(this, arg_0, arg_1)).connect((ClientTransport)this.tcpClientTransport()).block();
        Intrinsics.checkNotNull((Object)object);
        RSocket rsocket = (RSocket)object;
        return rsocket;
    }

    private final CompositeByteBuf createRoutingMetadata(String route) {
        CompositeByteBuf compositeByteBuf = ByteBufAllocator.DEFAULT.compositeBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)compositeByteBuf, (String)"compositeBuffer(...)");
        CompositeByteBuf metadata = compositeByteBuf;
        UtilsKt.addRouteMetadata(metadata, route);
        return metadata;
    }

    private final CompositeByteBuf createSetupMetadata(ConsoleClientAuthentication auth) {
        CompositeByteBuf compositeByteBuf = ByteBufAllocator.DEFAULT.compositeBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)compositeByteBuf, (String)"compositeBuffer(...)");
        CompositeByteBuf metadata = compositeByteBuf;
        UtilsKt.addRouteMetadata(metadata, "client");
        UtilsKt.addAuthMetadata(metadata, auth);
        return metadata;
    }

    private final TcpClientTransport tcpClientTransport() {
        TcpClientTransport tcpClientTransport = TcpClientTransport.create((TcpClient)this.tcpClient());
        Intrinsics.checkNotNullExpressionValue((Object)tcpClientTransport, (String)"create(...)");
        return tcpClientTransport;
    }

    private final TcpClient tcpClient() {
        TcpClient tcpClient2 = TcpClient.create().host(this.host).port(this.port).doOnDisconnected(arg_0 -> AxoniqConsoleRSocketClient.tcpClient$lambda$2((Function1)new Function1<Connection, Unit>(this){
            final /* synthetic */ AxoniqConsoleRSocketClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Connection it) {
                this.this$0.disposeCurrentConnection();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)tcpClient2, (String)"doOnDisconnected(...)");
        TcpClient client2 = tcpClient2;
        if (this.secure) {
            TcpClient tcpClient3 = client2.secure();
            Intrinsics.checkNotNullExpressionValue((Object)tcpClient3, (String)"secure(...)");
            return tcpClient3;
        }
        return client2;
    }

    public final boolean isConnected() {
        return this.rsocket != null;
    }

    public final void disposeCurrentConnection() {
        RSocket rSocket = this.rsocket;
        if (rSocket != null) {
            rSocket.dispose();
        }
        this.rsocket = null;
        this.clientSettingsService.clearSettings();
    }

    public final void disposeClient() {
        this.disposeCurrentConnection();
        ScheduledFuture<?> scheduledFuture = this.maintenanceTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.maintenanceTask = null;
    }

    private final Mono<ClientSettingsV2> retrieveSettings() {
        RSocket rSocket = this.rsocket;
        Intrinsics.checkNotNull((Object)rSocket);
        Mono mono = rSocket.requestResponse(this.encodingStrategy.encode("", (ByteBuf)this.createRoutingMetadata("client-settings-v2"))).map(arg_0 -> AxoniqConsoleRSocketClient.retrieveSettings$lambda$3((Function1)new Function1<Payload, ClientSettingsV2>(this){
            final /* synthetic */ AxoniqConsoleRSocketClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ClientSettingsV2 invoke(Payload it) {
                RSocketPayloadEncodingStrategy rSocketPayloadEncodingStrategy = AxoniqConsoleRSocketClient.access$getEncodingStrategy$p(this.this$0);
                Intrinsics.checkNotNull((Object)it);
                return rSocketPayloadEncodingStrategy.decode(it, ClientSettingsV2.class);
            }
        }, arg_0)).doOnError(arg_0 -> AxoniqConsoleRSocketClient.retrieveSettings$lambda$4((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ AxoniqConsoleRSocketClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Throwable it) {
                String string = it.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Access Denied", (boolean)false, (int)2, null) : false;
                if (bl) {
                    AxoniqConsoleRSocketClient.access$getLogger$p(this.this$0).error("Was unable to send call to AxonIQ Console since authentication was incorrect!");
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    private final void log(Logger $this$log, NotificationList notificationList) {
        Iterable $this$forEach$iv = notificationList.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Notification it = (Notification)element$iv;
            boolean bl = false;
            this.logNotification($this$log, it);
        }
    }

    private final void logNotification(Logger $this$logNotification, Notification it) {
        String text = it.getMessage();
        switch (WhenMappings.$EnumSwitchMapping$0[it.getLevel().ordinal()]) {
            case 1: {
                $this$logNotification.debug(text);
                break;
            }
            case 2: {
                $this$logNotification.info(text);
                break;
            }
            case 3: {
                $this$logNotification.warn(text);
            }
        }
    }

    private static final Unit sendMessage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Mono createRSocket$lambda$1(AxoniqConsoleRSocketClient this$0, ConnectionSetupPayload connectionSetupPayload, RSocket rsocket) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)connectionSetupPayload, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)rsocket, (String)"rsocket");
        return Mono.just((Object)this$0.registrar.createRespondingRSocketFor(rsocket));
    }

    private static final void tcpClient$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final ClientSettingsV2 retrieveSettings$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ClientSettingsV2)$tmp0.invoke(p0);
    }

    private static final void retrieveSettings$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$log(AxoniqConsoleRSocketClient $this, Logger $receiver, NotificationList notificationList) {
        $this.log($receiver, notificationList);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient$Companion;", "", "()V", "BACKOFF_FACTOR", "", "console-framework-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient$HeartbeatOrchestrator;", "Lio/axoniq/console/framework/client/ClientSettingsObserver;", "(Lio/axoniq/console/framework/client/AxoniqConsoleRSocketClient;)V", "heartbeatCheckTask", "Ljava/util/concurrent/ScheduledFuture;", "heartbeatSendTask", "lastReceivedHeartbeat", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "checkHeartbeats", "", "heartbeatTimeout", "", "onConnectedWithSettings", "settings", "Lio/axoniq/console/framework/api/ClientSettingsV2;", "onDisconnected", "sendHeartbeat", "Lreactor/core/publisher/Mono;", "Lio/rsocket/Payload;", "console-framework-client"})
    private final class HeartbeatOrchestrator
    implements ClientSettingsObserver {
        @Nullable
        private ScheduledFuture<?> heartbeatSendTask;
        @Nullable
        private ScheduledFuture<?> heartbeatCheckTask;
        private Instant lastReceivedHeartbeat = Instant.now();

        public HeartbeatOrchestrator() {
            AxoniqConsoleRSocketClient.this.registrar.registerHandlerWithoutPayload("client-heartbeat", (Function0<? extends Object>)((Function0)new Function0<Object>(){

                @NotNull
                public final Object invoke() {
                    AxoniqConsoleRSocketClient.this.logger.debug("Received heartbeat from AxonIQ Console. Last one was: {}", (Object)lastReceivedHeartbeat);
                    lastReceivedHeartbeat = Instant.now();
                    Instant instant = lastReceivedHeartbeat;
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"access$getLastReceivedHeartbeat$p(...)");
                    return instant;
                }
            }));
        }

        @Override
        public void onConnectedWithSettings(@NotNull ClientSettingsV2 settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.lastReceivedHeartbeat = Instant.now();
            this.heartbeatSendTask = AxoniqConsoleRSocketClient.this.executor.scheduleWithFixedDelay(() -> HeartbeatOrchestrator.onConnectedWithSettings$lambda$0(this), 0L, settings.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
            this.heartbeatCheckTask = AxoniqConsoleRSocketClient.this.executor.scheduleWithFixedDelay(() -> HeartbeatOrchestrator.onConnectedWithSettings$lambda$1(this, settings), 0L, 1000L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void onDisconnected() {
            block1: {
                AxoniqConsoleRSocketClient.this.logger.info("This application has lost it's connection to AxonIQ Console. Reconnection will be automatically attempted.");
                ScheduledFuture<?> scheduledFuture = this.heartbeatSendTask;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(true);
                }
                ScheduledFuture<?> scheduledFuture2 = this.heartbeatCheckTask;
                if (scheduledFuture2 == null) break block1;
                scheduledFuture2.cancel(true);
            }
        }

        private final void checkHeartbeats(long heartbeatTimeout) {
            if (this.lastReceivedHeartbeat.compareTo(Instant.now().minusMillis(heartbeatTimeout)) < 0) {
                AxoniqConsoleRSocketClient.this.logger.debug("Haven't received a heartbeat for {} seconds from AxonIQ Console. Reconnecting...", (Object)ChronoUnit.SECONDS.between(this.lastReceivedHeartbeat, Instant.now()));
                AxoniqConsoleRSocketClient.this.disposeCurrentConnection();
            }
        }

        private final Mono<Payload> sendHeartbeat() {
            Mono mono;
            Mono mono2;
            Mono mono3;
            RSocket rSocket = AxoniqConsoleRSocketClient.this.rsocket;
            Mono mono4 = mono3 = rSocket != null && (mono2 = rSocket.requestResponse(AxoniqConsoleRSocketClient.this.encodingStrategy.encode("", (ByteBuf)AxoniqConsoleRSocketClient.this.createRoutingMetadata("client-heartbeat")))) != null ? mono2.doOnSuccess(arg_0 -> HeartbeatOrchestrator.sendHeartbeat$lambda$2((Function1)new Function1<Payload, Unit>(AxoniqConsoleRSocketClient.this){
                final /* synthetic */ AxoniqConsoleRSocketClient this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Payload it) {
                    AxoniqConsoleRSocketClient.access$getLogger$p(this.this$0).debug("Heartbeat successfully sent to AxonIQ Console");
                }
            }, arg_0)) : null;
            if (mono3 == null) {
                Mono mono5 = Mono.empty();
                mono = mono5;
                Intrinsics.checkNotNullExpressionValue((Object)mono5, (String)"empty(...)");
            } else {
                mono = mono3;
            }
            return mono;
        }

        private static final void onConnectedWithSettings$lambda$0(HeartbeatOrchestrator this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.sendHeartbeat().subscribe();
        }

        private static final void onConnectedWithSettings$lambda$1(HeartbeatOrchestrator this$0, ClientSettingsV2 $settings) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
            this$0.checkHeartbeats($settings.getHeartbeatTimeout());
        }

        private static final void sendHeartbeat$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationLevel.values().length];
            try {
                nArray[NotificationLevel.Debug.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationLevel.Info.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationLevel.Warn.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

