/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.client.strategy;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import io.axoniq.console.framework.client.strategy.RSocketPayloadEncodingStrategy;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.Payload;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.util.DefaultPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/axoniq/console/framework/client/strategy/CborEncodingStrategy;", "Lio/axoniq/console/framework/client/strategy/RSocketPayloadEncodingStrategy;", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "decode", "T", "payload", "Lio/rsocket/Payload;", "expectedType", "Ljava/lang/Class;", "(Lio/rsocket/Payload;Ljava/lang/Class;)Ljava/lang/Object;", "encode", "", "metadata", "Lio/netty/buffer/ByteBuf;", "getMimeType", "Lio/rsocket/metadata/WellKnownMimeType;", "console-framework-client"})
public final class CborEncodingStrategy
implements RSocketPayloadEncodingStrategy {
    private final ObjectMapper mapper = ((CBORMapper)CBORMapper.builder().build()).findAndRegisterModules().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Override
    @NotNull
    public WellKnownMimeType getMimeType() {
        return WellKnownMimeType.APPLICATION_CBOR;
    }

    @Override
    @NotNull
    public Payload encode(@NotNull Object payload, @Nullable ByteBuf metadata) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        CompositeByteBuf compositeByteBuf = ByteBufAllocator.DEFAULT.compositeBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)compositeByteBuf, (String)"compositeBuffer(...)");
        CompositeByteBuf payloadBuffer = compositeByteBuf;
        payloadBuffer.writeBytes(this.mapper.writeValueAsBytes(payload));
        Payload payload2 = DefaultPayload.create((ByteBuf)((ByteBuf)payloadBuffer), (ByteBuf)metadata);
        Intrinsics.checkNotNullExpressionValue((Object)payload2, (String)"create(...)");
        return payload2;
    }

    @Override
    public <T> T decode(@NotNull Payload payload, @NotNull Class<T> expectedType) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        if (Intrinsics.areEqual(expectedType, String.class)) {
            return (T)payload.getDataUtf8();
        }
        return (T)this.mapper.readValue(payload.getData().array(), expectedType);
    }
}

