/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.eventprocessor;

import io.axoniq.console.framework.AxoniqConsoleDlqMode;
import io.axoniq.console.framework.api.DeadLetter;
import io.axoniq.console.framework.eventprocessor.DeadLetterManager;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.SequencedDeadLetterProcessor;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.serialization.Serializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ8\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t0\t2\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nJ\u001a\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u0010\u001a\u00020\nH\u0002JD\u0010\u001c\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u001b0\u001b \u001e*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u001b0\u001b\u0018\u00010\u001d0\u001d2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nJ$\u0010!\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0012\u0010\"\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001b0#H\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ$\u0010&\u001a\u00020\u000f2\u0012\u0010\"\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001b0#2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0014\u0010'\u001a\n \u001e*\u0004\u0018\u00010(0(*\u00020(H\u0002J\f\u0010)\u001a\u00020\n*\u00020\nH\u0002J\u0018\u0010*\u001a\u00020\n*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001b0#H\u0002J \u0010+\u001a\u00020\u000f*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001b0#2\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/axoniq/console/framework/eventprocessor/DeadLetterManager;", "", "eventProcessingConfig", "Lorg/axonframework/config/EventProcessingConfiguration;", "eventSerializer", "Lorg/axonframework/serialization/Serializer;", "dlqMode", "Lio/axoniq/console/framework/AxoniqConsoleDlqMode;", "dlqDiagnosticsWhitelist", "", "", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lorg/axonframework/config/EventProcessingConfiguration;Lorg/axonframework/serialization/Serializer;Lio/axoniq/console/framework/AxoniqConsoleDlqMode;Ljava/util/List;Ljava/util/concurrent/ExecutorService;)V", "deadLetters", "Lio/axoniq/console/framework/api/DeadLetter;", "processingGroup", "offset", "", "size", "maxSequenceLetters", "delete", "", "sequenceIdentifier", "messageIdentifier", "dlqFor", "Lorg/axonframework/messaging/deadletter/SequencedDeadLetterQueue;", "Lorg/axonframework/eventhandling/EventMessage;", "letterProcessorFor", "Lorg/axonframework/messaging/deadletter/SequencedDeadLetterProcessor;", "kotlin.jvm.PlatformType", "process", "", "sequenceIdentifierFor", "letter", "Lorg/axonframework/messaging/deadletter/DeadLetter;", "sequenceSize", "", "toDeadLetter", "filtered", "Lorg/axonframework/messaging/MetaData;", "hashIfNeeded", "serializePayload", "toApiLetter", "console-framework-client"})
@SourceDebugExtension(value={"SMAP\nDeadLetterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeadLetterManager.kt\nio/axoniq/console/framework/eventprocessor/DeadLetterManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,191:1\n1547#2:192\n1618#2,2:193\n1547#2:195\n1618#2,3:196\n1620#2:199\n1849#2,2:200\n221#2,2:202\n1#3:204\n37#4:205\n36#4,3:206\n*S KotlinDebug\n*F\n+ 1 DeadLetterManager.kt\nio/axoniq/console/framework/eventprocessor/DeadLetterManager\n*L\n57#1:192\n57#1:193,2\n61#1:195\n61#1:196,3\n57#1:199\n138#1:200,2\n148#1:202,2\n189#1:205\n189#1:206,3\n*E\n"})
public final class DeadLetterManager {
    @NotNull
    private final EventProcessingConfiguration eventProcessingConfig;
    @NotNull
    private final Serializer eventSerializer;
    @NotNull
    private final AxoniqConsoleDlqMode dlqMode;
    @NotNull
    private final List<String> dlqDiagnosticsWhitelist;
    @NotNull
    private final ExecutorService executor;

    public DeadLetterManager(@NotNull EventProcessingConfiguration eventProcessingConfig, @NotNull Serializer eventSerializer, @NotNull AxoniqConsoleDlqMode dlqMode, @NotNull List<String> dlqDiagnosticsWhitelist, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)eventProcessingConfig, (String)"eventProcessingConfig");
        Intrinsics.checkNotNullParameter((Object)eventSerializer, (String)"eventSerializer");
        Intrinsics.checkNotNullParameter((Object)((Object)dlqMode), (String)"dlqMode");
        Intrinsics.checkNotNullParameter(dlqDiagnosticsWhitelist, (String)"dlqDiagnosticsWhitelist");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.eventProcessingConfig = eventProcessingConfig;
        this.eventSerializer = eventSerializer;
        this.dlqMode = dlqMode;
        this.dlqDiagnosticsWhitelist = dlqDiagnosticsWhitelist;
        this.executor = executor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<DeadLetter>> deadLetters(@NotNull String processingGroup, int offset, int size, int maxSequenceLetters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)processingGroup, (String)"processingGroup");
        if (this.dlqMode == AxoniqConsoleDlqMode.NONE) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = this.dlqFor(processingGroup).deadLetters();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"deadLetters(...)");
        Iterable iterable2 = CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)iterable, (int)offset), (int)size);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void sequence;
            Iterable iterable3 = (Iterable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)sequence);
            Iterable iterable4 = CollectionsKt.take((Iterable)sequence, (int)maxSequenceLetters);
            boolean $i$f$map2 = false;
            void var16_16 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                org.axonframework.messaging.deadletter.DeadLetter deadLetter = (org.axonframework.messaging.deadletter.DeadLetter)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection2.add(this.toDeadLetter((org.axonframework.messaging.deadletter.DeadLetter<? extends EventMessage<?>>)it, processingGroup));
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List deadLetters$default(DeadLetterManager deadLetterManager, String string, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 25;
        }
        if ((n4 & 8) != 0) {
            n3 = 10;
        }
        return deadLetterManager.deadLetters(string, n, n2, n3);
    }

    private final DeadLetter toDeadLetter(org.axonframework.messaging.deadletter.DeadLetter<? extends EventMessage<?>> letter, String processingGroup) {
        return this.toApiLetter(letter, this.sequenceIdentifierFor(processingGroup, letter));
    }

    private final DeadLetter toApiLetter(org.axonframework.messaging.deadletter.DeadLetter<? extends EventMessage<?>> $this$toApiLetter, String sequenceIdentifier) {
        if (this.dlqMode == AxoniqConsoleDlqMode.MASKED) {
            String string = ((EventMessage)$this$toApiLetter.message()).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
            String string2 = ((EventMessage)$this$toApiLetter.message()).getPayloadType().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
            String string3 = $this$toApiLetter.cause().map(arg_0 -> DeadLetterManager.toApiLetter$lambda$2(toApiLetter.1.INSTANCE, arg_0)).orElse(null);
            String string4 = $this$toApiLetter.cause().map(arg_0 -> DeadLetterManager.toApiLetter$lambda$3(toApiLetter.2.INSTANCE, arg_0)).orElse(null);
            Instant instant = $this$toApiLetter.enqueuedAt();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"enqueuedAt(...)");
            Instant instant2 = $this$toApiLetter.lastTouched();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"lastTouched(...)");
            MetaData metaData = MetaData.emptyInstance();
            Intrinsics.checkNotNullExpressionValue((Object)metaData, (String)"emptyInstance(...)");
            return new DeadLetter(string, "<MASKED>", string2, string3, string4, instant, instant2, (Map)metaData, this.hashIfNeeded(sequenceIdentifier));
        }
        if (this.dlqMode == AxoniqConsoleDlqMode.LIMITED) {
            String string = ((EventMessage)$this$toApiLetter.message()).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
            String string5 = ((EventMessage)$this$toApiLetter.message()).getPayloadType().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getSimpleName(...)");
            String string6 = $this$toApiLetter.cause().map(arg_0 -> DeadLetterManager.toApiLetter$lambda$4(toApiLetter.3.INSTANCE, arg_0)).orElse(null);
            String string7 = $this$toApiLetter.cause().map(arg_0 -> DeadLetterManager.toApiLetter$lambda$5(toApiLetter.4.INSTANCE, arg_0)).orElse(null);
            Instant instant = $this$toApiLetter.enqueuedAt();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"enqueuedAt(...)");
            Instant instant3 = $this$toApiLetter.lastTouched();
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"lastTouched(...)");
            MetaData metaData = $this$toApiLetter.diagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)metaData, (String)"diagnostics(...)");
            MetaData metaData2 = this.filtered(metaData);
            Intrinsics.checkNotNullExpressionValue((Object)metaData2, (String)"filtered(...)");
            return new DeadLetter(string, "<LIMITED>", string5, string6, string7, instant, instant3, (Map)metaData2, sequenceIdentifier);
        }
        String string = ((EventMessage)$this$toApiLetter.message()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        String string8 = this.serializePayload($this$toApiLetter);
        String string9 = ((EventMessage)$this$toApiLetter.message()).getPayloadType().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getSimpleName(...)");
        String string10 = $this$toApiLetter.cause().map(arg_0 -> DeadLetterManager.toApiLetter$lambda$6(toApiLetter.5.INSTANCE, arg_0)).orElse(null);
        String string11 = $this$toApiLetter.cause().map(arg_0 -> DeadLetterManager.toApiLetter$lambda$7(toApiLetter.6.INSTANCE, arg_0)).orElse(null);
        Instant instant = $this$toApiLetter.enqueuedAt();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"enqueuedAt(...)");
        Instant instant4 = $this$toApiLetter.lastTouched();
        Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"lastTouched(...)");
        MetaData metaData = $this$toApiLetter.diagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)metaData, (String)"diagnostics(...)");
        return new DeadLetter(string, string8, string9, string10, string11, instant, instant4, (Map)metaData, sequenceIdentifier);
    }

    private final String serializePayload(org.axonframework.messaging.deadletter.DeadLetter<? extends EventMessage<?>> $this$serializePayload) {
        String string;
        try {
            string = (String)this.eventSerializer.serialize(((EventMessage)$this$serializePayload.message()).getPayload(), String.class).getData();
        }
        catch (Exception _) {
            string = ((EventMessage)$this$serializePayload.message()).getPayload().toString();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return StringsKt.take((String)string2, (int)1024);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String sequenceIdentifierFor(String processingGroup, org.axonframework.messaging.deadletter.DeadLetter<? extends EventMessage<?>> letter) {
        String string;
        Object object = this.eventProcessingConfig.sequencingPolicy(processingGroup).getSequenceIdentifierFor((Object)letter.message());
        if (object != null) {
            Object it = object;
            boolean bl = false;
            String string2 = it instanceof String ? (String)it : String.valueOf(it.hashCode());
            if (string2 != null) {
                string = string2;
                return string;
            }
        }
        String string3 = ((EventMessage)letter.message()).getIdentifier();
        string = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
        return string;
    }

    public final long sequenceSize(@NotNull String processingGroup, @NotNull String sequenceIdentifier) {
        Intrinsics.checkNotNullParameter((Object)processingGroup, (String)"processingGroup");
        Intrinsics.checkNotNullParameter((Object)sequenceIdentifier, (String)"sequenceIdentifier");
        return this.dlqFor(processingGroup).sequenceSize((Object)sequenceIdentifier);
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(@NotNull String processingGroup, @NotNull String sequenceIdentifier) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)processingGroup, (String)"processingGroup");
        Intrinsics.checkNotNullParameter((Object)sequenceIdentifier, (String)"sequenceIdentifier");
        SequencedDeadLetterQueue<EventMessage<?>> dlq = this.dlqFor(processingGroup);
        Iterable iterable = dlq.deadLetterSequence((Object)sequenceIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"deadLetterSequence(...)");
        Iterable iterable2 = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            org.axonframework.messaging.deadletter.DeadLetter it = (org.axonframework.messaging.deadletter.DeadLetter)element$iv;
            boolean bl = false;
            dlq.evict(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(@NotNull String processingGroup, @NotNull String sequenceIdentifier, @NotNull String messageIdentifier) {
        Object element$iv2;
        SequencedDeadLetterQueue<EventMessage<?>> dlq;
        block1: {
            void $this$first$iv;
            Intrinsics.checkNotNullParameter((Object)processingGroup, (String)"processingGroup");
            Intrinsics.checkNotNullParameter((Object)sequenceIdentifier, (String)"sequenceIdentifier");
            Intrinsics.checkNotNullParameter((Object)messageIdentifier, (String)"messageIdentifier");
            dlq = this.dlqFor(processingGroup);
            Iterable iterable = dlq.deadLetterSequence((Object)sequenceIdentifier);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"deadLetterSequence(...)");
            Iterable iterable2 = iterable;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                org.axonframework.messaging.deadletter.DeadLetter it = (org.axonframework.messaging.deadletter.DeadLetter)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((EventMessage)it.message()).getIdentifier(), (Object)messageIdentifier)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        org.axonframework.messaging.deadletter.DeadLetter it = (org.axonframework.messaging.deadletter.DeadLetter)element$iv2;
        boolean bl = false;
        dlq.evict(it);
    }

    private final SequencedDeadLetterQueue<EventMessage<?>> dlqFor(String processingGroup) {
        Object t = this.eventProcessingConfig.deadLetterQueue(processingGroup).orElseThrow(() -> DeadLetterManager.dlqFor$lambda$12(processingGroup));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (SequencedDeadLetterQueue)t;
    }

    public final boolean process(@NotNull String processingGroup, @NotNull String messageIdentifier) {
        Intrinsics.checkNotNullParameter((Object)processingGroup, (String)"processingGroup");
        Intrinsics.checkNotNullParameter((Object)messageIdentifier, (String)"messageIdentifier");
        Boolean bl = this.executor.submit(() -> DeadLetterManager.process$lambda$14(this, processingGroup, messageIdentifier)).get(60L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        return bl;
    }

    private final String hashIfNeeded(String $this$hashIfNeeded) {
        String string;
        if (this.dlqMode == AxoniqConsoleDlqMode.MASKED) {
            String string2 = DigestUtils.sha256Hex((String)$this$hashIfNeeded);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = $this$hashIfNeeded;
        }
        return string;
    }

    private final SequencedDeadLetterProcessor<EventMessage<?>> letterProcessorFor(String processingGroup) {
        return (SequencedDeadLetterProcessor)this.eventProcessingConfig.sequencedDeadLetterProcessor(processingGroup).orElseThrow(() -> DeadLetterManager.letterProcessorFor$lambda$15(processingGroup));
    }

    private final MetaData filtered(MetaData $this$filtered) {
        Collection $this$toTypedArray$iv = this.dlqDiagnosticsWhitelist;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        return $this$filtered.subset(Arrays.copyOf(stringArray2, stringArray2.length));
    }

    private static final String toApiLetter$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String toApiLetter$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String toApiLetter$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String toApiLetter$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String toApiLetter$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String toApiLetter$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final IllegalArgumentException dlqFor$lambda$12(String $processingGroup) {
        Intrinsics.checkNotNullParameter((Object)$processingGroup, (String)"$processingGroup");
        return new IllegalArgumentException("There's no dead-letter queue configured for Processing Group [" + $processingGroup + "]!");
    }

    private static final boolean process$lambda$14$lambda$13(DeadLetterManager this$0, String $messageIdentifier, org.axonframework.messaging.deadletter.DeadLetter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$messageIdentifier, (String)"$messageIdentifier");
        String string = ((EventMessage)it.message()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        return Intrinsics.areEqual((Object)this$0.hashIfNeeded(string), (Object)$messageIdentifier);
    }

    private static final Boolean process$lambda$14(DeadLetterManager this$0, String $processingGroup, String $messageIdentifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingGroup, (String)"$processingGroup");
        Intrinsics.checkNotNullParameter((Object)$messageIdentifier, (String)"$messageIdentifier");
        return this$0.letterProcessorFor($processingGroup).process(arg_0 -> DeadLetterManager.process$lambda$14$lambda$13(this$0, $messageIdentifier, arg_0));
    }

    private static final IllegalArgumentException letterProcessorFor$lambda$15(String $processingGroup) {
        Intrinsics.checkNotNullParameter((Object)$processingGroup, (String)"$processingGroup");
        return new IllegalArgumentException("There's no dead-letter queue configured for Processing Group [" + $processingGroup + "]!");
    }
}

