/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.eventprocessor;

import io.axoniq.console.framework.api.DeadLetterProcessRequest;
import io.axoniq.console.framework.api.DeadLetterRequest;
import io.axoniq.console.framework.api.DeadLetterResponse;
import io.axoniq.console.framework.api.DeadLetterSequenceDeleteRequest;
import io.axoniq.console.framework.api.DeadLetterSequenceSize;
import io.axoniq.console.framework.api.DeadLetterSingleDeleteRequest;
import io.axoniq.console.framework.client.RSocketHandlerRegistrar;
import io.axoniq.console.framework.eventprocessor.DeadLetterManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.lifecycle.Lifecycle;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/axoniq/console/framework/eventprocessor/RSocketDlqResponder;", "Lorg/axonframework/lifecycle/Lifecycle;", "deadLetterManager", "Lio/axoniq/console/framework/eventprocessor/DeadLetterManager;", "registrar", "Lio/axoniq/console/framework/client/RSocketHandlerRegistrar;", "(Lio/axoniq/console/framework/eventprocessor/DeadLetterManager;Lio/axoniq/console/framework/client/RSocketHandlerRegistrar;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handleDeadLetterQuery", "Lio/axoniq/console/framework/api/DeadLetterResponse;", "request", "Lio/axoniq/console/framework/api/DeadLetterRequest;", "handleDeleteLetterCommand", "", "Lio/axoniq/console/framework/api/DeadLetterSingleDeleteRequest;", "handleDeleteSequenceCommand", "Lio/axoniq/console/framework/api/DeadLetterSequenceDeleteRequest;", "handleProcessCommand", "", "Lio/axoniq/console/framework/api/DeadLetterProcessRequest;", "handleSequenceSizeQuery", "", "Lio/axoniq/console/framework/api/DeadLetterSequenceSize;", "registerLifecycleHandlers", "registry", "Lorg/axonframework/lifecycle/Lifecycle$LifecycleRegistry;", "start", "console-framework-client"})
public class RSocketDlqResponder
implements Lifecycle {
    @NotNull
    private final DeadLetterManager deadLetterManager;
    @NotNull
    private final RSocketHandlerRegistrar registrar;
    private final Logger logger;

    public RSocketDlqResponder(@NotNull DeadLetterManager deadLetterManager, @NotNull RSocketHandlerRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)deadLetterManager, (String)"deadLetterManager");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        this.deadLetterManager = deadLetterManager;
        this.registrar = registrar;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void registerLifecycleHandlers(@NotNull Lifecycle.LifecycleRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.onStart(-134217728, this::start);
    }

    public final void start() {
        this.registrar.registerHandlerWithPayload("dlq-query-dead-letters", DeadLetterRequest.class, (Function1)new Function1<DeadLetterRequest, DeadLetterResponse>((Object)this){

            @NotNull
            public final DeadLetterResponse invoke(@NotNull DeadLetterRequest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketDlqResponder.access$handleDeadLetterQuery((RSocketDlqResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("dlq-query-dead-letter-sequence-size", DeadLetterSequenceSize.class, (Function1)new Function1<DeadLetterSequenceSize, Long>((Object)this){

            @NotNull
            public final Long invoke(@NotNull DeadLetterSequenceSize p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketDlqResponder.access$handleSequenceSizeQuery((RSocketDlqResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("dlq-command-delete-sequence", DeadLetterSequenceDeleteRequest.class, (Function1)new Function1<DeadLetterSequenceDeleteRequest, Unit>((Object)this){

            public final void invoke(@NotNull DeadLetterSequenceDeleteRequest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketDlqResponder.access$handleDeleteSequenceCommand((RSocketDlqResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("dlq-command-delete-letter", DeadLetterSingleDeleteRequest.class, (Function1)new Function1<DeadLetterSingleDeleteRequest, Unit>((Object)this){

            public final void invoke(@NotNull DeadLetterSingleDeleteRequest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketDlqResponder.access$handleDeleteLetterCommand((RSocketDlqResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("dlq-command-process", DeadLetterProcessRequest.class, (Function1)new Function1<DeadLetterProcessRequest, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull DeadLetterProcessRequest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketDlqResponder.access$handleProcessCommand((RSocketDlqResponder)this.receiver, p0);
            }
        });
    }

    private final DeadLetterResponse handleDeadLetterQuery(DeadLetterRequest request) {
        this.logger.debug("Handling AxonIQ Console DEAD_LETTERS query for request [{}]", (Object)request);
        return new DeadLetterResponse(DeadLetterManager.deadLetters$default(this.deadLetterManager, request.getProcessingGroup(), request.getOffset(), request.getSize(), 0, 8, null));
    }

    private final long handleSequenceSizeQuery(DeadLetterSequenceSize request) {
        this.logger.debug("Handling AxonIQ Console DEAD_LETTER_SEQUENCE_SIZE query for processing group [{}]", (Object)request.getProcessingGroup());
        return this.deadLetterManager.sequenceSize(request.getProcessingGroup(), request.getSequenceIdentifier());
    }

    private final void handleDeleteSequenceCommand(DeadLetterSequenceDeleteRequest request) {
        this.logger.debug("Handling AxonIQ Console DELETE_FULL_DEAD_LETTER_SEQUENCE command for processing group [{}]", (Object)request.getProcessingGroup());
        this.deadLetterManager.delete(request.getProcessingGroup(), request.getSequenceIdentifier());
    }

    private final void handleDeleteLetterCommand(DeadLetterSingleDeleteRequest request) {
        this.logger.debug("Handling AxonIQ Console DELETE_DEAD_LETTER_IN_SEQUENCE command for processing group [{}]", (Object)request.getProcessingGroup());
        this.deadLetterManager.delete(request.getProcessingGroup(), request.getSequenceIdentifier(), request.getMessageIdentifier());
    }

    private final boolean handleProcessCommand(DeadLetterProcessRequest request) {
        this.logger.debug("Handling AxonIQ Console DEAD LETTERS query for processing group [{}]", (Object)request.getProcessingGroup());
        return this.deadLetterManager.process(request.getProcessingGroup(), request.getMessageIdentifier());
    }

    public static final /* synthetic */ DeadLetterResponse access$handleDeadLetterQuery(RSocketDlqResponder $this, DeadLetterRequest request) {
        return $this.handleDeadLetterQuery(request);
    }

    public static final /* synthetic */ long access$handleSequenceSizeQuery(RSocketDlqResponder $this, DeadLetterSequenceSize request) {
        return $this.handleSequenceSizeQuery(request);
    }

    public static final /* synthetic */ void access$handleDeleteSequenceCommand(RSocketDlqResponder $this, DeadLetterSequenceDeleteRequest request) {
        $this.handleDeleteSequenceCommand(request);
    }

    public static final /* synthetic */ void access$handleDeleteLetterCommand(RSocketDlqResponder $this, DeadLetterSingleDeleteRequest request) {
        $this.handleDeleteLetterCommand(request);
    }

    public static final /* synthetic */ boolean access$handleProcessCommand(RSocketDlqResponder $this, DeadLetterProcessRequest request) {
        return $this.handleProcessCommand(request);
    }
}

