/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.eventprocessor;

import io.axoniq.console.framework.api.ProcessorSegmentId;
import io.axoniq.console.framework.api.ProcessorStatusReport;
import io.axoniq.console.framework.api.ResetDecision;
import io.axoniq.console.framework.api.SegmentOverview;
import io.axoniq.console.framework.client.RSocketHandlerRegistrar;
import io.axoniq.console.framework.eventprocessor.EventProcessorManager;
import io.axoniq.console.framework.eventprocessor.ProcessorReportCreator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.lifecycle.Lifecycle;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/axoniq/console/framework/eventprocessor/RSocketProcessorResponder;", "Lorg/axonframework/lifecycle/Lifecycle;", "eventProcessorManager", "Lio/axoniq/console/framework/eventprocessor/EventProcessorManager;", "processorReportCreator", "Lio/axoniq/console/framework/eventprocessor/ProcessorReportCreator;", "registrar", "Lio/axoniq/console/framework/client/RSocketHandlerRegistrar;", "(Lio/axoniq/console/framework/eventprocessor/EventProcessorManager;Lio/axoniq/console/framework/eventprocessor/ProcessorReportCreator;Lio/axoniq/console/framework/client/RSocketHandlerRegistrar;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handleClaim", "", "processorSegmentId", "Lio/axoniq/console/framework/api/ProcessorSegmentId;", "handleMerge", "handleRelease", "", "handleReset", "resetDecision", "Lio/axoniq/console/framework/api/ResetDecision;", "handleSegmentQuery", "Lio/axoniq/console/framework/api/SegmentOverview;", "processor", "", "handleSplit", "handleStart", "processorName", "handleStatusQuery", "Lio/axoniq/console/framework/api/ProcessorStatusReport;", "handleStop", "registerLifecycleHandlers", "registry", "Lorg/axonframework/lifecycle/Lifecycle$LifecycleRegistry;", "start", "console-framework-client"})
public class RSocketProcessorResponder
implements Lifecycle {
    @NotNull
    private final EventProcessorManager eventProcessorManager;
    @NotNull
    private final ProcessorReportCreator processorReportCreator;
    @NotNull
    private final RSocketHandlerRegistrar registrar;
    private final Logger logger;

    public RSocketProcessorResponder(@NotNull EventProcessorManager eventProcessorManager, @NotNull ProcessorReportCreator processorReportCreator, @NotNull RSocketHandlerRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)eventProcessorManager, (String)"eventProcessorManager");
        Intrinsics.checkNotNullParameter((Object)processorReportCreator, (String)"processorReportCreator");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        this.eventProcessorManager = eventProcessorManager;
        this.processorReportCreator = processorReportCreator;
        this.registrar = registrar;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void registerLifecycleHandlers(@NotNull Lifecycle.LifecycleRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.onStart(-134217728, this::start);
    }

    public final void start() {
        this.registrar.registerHandlerWithPayload("processor-command-start", String.class, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketProcessorResponder.access$handleStart((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-stop", String.class, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketProcessorResponder.access$handleStop((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithoutPayload("event-processor-status", (Function0<? extends Object>)((Function0)new Function0<ProcessorStatusReport>((Object)this){

            @NotNull
            public final ProcessorStatusReport invoke() {
                return RSocketProcessorResponder.access$handleStatusQuery((RSocketProcessorResponder)this.receiver);
            }
        }));
        this.registrar.registerHandlerWithPayload("event-processor-segments", String.class, (Function1)new Function1<String, SegmentOverview>((Object)this){

            @NotNull
            public final SegmentOverview invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketProcessorResponder.access$handleSegmentQuery((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-release-segment", ProcessorSegmentId.class, (Function1)new Function1<ProcessorSegmentId, Unit>((Object)this){

            public final void invoke(@NotNull ProcessorSegmentId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((RSocketProcessorResponder)this.receiver).handleRelease(p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-split-segment", ProcessorSegmentId.class, (Function1)new Function1<ProcessorSegmentId, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull ProcessorSegmentId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketProcessorResponder.access$handleSplit((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-merge-segment", ProcessorSegmentId.class, (Function1)new Function1<ProcessorSegmentId, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull ProcessorSegmentId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketProcessorResponder.access$handleMerge((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-reset", ResetDecision.class, (Function1)new Function1<ResetDecision, Unit>((Object)this){

            public final void invoke(@NotNull ResetDecision p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketProcessorResponder.access$handleReset((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("event-processor-claim", ProcessorSegmentId.class, (Function1)new Function1<ProcessorSegmentId, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull ProcessorSegmentId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((RSocketProcessorResponder)this.receiver).handleClaim(p0);
            }
        });
    }

    private final void handleStart(String processorName) {
        this.logger.debug("Handling AxonIQ Console START command for processor [{}]", (Object)processorName);
        this.eventProcessorManager.start(processorName);
    }

    private final void handleStop(String processorName) {
        this.logger.debug("Handling AxonIQ Console STOP command for processor [{}]", (Object)processorName);
        this.eventProcessorManager.stop(processorName);
    }

    private final ProcessorStatusReport handleStatusQuery() {
        this.logger.debug("Handling AxonIQ Console STATUS query");
        return this.processorReportCreator.createReport();
    }

    private final SegmentOverview handleSegmentQuery(String processor) {
        this.logger.debug("Handling AxonIQ Console SEGMENTS query for processor [{}]", (Object)processor);
        return this.processorReportCreator.createSegmentOverview(processor);
    }

    public final void handleRelease(@NotNull ProcessorSegmentId processorSegmentId) {
        Intrinsics.checkNotNullParameter((Object)processorSegmentId, (String)"processorSegmentId");
        this.logger.debug("Handling AxonIQ Console RELEASE command for processor [{}] and segment [{}]", (Object)processorSegmentId.getProcessorName(), (Object)processorSegmentId.getSegmentId());
        this.eventProcessorManager.releaseSegment(processorSegmentId.getProcessorName(), processorSegmentId.getSegmentId());
    }

    private final boolean handleSplit(ProcessorSegmentId processorSegmentId) {
        this.logger.debug("Handling AxonIQ Console SPLIT command for processor [{}] and segment [{}]", (Object)processorSegmentId.getProcessorName(), (Object)processorSegmentId.getSegmentId());
        Boolean bl = this.eventProcessorManager.splitSegment(processorSegmentId.getProcessorName(), processorSegmentId.getSegmentId());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"splitSegment(...)");
        return bl;
    }

    private final boolean handleMerge(ProcessorSegmentId processorSegmentId) {
        this.logger.debug("Handling AxonIQ Console MERGE command for processor [{}] and segment [{}]", (Object)processorSegmentId.getProcessorName(), (Object)processorSegmentId.getSegmentId());
        Boolean bl = this.eventProcessorManager.mergeSegment(processorSegmentId.getProcessorName(), processorSegmentId.getSegmentId());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"mergeSegment(...)");
        return bl;
    }

    private final void handleReset(ResetDecision resetDecision) {
        this.logger.debug("Handling AxonIQ Console RESET command for processor [{}]", (Object)resetDecision.getProcessorName());
        this.eventProcessorManager.resetTokens(resetDecision);
    }

    public final boolean handleClaim(@NotNull ProcessorSegmentId processorSegmentId) {
        Intrinsics.checkNotNullParameter((Object)processorSegmentId, (String)"processorSegmentId");
        this.logger.debug("Handling AxonIQ Console CLAIM command for processor [{}] and segment [{}]", (Object)processorSegmentId.getProcessorName(), (Object)processorSegmentId.getSegmentId());
        return this.eventProcessorManager.claimSegment(processorSegmentId.getProcessorName(), processorSegmentId.getSegmentId());
    }

    public static final /* synthetic */ void access$handleStart(RSocketProcessorResponder $this, String processorName) {
        $this.handleStart(processorName);
    }

    public static final /* synthetic */ void access$handleStop(RSocketProcessorResponder $this, String processorName) {
        $this.handleStop(processorName);
    }

    public static final /* synthetic */ ProcessorStatusReport access$handleStatusQuery(RSocketProcessorResponder $this) {
        return $this.handleStatusQuery();
    }

    public static final /* synthetic */ SegmentOverview access$handleSegmentQuery(RSocketProcessorResponder $this, String processor) {
        return $this.handleSegmentQuery(processor);
    }

    public static final /* synthetic */ boolean access$handleSplit(RSocketProcessorResponder $this, ProcessorSegmentId processorSegmentId) {
        return $this.handleSplit(processorSegmentId);
    }

    public static final /* synthetic */ boolean access$handleMerge(RSocketProcessorResponder $this, ProcessorSegmentId processorSegmentId) {
        return $this.handleMerge(processorSegmentId);
    }

    public static final /* synthetic */ void access$handleReset(RSocketProcessorResponder $this, ResetDecision resetDecision) {
        $this.handleReset(resetDecision);
    }
}

