/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.eventprocessor.metrics;

import io.axoniq.console.framework.UtilsKt;
import io.axoniq.console.framework.eventprocessor.metrics.ProcessorMetricsRegistry;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.BatchingUnitOfWork;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0006J;\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000f0\u0012\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00042\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0006J\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0017J\u001e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0017R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/axoniq/console/framework/eventprocessor/metrics/ProcessorMetricsRegistry;", "", "()V", "commitLatencyRegistry", "", "", "", "Lio/axoniq/console/framework/eventprocessor/metrics/ProcessorMetricsRegistry$ExpiringLatencyValue;", "ingestLatencyRegistry", "processingLatencyRegistry", "Ljava/time/Instant;", "commitLatencyForProcessor", "processor", "segment", "doWithActiveMessageForSegment", "T", "messageTimestamp", "action", "Lkotlin/Function0;", "(Ljava/lang/String;ILjava/time/Instant;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getProcessingLatencySegmentMap", "ingestLatencyForProcessor", "processingMessageLatencyForProcessor", "", "(Ljava/lang/String;I)Ljava/lang/Long;", "registerCommitted", "", "latencyInNanos", "registerIngested", "ExpiringLatencyValue", "console-framework-client"})
public final class ProcessorMetricsRegistry {
    @NotNull
    private final Map<String, Map<Integer, ExpiringLatencyValue>> ingestLatencyRegistry = new ConcurrentHashMap();
    @NotNull
    private final Map<String, Map<Integer, ExpiringLatencyValue>> commitLatencyRegistry = new ConcurrentHashMap();
    @NotNull
    private final Map<String, Map<Integer, Instant>> processingLatencyRegistry = new ConcurrentHashMap();

    public final void registerIngested(@NotNull String processor, int segment, long latencyInNanos) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.ingestLatencyForProcessor(processor, segment).setValue((double)latencyInNanos / (double)1000000);
    }

    public final void registerCommitted(@NotNull String processor, int segment, long latencyInNanos) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.commitLatencyForProcessor(processor, segment).setValue((double)latencyInNanos / (double)1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T doWithActiveMessageForSegment(@NotNull String processor, int segment, @NotNull Instant messageTimestamp, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)messageTimestamp, (String)"messageTimestamp");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map<Integer, Instant> processingMessageTimestampsForSegment = this.getProcessingLatencySegmentMap(processor);
        try {
            Integer n = segment;
            processingMessageTimestampsForSegment.put(n, messageTimestamp);
            object = action.invoke();
        }
        catch (Throwable throwable) {
            UnitOfWork uow = CurrentUnitOfWork.get();
            if (!(uow instanceof BatchingUnitOfWork) || ((BatchingUnitOfWork)uow).isFirstMessage()) {
                uow.afterCommit(new Consumer(this, processor, segment){
                    final /* synthetic */ ProcessorMetricsRegistry this$0;
                    final /* synthetic */ String $processor;
                    final /* synthetic */ int $segment;
                    {
                        this.this$0 = $receiver;
                        this.$processor = $processor;
                        this.$segment = $segment;
                    }

                    public final void accept(UnitOfWork<? extends Message<?>> it) {
                        ProcessorMetricsRegistry.access$getProcessingLatencySegmentMap(this.this$0, this.$processor).remove(this.$segment);
                    }
                });
            }
            throw throwable;
        }
        UnitOfWork uow = CurrentUnitOfWork.get();
        if (!(uow instanceof BatchingUnitOfWork) || ((BatchingUnitOfWork)uow).isFirstMessage()) {
            uow.afterCommit(new /* invalid duplicate definition of identical inner class */);
        }
        return (T)object;
    }

    @NotNull
    public final ExpiringLatencyValue ingestLatencyForProcessor(@NotNull String processor, int segment) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return (ExpiringLatencyValue)UtilsKt.computeIfAbsentWithRetry$default((Map)UtilsKt.computeIfAbsentWithRetry$default(this.ingestLatencyRegistry, processor, 0, ingestLatencyForProcessor.1.INSTANCE, 2, null), segment, 0, ingestLatencyForProcessor.2.INSTANCE, 2, null);
    }

    @NotNull
    public final ExpiringLatencyValue commitLatencyForProcessor(@NotNull String processor, int segment) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return (ExpiringLatencyValue)UtilsKt.computeIfAbsentWithRetry$default((Map)UtilsKt.computeIfAbsentWithRetry$default(this.commitLatencyRegistry, processor, 0, commitLatencyForProcessor.1.INSTANCE, 2, null), segment, 0, commitLatencyForProcessor.2.INSTANCE, 2, null);
    }

    @Nullable
    public final Long processingMessageLatencyForProcessor(@NotNull String processor, int segment) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Instant processingTimestamp2 = (Instant)UtilsKt.computeIfAbsentWithRetry$default(this.getProcessingLatencySegmentMap(processor), segment, 0, processingMessageLatencyForProcessor.processingTimestamp.1.INSTANCE, 2, null);
        if (processingTimestamp2 == null) {
            return null;
        }
        return ChronoUnit.MILLIS.between(processingTimestamp2, Instant.now());
    }

    private final Map<Integer, Instant> getProcessingLatencySegmentMap(String processor) {
        return (Map)UtilsKt.computeIfAbsentWithRetry$default(this.processingLatencyRegistry, processor, 0, getProcessingLatencySegmentMap.1.INSTANCE, 2, null);
    }

    public static final /* synthetic */ Map access$getProcessingLatencySegmentMap(ProcessorMetricsRegistry $this, String processor) {
        return $this.getProcessingLatencySegmentMap(processor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/axoniq/console/framework/eventprocessor/metrics/ProcessorMetricsRegistry$ExpiringLatencyValue;", "", "expiryTime", "", "(J)V", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "timeSet", "Ljava/util/concurrent/atomic/AtomicLong;", "value", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getValue", "setValue", "", "newValue", "console-framework-client"})
    public static final class ExpiringLatencyValue {
        private final long expiryTime;
        private final Clock clock;
        @NotNull
        private final AtomicReference<Double> value;
        @NotNull
        private final AtomicLong timeSet;

        public ExpiringLatencyValue(long expiryTime) {
            this.expiryTime = expiryTime;
            this.clock = Clock.systemUTC();
            this.value = new AtomicReference<Double>(-1.0);
            this.timeSet = new AtomicLong(-1L);
        }

        public /* synthetic */ ExpiringLatencyValue(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 30 * 60 * 1000;
            }
            this(l);
        }

        public final void setValue(double newValue) {
            this.value.set(newValue);
            this.timeSet.set(this.clock.millis());
        }

        public final double getValue() {
            if (this.value.get() != null && this.clock.millis() - this.timeSet.get() < this.expiryTime) {
                Double d = this.value.get();
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
                return ((Number)d).doubleValue();
            }
            return 0.0;
        }

        public ExpiringLatencyValue() {
            this(0L, 1, null);
        }
    }
}

