/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.console.framework.messaging;

import io.axoniq.console.framework.api.AxoniqConsoleMessageOrigin;
import io.axoniq.console.framework.api.ComponentPayload;
import io.axoniq.console.framework.api.metrics.DispatcherStatisticIdentifier;
import io.axoniq.console.framework.api.metrics.HandlerStatisticsMetricIdentifier;
import io.axoniq.console.framework.api.metrics.HandlerType;
import io.axoniq.console.framework.api.metrics.MessageIdentifier;
import io.axoniq.console.framework.messaging.AxoniqConsoleSpanFactory;
import io.axoniq.console.framework.messaging.ExtensionsKt;
import io.axoniq.console.framework.messaging.HandlerMetricsRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J6\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\t2\u0012\u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0002*\u0006\u0012\u0002\b\u00030\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/axoniq/console/framework/messaging/AxoniqConsoleDispatchInterceptor;", "Lorg/axonframework/messaging/MessageDispatchInterceptor;", "Lorg/axonframework/messaging/Message;", "registry", "Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry;", "componentName", "", "(Lio/axoniq/console/framework/messaging/HandlerMetricsRegistry;Ljava/lang/String;)V", "handle", "Ljava/util/function/BiFunction;", "", "messages", "", "reportMessageDispatchedFromOrigin", "", "originName", "message", "unwrap", "console-framework-client"})
public final class AxoniqConsoleDispatchInterceptor
implements MessageDispatchInterceptor<Message<?>> {
    @NotNull
    private final HandlerMetricsRegistry registry;
    @NotNull
    private final String componentName;

    public AxoniqConsoleDispatchInterceptor(@NotNull HandlerMetricsRegistry registry, @NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.registry = registry;
        this.componentName = componentName;
    }

    @NotNull
    public BiFunction<Integer, Message<?>, Message<?>> handle(@NotNull List<? extends Message<?>> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return (arg_0, arg_1) -> AxoniqConsoleDispatchInterceptor.handle$lambda$0(this, arg_0, arg_1);
    }

    private final void reportMessageDispatchedFromOrigin(String originName, Message<?> message) {
        this.registry.registerMessageDispatchedDuringHandling(new DispatcherStatisticIdentifier(new HandlerStatisticsMetricIdentifier(HandlerType.Origin, originName, new MessageIdentifier("Dispatcher", originName)), ExtensionsKt.toInformation(message)));
    }

    private final Message<?> unwrap(Message<?> $this$unwrap) {
        Object payload = $this$unwrap.getPayload();
        if (payload instanceof ComponentPayload) {
            if ($this$unwrap instanceof GenericCommandMessage && ((ComponentPayload)payload).getPayload() != null) {
                CommandMessage commandMessage = GenericCommandMessage.asCommandMessage(((ComponentPayload)payload).getPayload()).andMetaData((Map)((GenericCommandMessage)$this$unwrap).getMetaData());
                Intrinsics.checkNotNullExpressionValue((Object)commandMessage, (String)"andMetaData(...)");
                return (Message)commandMessage;
            }
            if ($this$unwrap instanceof SubscriptionQueryMessage) {
                GenericSubscriptionQueryMessage genericSubscriptionQueryMessage = new GenericSubscriptionQueryMessage(((ComponentPayload)payload).getPayload(), ((SubscriptionQueryMessage)$this$unwrap).getResponseType(), ((SubscriptionQueryMessage)$this$unwrap).getUpdateResponseType()).andMetaData((Map)((SubscriptionQueryMessage)$this$unwrap).getMetaData());
                Intrinsics.checkNotNullExpressionValue((Object)genericSubscriptionQueryMessage, (String)"andMetaData(...)");
                return (Message)genericSubscriptionQueryMessage;
            }
            if ($this$unwrap instanceof QueryMessage) {
                QueryMessage queryMessage = new GenericQueryMessage(((ComponentPayload)payload).getPayload(), ((QueryMessage)$this$unwrap).getResponseType()).andMetaData((Map)((QueryMessage)$this$unwrap).getMetaData());
                Intrinsics.checkNotNullExpressionValue((Object)queryMessage, (String)"andMetaData(...)");
                return (Message)queryMessage;
            }
            if ($this$unwrap instanceof EventMessage) {
                GenericEventMessage genericEventMessage = new GenericEventMessage(((ComponentPayload)payload).getPayload()).andMetaData((Map)((EventMessage)$this$unwrap).getMetaData());
                Intrinsics.checkNotNullExpressionValue((Object)genericEventMessage, (String)"andMetaData(...)");
                return (Message)genericEventMessage;
            }
        }
        return $this$unwrap;
    }

    private static final Message handle$lambda$0(AxoniqConsoleDispatchInterceptor this$0, Integer n, Message message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)n, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Class<?> payload = message.getPayload();
        if (!CurrentUnitOfWork.isStarted()) {
            String string;
            if (payload instanceof ComponentPayload) {
                string = ((ComponentPayload)((Object)payload)).getComponent();
            } else {
                Class<?> clazz = payload;
                boolean bl = clazz != null && (clazz = clazz.getClass()) != null ? clazz.isAnnotationPresent(AxoniqConsoleMessageOrigin.class) : false;
                if (bl) {
                    Intrinsics.checkNotNull(payload);
                    string = payload.getClass().getAnnotation(AxoniqConsoleMessageOrigin.class).name();
                } else {
                    string = this$0.componentName;
                }
            }
            String origin = string;
            this$0.reportMessageDispatchedFromOrigin(origin, message);
        } else {
            AxoniqConsoleSpanFactory.Companion.onTopLevelSpanIfActive((Function1<? super AxoniqConsoleSpanFactory.MeasuringConsoleSpan, Unit>)((Function1)new Function1<AxoniqConsoleSpanFactory.MeasuringConsoleSpan, Unit>(message){
                final /* synthetic */ Message<?> $message;
                {
                    this.$message = $message;
                    super(1);
                }

                public final void invoke(@NotNull AxoniqConsoleSpanFactory.MeasuringConsoleSpan it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Message<?> message = this.$message;
                    Intrinsics.checkNotNullExpressionValue(message, (String)"$message");
                    it.registerMessageDispatched(ExtensionsKt.toInformation(message));
                }
            }));
        }
        return this$0.unwrap(message);
    }
}

