/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.inspector.client;

import io.axoniq.inspector.client.RSocketHandlerRegistrar;
import io.axoniq.inspector.client.strategy.RSocketPayloadEncodingStrategy;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.metadata.CompositeMetadata;
import io.rsocket.metadata.RoutingMetadata;
import io.rsocket.metadata.WellKnownMimeType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003!\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001J,\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u0018\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u000e0\u001dJ\u001c\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fJ\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/axoniq/inspector/client/RSocketHandlerRegistrar;", "Lio/rsocket/RSocket;", "encodingStrategy", "Lio/axoniq/inspector/client/strategy/RSocketPayloadEncodingStrategy;", "(Lio/axoniq/inspector/client/strategy/RSocketPayloadEncodingStrategy;)V", "handlers", "", "Lio/axoniq/inspector/client/RSocketHandlerRegistrar$RegisteredRsocketMessageHandler;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createRespondingRSocketFor", "rSocket", "handleMessageWithPayload", "", "T", "matchingHandler", "Lio/axoniq/inspector/client/RSocketHandlerRegistrar$PayloadRegisteredRsocketMessageHandler;", "payload", "Lio/rsocket/Payload;", "route", "", "handleMessageWithoutPayload", "Lio/axoniq/inspector/client/RSocketHandlerRegistrar$PayloadlessRegisteredRsocketMessageHandler;", "registerHandlerWithPayload", "", "payloadType", "Ljava/lang/Class;", "handler", "Lkotlin/Function1;", "registerHandlerWithoutPayload", "Lkotlin/Function0;", "routeFromPayload", "PayloadRegisteredRsocketMessageHandler", "PayloadlessRegisteredRsocketMessageHandler", "RegisteredRsocketMessageHandler", "inspector-axon"})
@SourceDebugExtension(value={"SMAP\nRSocketHandlerRegistrar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RSocketHandlerRegistrar.kt\nio/axoniq/inspector/client/RSocketHandlerRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n286#2,2:111\n*S KotlinDebug\n*F\n+ 1 RSocketHandlerRegistrar.kt\nio/axoniq/inspector/client/RSocketHandlerRegistrar\n*L\n89#1:111,2\n*E\n"})
public final class RSocketHandlerRegistrar
implements RSocket {
    @NotNull
    private final RSocketPayloadEncodingStrategy encodingStrategy;
    private final Logger logger;
    @NotNull
    private final List<RegisteredRsocketMessageHandler> handlers;

    public RSocketHandlerRegistrar(@NotNull RSocketPayloadEncodingStrategy encodingStrategy) {
        Intrinsics.checkNotNullParameter((Object)encodingStrategy, (String)"encodingStrategy");
        this.encodingStrategy = encodingStrategy;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.handlers = new ArrayList();
    }

    public final void registerHandlerWithoutPayload(@NotNull String route, @NotNull Function0<? extends Object> handler) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.logger.info("Registered Inspector handler for route {}", (Object)route);
        this.handlers.add(new PayloadlessRegisteredRsocketMessageHandler(route, handler));
    }

    public final <T> void registerHandlerWithPayload(@NotNull String route, @NotNull Class<T> payloadType, @NotNull Function1<? super T, ? extends Object> handler) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter(payloadType, (String)"payloadType");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.logger.info("Registered Inspector handler for route {}", (Object)route);
        this.handlers.add(new PayloadRegisteredRsocketMessageHandler<T>(route, payloadType, handler));
    }

    @NotNull
    public final RSocket createRespondingRSocketFor(@NotNull RSocket rSocket) {
        Intrinsics.checkNotNullParameter((Object)rSocket, (String)"rSocket");
        return new RSocket(this, rSocket){
            final /* synthetic */ RSocketHandlerRegistrar this$0;
            final /* synthetic */ RSocket $rSocket;
            {
                this.this$0 = $receiver;
                this.$rSocket = $rSocket;
            }

            @NotNull
            public Mono<Payload> requestResponse(@NotNull Payload payload) {
                Object object;
                Object v1;
                String route;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                    route = RSocketHandlerRegistrar.access$routeFromPayload(this.this$0, payload);
                    if (Intrinsics.areEqual((Object)route, (Object)"authentication_failed")) {
                        RSocketHandlerRegistrar.access$getLogger$p(this.this$0).warn("Authentication to Inspector Axon failed. Are your properties set correctly?");
                        this.$rSocket.dispose();
                        Mono mono = Mono.empty();
                        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty()");
                        return mono;
                    }
                    Iterable $this$firstOrNull$iv = RSocketHandlerRegistrar.access$getHandlers$p(this.this$0);
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        RegisteredRsocketMessageHandler it = (RegisteredRsocketMessageHandler)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getRoute(), (Object)route)) continue;
                        v1 = element$iv;
                        break block7;
                    }
                    v1 = null;
                }
                RegisteredRsocketMessageHandler registeredRsocketMessageHandler = v1;
                if (registeredRsocketMessageHandler == null) {
                    throw new IllegalArgumentException("No handler registered for route " + route);
                }
                RegisteredRsocketMessageHandler matchingHandler = registeredRsocketMessageHandler;
                RegisteredRsocketMessageHandler registeredRsocketMessageHandler2 = matchingHandler;
                if (registeredRsocketMessageHandler2 instanceof PayloadlessRegisteredRsocketMessageHandler) {
                    object = RSocketHandlerRegistrar.access$handleMessageWithoutPayload(this.this$0, (PayloadlessRegisteredRsocketMessageHandler)matchingHandler, route);
                } else if (registeredRsocketMessageHandler2 instanceof PayloadRegisteredRsocketMessageHandler) {
                    object = RSocketHandlerRegistrar.access$handleMessageWithPayload(this.this$0, (PayloadRegisteredRsocketMessageHandler)matchingHandler, payload, route);
                } else {
                    throw new IllegalArgumentException("Unknown handler type - should not happen!");
                }
                Object result = object;
                Mono mono = Mono.just((Object)result).map(arg_0 -> createRespondingRSocketFor.1.requestResponse$lambda$1(this.this$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(result).map { encodingStrategy.encode(it) }");
                return mono;
            }

            private static final Payload requestResponse$lambda$1(RSocketHandlerRegistrar this$0, Object it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                RSocketPayloadEncodingStrategy rSocketPayloadEncodingStrategy = RSocketHandlerRegistrar.access$getEncodingStrategy$p(this$0);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return RSocketPayloadEncodingStrategy.DefaultImpls.encode$default(rSocketPayloadEncodingStrategy, it, null, 2, null);
            }
        };
    }

    private final Object handleMessageWithoutPayload(PayloadlessRegisteredRsocketMessageHandler matchingHandler, String route) {
        this.logger.info("Received Inspector Axon message for route [" + route + "] without payload");
        return matchingHandler.getHandler().invoke();
    }

    private final <T> Object handleMessageWithPayload(PayloadRegisteredRsocketMessageHandler<T> matchingHandler, Payload payload, String route) {
        T decodedPayload = this.encodingStrategy.decode(payload, matchingHandler.getPayloadType());
        this.logger.info("Received Inspector Axon message for route [" + route + "] with payload: [{}]", decodedPayload);
        return matchingHandler.getHandler().invoke(decodedPayload);
    }

    private final String routeFromPayload(Payload payload) {
        Object v0;
        block3: {
            CompositeMetadata compositeMetadata = new CompositeMetadata(payload.metadata(), false);
            Iterable $this$firstOrNull$iv = (Iterable)compositeMetadata;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CompositeMetadata.Entry it = (CompositeMetadata.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMimeType(), (Object)WellKnownMimeType.MESSAGE_RSOCKET_ROUTING.getString())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        CompositeMetadata.Entry entry = v0;
        if (entry == null) {
            throw new IllegalArgumentException("Request contained no route metadata!");
        }
        CompositeMetadata.Entry routeMetadata = entry;
        String string = (String)new RoutingMetadata(routeMetadata.getContent()).iterator().next();
        if (string == null) {
            throw new IllegalArgumentException("Request contained no route metadata!");
        }
        return string;
    }

    public static final /* synthetic */ String access$routeFromPayload(RSocketHandlerRegistrar $this, Payload payload) {
        return $this.routeFromPayload(payload);
    }

    public static final /* synthetic */ Logger access$getLogger$p(RSocketHandlerRegistrar $this) {
        return $this.logger;
    }

    public static final /* synthetic */ List access$getHandlers$p(RSocketHandlerRegistrar $this) {
        return $this.handlers;
    }

    public static final /* synthetic */ Object access$handleMessageWithoutPayload(RSocketHandlerRegistrar $this, PayloadlessRegisteredRsocketMessageHandler matchingHandler, String route) {
        return $this.handleMessageWithoutPayload(matchingHandler, route);
    }

    public static final /* synthetic */ Object access$handleMessageWithPayload(RSocketHandlerRegistrar $this, PayloadRegisteredRsocketMessageHandler matchingHandler, Payload payload, String route) {
        return $this.handleMessageWithPayload(matchingHandler, payload, route);
    }

    public static final /* synthetic */ RSocketPayloadEncodingStrategy access$getEncodingStrategy$p(RSocketHandlerRegistrar $this) {
        return $this.encodingStrategy;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J?\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lio/axoniq/inspector/client/RSocketHandlerRegistrar$PayloadRegisteredRsocketMessageHandler;", "T", "Lio/axoniq/inspector/client/RSocketHandlerRegistrar$RegisteredRsocketMessageHandler;", "route", "", "payloadType", "Ljava/lang/Class;", "handler", "Lkotlin/Function1;", "", "(Ljava/lang/String;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "getHandler", "()Lkotlin/jvm/functions/Function1;", "getPayloadType", "()Ljava/lang/Class;", "getRoute", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "inspector-axon"})
    private static final class PayloadRegisteredRsocketMessageHandler<T>
    implements RegisteredRsocketMessageHandler {
        @NotNull
        private final String route;
        @NotNull
        private final Class<T> payloadType;
        @NotNull
        private final Function1<T, Object> handler;

        public PayloadRegisteredRsocketMessageHandler(@NotNull String route, @NotNull Class<T> payloadType, @NotNull Function1<? super T, ? extends Object> handler) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Intrinsics.checkNotNullParameter(payloadType, (String)"payloadType");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.route = route;
            this.payloadType = payloadType;
            this.handler = handler;
        }

        @Override
        @NotNull
        public String getRoute() {
            return this.route;
        }

        @NotNull
        public final Class<T> getPayloadType() {
            return this.payloadType;
        }

        @NotNull
        public final Function1<T, Object> getHandler() {
            return this.handler;
        }

        @NotNull
        public final String component1() {
            return this.getRoute();
        }

        @NotNull
        public final Class<T> component2() {
            return this.payloadType;
        }

        @NotNull
        public final Function1<T, Object> component3() {
            return this.handler;
        }

        @NotNull
        public final PayloadRegisteredRsocketMessageHandler<T> copy(@NotNull String route, @NotNull Class<T> payloadType, @NotNull Function1<? super T, ? extends Object> handler) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Intrinsics.checkNotNullParameter(payloadType, (String)"payloadType");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            return new PayloadRegisteredRsocketMessageHandler<T>(route, payloadType, handler);
        }

        public static /* synthetic */ PayloadRegisteredRsocketMessageHandler copy$default(PayloadRegisteredRsocketMessageHandler payloadRegisteredRsocketMessageHandler, String string, Class clazz, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = payloadRegisteredRsocketMessageHandler.getRoute();
            }
            if ((n & 2) != 0) {
                clazz = payloadRegisteredRsocketMessageHandler.payloadType;
            }
            if ((n & 4) != 0) {
                function1 = payloadRegisteredRsocketMessageHandler.handler;
            }
            return payloadRegisteredRsocketMessageHandler.copy(string, clazz, function1);
        }

        @NotNull
        public String toString() {
            return "PayloadRegisteredRsocketMessageHandler(route=" + this.getRoute() + ", payloadType=" + this.payloadType + ", handler=" + this.handler + ')';
        }

        public int hashCode() {
            int result = this.getRoute().hashCode();
            result = result * 31 + this.payloadType.hashCode();
            result = result * 31 + this.handler.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PayloadRegisteredRsocketMessageHandler)) {
                return false;
            }
            PayloadRegisteredRsocketMessageHandler payloadRegisteredRsocketMessageHandler = (PayloadRegisteredRsocketMessageHandler)other;
            if (!Intrinsics.areEqual((Object)this.getRoute(), (Object)payloadRegisteredRsocketMessageHandler.getRoute())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.payloadType, payloadRegisteredRsocketMessageHandler.payloadType)) {
                return false;
            }
            return Intrinsics.areEqual(this.handler, payloadRegisteredRsocketMessageHandler.handler);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/axoniq/inspector/client/RSocketHandlerRegistrar$PayloadlessRegisteredRsocketMessageHandler;", "Lio/axoniq/inspector/client/RSocketHandlerRegistrar$RegisteredRsocketMessageHandler;", "route", "", "handler", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getHandler", "()Lkotlin/jvm/functions/Function0;", "getRoute", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "inspector-axon"})
    private static final class PayloadlessRegisteredRsocketMessageHandler
    implements RegisteredRsocketMessageHandler {
        @NotNull
        private final String route;
        @NotNull
        private final Function0<Object> handler;

        public PayloadlessRegisteredRsocketMessageHandler(@NotNull String route, @NotNull Function0<? extends Object> handler) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.route = route;
            this.handler = handler;
        }

        @Override
        @NotNull
        public String getRoute() {
            return this.route;
        }

        @NotNull
        public final Function0<Object> getHandler() {
            return this.handler;
        }

        @NotNull
        public final String component1() {
            return this.getRoute();
        }

        @NotNull
        public final Function0<Object> component2() {
            return this.handler;
        }

        @NotNull
        public final PayloadlessRegisteredRsocketMessageHandler copy(@NotNull String route, @NotNull Function0<? extends Object> handler) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            return new PayloadlessRegisteredRsocketMessageHandler(route, handler);
        }

        public static /* synthetic */ PayloadlessRegisteredRsocketMessageHandler copy$default(PayloadlessRegisteredRsocketMessageHandler payloadlessRegisteredRsocketMessageHandler, String string, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                string = payloadlessRegisteredRsocketMessageHandler.getRoute();
            }
            if ((n & 2) != 0) {
                function0 = payloadlessRegisteredRsocketMessageHandler.handler;
            }
            return payloadlessRegisteredRsocketMessageHandler.copy(string, function0);
        }

        @NotNull
        public String toString() {
            return "PayloadlessRegisteredRsocketMessageHandler(route=" + this.getRoute() + ", handler=" + this.handler + ')';
        }

        public int hashCode() {
            int result = this.getRoute().hashCode();
            result = result * 31 + this.handler.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PayloadlessRegisteredRsocketMessageHandler)) {
                return false;
            }
            PayloadlessRegisteredRsocketMessageHandler payloadlessRegisteredRsocketMessageHandler = (PayloadlessRegisteredRsocketMessageHandler)other;
            if (!Intrinsics.areEqual((Object)this.getRoute(), (Object)payloadlessRegisteredRsocketMessageHandler.getRoute())) {
                return false;
            }
            return Intrinsics.areEqual(this.handler, payloadlessRegisteredRsocketMessageHandler.handler);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/axoniq/inspector/client/RSocketHandlerRegistrar$RegisteredRsocketMessageHandler;", "", "route", "", "getRoute", "()Ljava/lang/String;", "inspector-axon"})
    private static interface RegisteredRsocketMessageHandler {
        @NotNull
        public String getRoute();
    }
}

