/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.inspector.client;

import io.axoniq.inspector.AxonInspectorProperties;
import io.axoniq.inspector.api.InspectorClientAuthentication;
import io.axoniq.inspector.api.InspectorClientIdentifier;
import io.axoniq.inspector.client.RSocketHandlerRegistrar;
import io.axoniq.inspector.client.SetupPayloadCreator;
import io.axoniq.inspector.client.UtilsKt;
import io.axoniq.inspector.client.strategy.RSocketPayloadEncodingStrategy;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.ConnectionSetupPayload;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.axonframework.lifecycle.Lifecycle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u0010J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u0019J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/axoniq/inspector/client/RSocketInspectorClient;", "Lorg/axonframework/lifecycle/Lifecycle;", "properties", "Lio/axoniq/inspector/AxonInspectorProperties;", "setupPayloadCreator", "Lio/axoniq/inspector/client/SetupPayloadCreator;", "registrar", "Lio/axoniq/inspector/client/RSocketHandlerRegistrar;", "encodingStrategy", "Lio/axoniq/inspector/client/strategy/RSocketPayloadEncodingStrategy;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "nodeName", "", "(Lio/axoniq/inspector/AxonInspectorProperties;Lio/axoniq/inspector/client/SetupPayloadCreator;Lio/axoniq/inspector/client/RSocketHandlerRegistrar;Lio/axoniq/inspector/client/strategy/RSocketPayloadEncodingStrategy;Ljava/util/concurrent/ScheduledExecutorService;Ljava/lang/String;)V", "connected", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rsocket", "Lio/rsocket/RSocket;", "scheduledReconnector", "Ljava/util/concurrent/ScheduledFuture;", "connect", "", "createRSocket", "createRoutingMetadata", "Lio/netty/buffer/CompositeByteBuf;", "route", "createSetupMetadata", "auth", "Lio/axoniq/inspector/api/InspectorClientAuthentication;", "dispose", "isConnected", "registerLifecycleHandlers", "registry", "Lorg/axonframework/lifecycle/Lifecycle$LifecycleRegistry;", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "payload", "", "start", "tcpClient", "Lreactor/netty/tcp/TcpClient;", "tcpClientTransport", "Lio/rsocket/transport/netty/client/TcpClientTransport;", "inspector-axon"})
public final class RSocketInspectorClient
implements Lifecycle {
    @NotNull
    private final AxonInspectorProperties properties;
    @NotNull
    private final SetupPayloadCreator setupPayloadCreator;
    @NotNull
    private final RSocketHandlerRegistrar registrar;
    @NotNull
    private final RSocketPayloadEncodingStrategy encodingStrategy;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final String nodeName;
    @Nullable
    private ScheduledFuture<?> scheduledReconnector;
    private final Logger logger;
    private RSocket rsocket;
    private boolean connected;

    public RSocketInspectorClient(@NotNull AxonInspectorProperties properties, @NotNull SetupPayloadCreator setupPayloadCreator, @NotNull RSocketHandlerRegistrar registrar, @NotNull RSocketPayloadEncodingStrategy encodingStrategy, @NotNull ScheduledExecutorService executor, @NotNull String nodeName) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)setupPayloadCreator, (String)"setupPayloadCreator");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)encodingStrategy, (String)"encodingStrategy");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        this.properties = properties;
        this.setupPayloadCreator = setupPayloadCreator;
        this.registrar = registrar;
        this.encodingStrategy = encodingStrategy;
        this.executor = executor;
        this.nodeName = nodeName;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ RSocketInspectorClient(AxonInspectorProperties axonInspectorProperties, SetupPayloadCreator setupPayloadCreator, RSocketHandlerRegistrar rSocketHandlerRegistrar, RSocketPayloadEncodingStrategy rSocketPayloadEncodingStrategy, ScheduledExecutorService scheduledExecutorService, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            String string2 = ManagementFactory.getRuntimeMXBean().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRuntimeMXBean().name");
            string = string2;
        }
        this(axonInspectorProperties, setupPayloadCreator, rSocketHandlerRegistrar, rSocketPayloadEncodingStrategy, scheduledExecutorService, string);
    }

    public void registerLifecycleHandlers(@NotNull Lifecycle.LifecycleRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.onStart(-134217728, this::start);
        registry.onShutdown(-134217728, this::dispose);
    }

    @NotNull
    public final Mono<Void> send(@NotNull String route, @NotNull Object payload) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (!this.connected) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty()");
            return mono;
        }
        RSocket rSocket = this.rsocket;
        if (rSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rsocket");
            rSocket = null;
        }
        Mono mono = rSocket.requestResponse(this.encodingStrategy.encode(payload, (ByteBuf)this.createRoutingMetadata(route))).doOnError(arg_0 -> RSocketInspectorClient.send$lambda$0((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ RSocketInspectorClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Throwable it) {
                String string = it.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Access Denied", (boolean)false, (int)2, null) : false;
                if (bl) {
                    RSocketInspectorClient.access$getLogger$p(this.this$0).info("Was unable to send call to Inspector Axon since authentication was incorrect!");
                }
            }
        }, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fun send(route: String, \u2026            .then()\n    }");
        return mono;
    }

    public final void start() {
        this.scheduledReconnector = this.executor.scheduleWithFixedDelay(() -> RSocketInspectorClient.start$lambda$1(this), this.properties.getInitialDelay(), 10000L, TimeUnit.MILLISECONDS);
    }

    public final void connect() {
        try {
            this.rsocket = this.createRSocket();
            this.connected = true;
        }
        catch (Exception e) {
            this.logger.info("Failed to connect to Inspector Axon", (Throwable)e);
        }
    }

    private final RSocket createRSocket() {
        InspectorClientAuthentication authentication = new InspectorClientAuthentication(new InspectorClientIdentifier(this.properties.getWorkspaceId(), this.properties.getEnvironmentId(), this.properties.getApplicationName(), this.nodeName), this.properties.getAccessToken());
        Payload setupPayload = this.encodingStrategy.encode(this.setupPayloadCreator.createReport(), (ByteBuf)this.createSetupMetadata(authentication));
        Object object = RSocketConnector.create().metadataMimeType(WellKnownMimeType.MESSAGE_RSOCKET_COMPOSITE_METADATA.getString()).dataMimeType(this.encodingStrategy.getMimeType().getString()).setupPayload(setupPayload).acceptor((arg_0, arg_1) -> RSocketInspectorClient.createRSocket$lambda$2(this, arg_0, arg_1)).connect((ClientTransport)this.tcpClientTransport()).block();
        Intrinsics.checkNotNull((Object)object);
        RSocket rsocket = (RSocket)object;
        return rsocket;
    }

    private final CompositeByteBuf createRoutingMetadata(String route) {
        CompositeByteBuf compositeByteBuf = ByteBufAllocator.DEFAULT.compositeBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)compositeByteBuf, (String)"DEFAULT.compositeBuffer()");
        CompositeByteBuf metadata = compositeByteBuf;
        UtilsKt.addRouteMetadata(metadata, route);
        return metadata;
    }

    private final CompositeByteBuf createSetupMetadata(InspectorClientAuthentication auth) {
        CompositeByteBuf compositeByteBuf = ByteBufAllocator.DEFAULT.compositeBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)compositeByteBuf, (String)"DEFAULT.compositeBuffer()");
        CompositeByteBuf metadata = compositeByteBuf;
        UtilsKt.addRouteMetadata(metadata, "client");
        UtilsKt.addAuthMetadata(metadata, auth);
        return metadata;
    }

    private final TcpClientTransport tcpClientTransport() {
        TcpClientTransport tcpClientTransport = TcpClientTransport.create((TcpClient)this.tcpClient());
        Intrinsics.checkNotNullExpressionValue((Object)tcpClientTransport, (String)"create(tcpClient())");
        return tcpClientTransport;
    }

    private final TcpClient tcpClient() {
        TcpClient tcpClient2 = TcpClient.create().host(this.properties.getHost()).port(this.properties.getPort()).doOnDisconnected(arg_0 -> RSocketInspectorClient.tcpClient$lambda$3((Function1)new Function1<Connection, Unit>(this){
            final /* synthetic */ RSocketInspectorClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Connection it) {
                RSocketInspectorClient.access$setConnected$p(this.this$0, false);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)tcpClient2, (String)"private fun tcpClient():\u2026      } else client\n    }");
        TcpClient client2 = tcpClient2;
        if (this.properties.getSecure()) {
            TcpClient tcpClient3 = client2.secure();
            Intrinsics.checkNotNullExpressionValue((Object)tcpClient3, (String)"client.secure()");
            return tcpClient3;
        }
        return client2;
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final void dispose() {
        if (this.connected) {
            RSocket rSocket = this.rsocket;
            if (rSocket == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rsocket");
                rSocket = null;
            }
            rSocket.dispose();
        }
        ScheduledFuture<?> scheduledFuture = this.scheduledReconnector;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.scheduledReconnector = null;
    }

    private static final void send$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void start$lambda$1(RSocketInspectorClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.connected) {
            this$0.logger.info("Reconnecting Inspector Axon...");
            this$0.connect();
        }
    }

    private static final Mono createRSocket$lambda$2(RSocketInspectorClient this$0, ConnectionSetupPayload connectionSetupPayload, RSocket rsocket) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)connectionSetupPayload, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)rsocket, (String)"rsocket");
        return Mono.just((Object)this$0.registrar.createRespondingRSocketFor(rsocket));
    }

    private static final void tcpClient$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(RSocketInspectorClient $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setConnected$p(RSocketInspectorClient $this, boolean bl) {
        $this.connected = bl;
    }
}

